/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.gui;

import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.gui.AbstractTableComparatorChooser;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.impl.sort.ComparatorChain;
import ca.odell.glazedlists.impl.sort.ReverseComparator;
import ca.odell.glazedlists.impl.sort.TableColumnComparator;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SortingState {
    private static final Pattern FROM_STRING_PATTERN = Pattern.compile("^\\s*column\\s+(\\d+)(\\s+comparator\\s+(\\d+))?(\\s+(reversed))?\\s*$", 2);
    protected static final int COLUMN_UNSORTED = 0;
    protected static final int COLUMN_PRIMARY_SORTED = 1;
    protected static final int COLUMN_PRIMARY_SORTED_REVERSE = 2;
    protected static final int COLUMN_PRIMARY_SORTED_ALTERNATE = 3;
    protected static final int COLUMN_PRIMARY_SORTED_ALTERNATE_REVERSE = 4;
    protected static final int COLUMN_SECONDARY_SORTED = 5;
    protected static final int COLUMN_SECONDARY_SORTED_REVERSE = 6;
    protected static final int COLUMN_SECONDARY_SORTED_ALTERNATE = 7;
    protected static final int COLUMN_SECONDARY_SORTED_ALTERNATE_REVERSE = 8;
    protected List<SortingColumn> sortingColumns;
    protected List<SortingColumn> recentlyClickedColumns = new ArrayList<SortingColumn>(2);
    private final AbstractTableComparatorChooser tableComparatorChooser;
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public SortingState(AbstractTableComparatorChooser abstractTableComparatorChooser) {
        this.tableComparatorChooser = abstractTableComparatorChooser;
    }

    public AbstractTableComparatorChooser getTableComparatorChooser() {
        return this.tableComparatorChooser;
    }

    public void fireSortingChanged() {
        this.changeSupport.firePropertyChange("comparator", null, null);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public Comparator buildComparator() {
        if (this.recentlyClickedColumns.isEmpty()) {
            return null;
        }
        ArrayList arrayList = new ArrayList(this.recentlyClickedColumns.size());
        for (SortingColumn sortingColumn : this.recentlyClickedColumns) {
            Comparator comparator = sortingColumn.getComparator();
            if (comparator == null) {
                throw new IllegalStateException();
            }
            arrayList.add(comparator);
        }
        return GlazedLists.chainComparators(arrayList);
    }

    public List<Integer> getSortingColumnIndexes() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        List<SortingColumn> list = this.getRecentlyClickedColumns();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            SortingColumn sortingColumn = list.get(i2);
            arrayList.add(new Integer(sortingColumn.getColumn()));
        }
        return arrayList;
    }

    public void appendComparator(int n2, int n3, boolean bl) {
        if (n2 > this.getColumns().size()) {
            throw new IllegalArgumentException("invalid column " + n2 + ", must be in range 0, " + this.sortingColumns.size());
        }
        if (n3 >= this.sortingColumns.get(n2).getComparators().size()) {
            throw new IllegalArgumentException("invalid comparator index " + n3 + ", must be in range 0, " + this.sortingColumns.get(n2).getComparators().size());
        }
        if (this.recentlyClickedColumns.contains(this.getColumns().get(n2))) {
            return;
        }
        SortingColumn sortingColumn = this.sortingColumns.get(n2);
        sortingColumn.setComparatorIndex(n3);
        sortingColumn.setReverse(bl);
        this.recentlyClickedColumns.add(sortingColumn);
    }

    public void detectStateFromComparator(Comparator comparator) {
        List<Object> list;
        this.clearComparators();
        if (comparator == null) {
            list = Collections.emptyList();
        } else if (comparator instanceof ComparatorChain) {
            ComparatorChain comparatorChain = (ComparatorChain)comparator;
            list = Arrays.asList(comparatorChain.getComparators());
        } else {
            list = Collections.singletonList(comparator);
        }
        for (Comparator comparator2 : list) {
            boolean bl = false;
            if (comparator2 instanceof ReverseComparator) {
                bl = true;
                comparator2 = ((ReverseComparator)comparator2).getSourceComparator();
            }
            for (int i2 = 0; i2 < this.sortingColumns.size(); ++i2) {
                int n2;
                if (this.recentlyClickedColumns.contains(this.sortingColumns.get(i2)) || (n2 = this.sortingColumns.get(i2).getComparators().indexOf(comparator2)) == -1) continue;
                SortingColumn sortingColumn = this.sortingColumns.get(i2);
                sortingColumn.setComparatorIndex(n2);
                sortingColumn.setReverse(bl);
                this.recentlyClickedColumns.add(sortingColumn);
            }
        }
    }

    public void clearComparators() {
        for (SortingColumn sortingColumn : this.recentlyClickedColumns) {
            sortingColumn.clear();
        }
        this.recentlyClickedColumns.clear();
    }

    public void rebuildColumns(TableFormat tableFormat) {
        int n2 = tableFormat.getColumnCount();
        this.sortingColumns = new ArrayList<SortingColumn>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.sortingColumns.add(this.createSortingColumn(tableFormat, i2));
        }
        this.recentlyClickedColumns.clear();
    }

    protected SortingColumn createSortingColumn(TableFormat tableFormat, int n2) {
        return new SortingColumn(tableFormat, n2);
    }

    public List<SortingColumn> getColumns() {
        return this.sortingColumns;
    }

    public List<SortingColumn> getRecentlyClickedColumns() {
        return this.recentlyClickedColumns;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<Integer> iterator = this.getSortingColumnIndexes().iterator();
        while (iterator.hasNext()) {
            int n2 = iterator.next();
            SortingColumn sortingColumn = this.getColumns().get(n2);
            stringBuffer.append("column ");
            stringBuffer.append(n2);
            int n3 = sortingColumn.getComparatorIndex();
            if (n3 != 0) {
                stringBuffer.append(" comparator ");
                stringBuffer.append(n3);
            }
            if (sortingColumn.isReverse()) {
                stringBuffer.append(" reversed");
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public void fromString(String string) {
        this.clearComparators();
        String[] stringArray = string.split(",");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            boolean bl;
            if (stringArray[i2].trim().length() == 0) continue;
            Matcher matcher = FROM_STRING_PATTERN.matcher(stringArray[i2]);
            if (!matcher.find()) {
                throw new IllegalArgumentException("Failed to parse column spec, \"" + stringArray[i2] + "\"");
            }
            int n2 = Integer.parseInt(matcher.group(1));
            int n3 = matcher.group(3) == null ? 0 : Integer.parseInt(matcher.group(3));
            boolean bl2 = bl = matcher.group(5) != null;
            if (n2 >= this.sortingColumns.size() || n3 >= this.sortingColumns.get(n2).getComparators().size()) continue;
            this.appendComparator(n2, n3, bl);
        }
    }

    public class SortingColumn {
        private final int column;
        private final List<Comparator> comparators = new ArrayList<Comparator>(1);
        private boolean reverse = false;
        private int comparatorIndex = -1;

        public SortingColumn(TableFormat tableFormat, int n2) {
            this.column = n2;
            if (tableFormat instanceof AdvancedTableFormat) {
                AdvancedTableFormat advancedTableFormat = (AdvancedTableFormat)tableFormat;
                Comparator comparator = advancedTableFormat.getColumnComparator(n2);
                if (comparator != null) {
                    this.comparators.add(new TableColumnComparator(tableFormat, n2, comparator));
                }
            } else {
                this.comparators.add(new TableColumnComparator(tableFormat, n2));
            }
        }

        public void clear() {
            this.reverse = false;
            this.comparatorIndex = -1;
        }

        public int getColumn() {
            return this.column;
        }

        public void setComparatorIndex(int n2) {
            assert (n2 < this.comparators.size());
            this.comparatorIndex = n2;
        }

        public int getComparatorIndex() {
            return this.comparatorIndex;
        }

        public List<Comparator> getComparators() {
            return this.comparators;
        }

        public Comparator getComparator() {
            if (this.comparatorIndex == -1) {
                return null;
            }
            Comparator comparator = this.comparators.get(this.getComparatorIndex());
            if (this.isReverse()) {
                comparator = GlazedLists.reverseComparator(comparator);
            }
            return comparator;
        }

        public boolean isReverse() {
            return this.reverse;
        }

        public void setReverse(boolean bl) {
            this.reverse = bl;
        }

        public int getSortingStyle() {
            boolean bl;
            if (this.comparatorIndex == -1) {
                return 0;
            }
            boolean bl2 = !SortingState.this.recentlyClickedColumns.isEmpty() && SortingState.this.recentlyClickedColumns.get(0) == this;
            boolean bl3 = bl = this.getComparatorIndex() == 0;
            if (bl2) {
                if (!this.isReverse()) {
                    if (bl) {
                        return 1;
                    }
                    return 3;
                }
                if (bl) {
                    return 2;
                }
                return 4;
            }
            if (!this.isReverse()) {
                if (bl) {
                    return 5;
                }
                return 7;
            }
            if (bl) {
                return 6;
            }
            return 8;
        }
    }
}

