/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.filter;

import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.TextFilterable;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.impl.GlazedListsImpl;
import ca.odell.glazedlists.impl.filter.SearchTerm;
import ca.odell.glazedlists.impl.filter.TextMatcher;
import ca.odell.glazedlists.impl.filter.TextSearchStrategy;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.Matchers;
import ca.odell.glazedlists.matchers.SearchEngineTextMatcherEditor;
import ca.odell.glazedlists.matchers.TextMatcherEditor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class TextMatchers {
    private static final Comparator<SearchTerm> SEARCHTERM_LENGTH_COMPARATOR = new SearchTermLengthComparator();
    private static final Matcher<SearchTerm> NON_NEGATED_MATCHER = Matchers.beanPropertyMatcher(SearchTerm.class, "negated", Boolean.FALSE);
    private static final Matcher<SearchTerm> NEGATED_MATCHER = Matchers.beanPropertyMatcher(SearchTerm.class, "negated", Boolean.TRUE);
    private static final Matcher<SearchTerm> NO_FIELD_MATCHER = Matchers.beanPropertyMatcher(SearchTerm.class, "negated", null);
    private static final Matcher<SearchTerm> FIELD_MATCHER = Matchers.invert(NO_FIELD_MATCHER);

    public static <E> boolean matches(List<String> list, TextFilterator<? super E> textFilterator, SearchTerm<E>[] searchTermArray, TextSearchStrategy[] textSearchStrategyArray, E e2) {
        boolean bl = false;
        block0: for (int i2 = 0; i2 < textSearchStrategyArray.length; ++i2) {
            String string;
            int n2;
            int n3;
            List<String> list2;
            TextSearchStrategy textSearchStrategy = textSearchStrategyArray[i2];
            SearchTerm<E> searchTerm = searchTermArray[i2];
            SearchEngineTextMatcherEditor.Field<E> field = searchTerm.getField();
            if (field != null) {
                list2 = searchTerm.getFieldFilterStrings();
                list2.clear();
                field.getTextFilterator().getFilterStrings(list2, e2);
            } else {
                if (!bl) {
                    list.clear();
                    if (textFilterator == null) {
                        ((TextFilterable)e2).getFilterStrings(list);
                    } else {
                        textFilterator.getFilterStrings(list, e2);
                    }
                    bl = true;
                }
                list2 = list;
            }
            if (searchTerm.isNegated()) {
                n3 = list2.size();
                for (n2 = 0; n2 < n3; ++n2) {
                    string = list2.get(n2);
                    if (string == null || textSearchStrategy.indexOf(string.toString()) == -1) continue;
                    return false;
                }
                continue;
            }
            n3 = list2.size();
            for (n2 = 0; n2 < n3; ++n2) {
                string = list2.get(n2);
                if (string != null && textSearchStrategy.indexOf(string.toString()) != -1) continue block0;
            }
            return false;
        }
        return true;
    }

    private static List<SearchTerm> normalizeSearchTerms(List<SearchTerm> list, boolean bl) {
        SearchTerm searchTerm;
        ArrayList<SearchTerm> arrayList = new ArrayList<SearchTerm>(list);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            searchTerm = (SearchTerm)iterator.next();
            if (searchTerm != null && searchTerm.getText().length() != 0) continue;
            iterator.remove();
        }
        block1: for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            searchTerm = (SearchTerm)arrayList.get(i2);
            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                SearchTerm searchTerm2 = (SearchTerm)arrayList.get(i3);
                if (i2 == i3 || searchTerm2.getText().indexOf(searchTerm.getText()) == -1) continue;
                if (bl) {
                    if (searchTerm2.isRequired()) continue;
                    arrayList.remove(i3);
                    continue;
                }
                if (searchTerm.isRequired()) continue;
                arrayList.remove(i2);
                continue block1;
            }
        }
        Collections.sort(arrayList, bl ? GlazedLists.reverseComparator(SEARCHTERM_LENGTH_COMPARATOR) : SEARCHTERM_LENGTH_COMPARATOR);
        return arrayList;
    }

    public static SearchTerm[] normalizeSearchTerms(SearchTerm[] searchTermArray, TextSearchStrategy.Factory factory) {
        Object object;
        Object object2;
        SearchTerm[] searchTermArray2;
        Object[] objectArray;
        if (factory == TextMatcherEditor.NORMALIZED_STRATEGY) {
            objectArray = GlazedListsImpl.getLatinDiacriticsStripper();
            searchTermArray2 = new SearchTerm[searchTermArray.length];
            for (int i2 = 0; i2 < searchTermArray.length; ++i2) {
                object2 = searchTermArray[i2].getText();
                object = new char[((String)object2).length()];
                for (int i3 = 0; i3 < ((String)object2).length(); ++i3) {
                    char c2 = ((String)object2).charAt(i3);
                    object[i3] = c2 < objectArray.length ? objectArray[c2] : c2;
                }
                searchTermArray2[i2] = searchTermArray[i2].newSearchTerm(new String((char[])object));
            }
            searchTermArray = searchTermArray2;
        }
        objectArray = Matchers.select(searchTermArray, NO_FIELD_MATCHER);
        searchTermArray2 = Matchers.select(searchTermArray, FIELD_MATCHER);
        List<SearchTerm> list = Arrays.asList(Matchers.select(searchTermArray2, NEGATED_MATCHER));
        object2 = Arrays.asList(Matchers.select(searchTermArray2, NON_NEGATED_MATCHER));
        object = new ArrayList(searchTermArray.length);
        object.addAll(Arrays.asList(objectArray));
        object.addAll(TextMatchers.normalizeSearchTerms(list, true));
        object.addAll(TextMatchers.normalizeSearchTerms((List<SearchTerm>)object2, false));
        return object.toArray(new SearchTerm[object.size()]);
    }

    public static <E> SearchTerm<E>[] parse(String string) {
        return TextMatchers.parse(string, Collections.emptySet());
    }

    /*
     * WARNING - void declaration
     */
    public static <E> SearchTerm<E>[] parse(String string, Set<SearchEngineTextMatcherEditor.Field<E>> set) {
        void var5_7;
        ArrayList arrayList = new ArrayList();
        HashMap<String, SearchEngineTextMatcherEditor.Field<E>> hashMap = new HashMap<String, SearchEngineTextMatcherEditor.Field<E>>();
        for (SearchEngineTextMatcherEditor.Field<E> field2 : set) {
            hashMap.put(field2.getName(), field2);
        }
        Object object = new StringBuffer();
        Object var5_6 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = string.length();
        block6: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (bl3) {
                SearchEngineTextMatcherEditor.Field field;
                boolean bl5;
                boolean bl6 = bl5 = c2 == '\"' || !bl4 && Character.isWhitespace(c2);
                if (bl5) {
                    if (((StringBuffer)object).length() > 0) {
                        arrayList.add(new SearchTerm(((StringBuffer)object).toString(), bl, bl2, var5_7));
                    }
                    object = new StringBuffer();
                    Object var5_8 = null;
                    bl4 = false;
                    bl3 = false;
                    bl2 = false;
                    bl = false;
                    continue;
                }
                if (c2 == ':' && var5_7 == null && !bl4 && (field = (SearchEngineTextMatcherEditor.Field)hashMap.get(((StringBuffer)object).toString())) != null) {
                    object = new StringBuffer();
                    bl4 = false;
                    bl3 = false;
                    bl2 = false;
                    bl = false;
                    continue;
                }
                ((StringBuffer)object).append(c2);
                continue;
            }
            if (Character.isWhitespace(c2)) {
                Object var5_10 = null;
                bl4 = false;
                bl3 = false;
                bl2 = false;
                bl = false;
                continue;
            }
            switch (c2) {
                case '\"': {
                    bl3 = true;
                    bl4 = true;
                    continue block6;
                }
                case '+': {
                    bl2 = true;
                    continue block6;
                }
                case '-': {
                    bl = true;
                    continue block6;
                }
                default: {
                    ((StringBuffer)object).append(c2);
                    bl3 = true;
                }
            }
        }
        if (((StringBuffer)object).length() > 0) {
            arrayList.add(new SearchTerm(((StringBuffer)object).toString(), bl, bl2, var5_7));
        }
        return arrayList.toArray(new SearchTerm[arrayList.size()]);
    }

    public static boolean isMatcherConstrained(TextMatcher textMatcher, TextMatcher textMatcher2) {
        if (textMatcher.equals(textMatcher2)) {
            return false;
        }
        if (textMatcher.getStrategy() != textMatcher2.getStrategy()) {
            return false;
        }
        if (textMatcher.getMode() == 1 && textMatcher2.getMode() == 0) {
            return false;
        }
        if (textMatcher.getMode() == 2 || textMatcher2.getMode() == 2) {
            return false;
        }
        if (textMatcher.getMode() == 3 || textMatcher2.getMode() == 3) {
            return false;
        }
        SearchTerm[] searchTermArray = textMatcher.getSearchTerms();
        SearchTerm[] searchTermArray2 = textMatcher2.getSearchTerms();
        block0: for (int i2 = 0; i2 < searchTermArray.length; ++i2) {
            for (int i3 = 0; i3 < searchTermArray2.length; ++i3) {
                if (searchTermArray2[i3].equals(searchTermArray[i2]) || searchTermArray2[i3].isConstrainment(searchTermArray[i2])) continue block0;
            }
            return false;
        }
        return true;
    }

    public static boolean isMatcherRelaxed(TextMatcher textMatcher, TextMatcher textMatcher2) {
        return TextMatchers.isMatcherConstrained(textMatcher2, textMatcher);
    }

    private static final class SearchTermLengthComparator
    implements Comparator<SearchTerm> {
        private SearchTermLengthComparator() {
        }

        @Override
        public int compare(SearchTerm searchTerm, SearchTerm searchTerm2) {
            return searchTerm2.getText().length() - searchTerm.getText().length();
        }
    }
}

