/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.filter;

import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.impl.filter.SearchTerm;
import ca.odell.glazedlists.impl.filter.TextMatchers;
import ca.odell.glazedlists.impl.filter.TextSearchStrategy;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.TextMatcherEditor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class TextMatcher<E>
implements Matcher<E> {
    private final TextFilterator<? super E> filterator;
    private final int mode;
    private final Object strategy;
    private final SearchTerm[] searchTerms;
    private final TextSearchStrategy[] filterStrategies;
    private final List<String> filterStrings = new ArrayList<String>();

    public TextMatcher(SearchTerm[] searchTermArray, TextFilterator<? super E> textFilterator, int n2, Object object) {
        if (n2 == 2 && object == TextMatcherEditor.NORMALIZED_STRATEGY) {
            throw new IllegalArgumentException("TextMatcher does not support normalized character matching with Regular Expressions");
        }
        this.filterator = textFilterator;
        this.searchTerms = TextMatchers.normalizeSearchTerms(searchTermArray, (TextSearchStrategy.Factory)object);
        this.mode = n2;
        this.strategy = object;
        this.filterStrategies = new TextSearchStrategy[this.searchTerms.length];
        for (int i2 = 0; i2 < this.searchTerms.length; ++i2) {
            this.filterStrategies[i2] = TextMatcher.selectTextSearchStrategy(this.searchTerms[i2], n2, (TextSearchStrategy.Factory)object);
        }
    }

    public int getMode() {
        return this.mode;
    }

    public Object getStrategy() {
        return this.strategy;
    }

    public SearchTerm[] getSearchTerms() {
        return this.searchTerms;
    }

    public String[] getSearchTermStrings() {
        String[] stringArray = new String[this.searchTerms.length];
        for (int i2 = 0; i2 < this.searchTerms.length; ++i2) {
            stringArray[i2] = this.searchTerms[i2].getText();
        }
        return stringArray;
    }

    @Override
    public boolean matches(E e2) {
        return TextMatchers.matches(this.filterStrings, this.filterator, this.searchTerms, this.filterStrategies, e2);
    }

    public TextMatcher<E> newMode(int n2) {
        return new TextMatcher<E>(this.searchTerms, this.filterator, n2, this.strategy);
    }

    public TextMatcher<E> newFilterator(TextFilterator<? super E> textFilterator) {
        return new TextMatcher<E>(this.searchTerms, textFilterator, this.mode, this.strategy);
    }

    public TextMatcher<E> newStrategy(Object object) {
        return new TextMatcher<E>(this.searchTerms, this.filterator, this.mode, object);
    }

    private static TextSearchStrategy selectTextSearchStrategy(SearchTerm searchTerm, int n2, TextSearchStrategy.Factory factory) {
        TextSearchStrategy textSearchStrategy = factory.create(n2, searchTerm.getText());
        textSearchStrategy.setSubtext(searchTerm.getText());
        return textSearchStrategy;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TextMatcher textMatcher = (TextMatcher)object;
        HashSet<SearchTerm> hashSet = new HashSet<SearchTerm>(Arrays.asList(this.searchTerms));
        HashSet<SearchTerm> hashSet2 = new HashSet<SearchTerm>(Arrays.asList(textMatcher.searchTerms));
        if (this.mode != textMatcher.mode) {
            return false;
        }
        if (!hashSet.equals(hashSet2)) {
            return false;
        }
        return this.strategy.equals(textMatcher.strategy);
    }

    public int hashCode() {
        int n2 = this.mode;
        n2 = 31 * n2 + this.strategy.hashCode();
        n2 = 31 * n2 + new HashSet<SearchTerm>(Arrays.asList(this.searchTerms)).hashCode();
        return n2;
    }
}

