/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.filter;

import ca.odell.glazedlists.impl.filter.AbstractTextSearchStrategy;

public class StartsWithCaseInsensitiveTextSearchStrategy
extends AbstractTextSearchStrategy {
    private IndexOfStrategy indexOfStrategy;

    @Override
    public void setSubtext(String string) {
        this.indexOfStrategy = string.length() == 1 ? new SingleCharacterIndexOfStrategy(string.charAt(0)) : new MultiCharacterIndexOfStrategy(string);
    }

    @Override
    public int indexOf(String string) {
        if (this.indexOfStrategy == null) {
            throw new IllegalStateException("setSubtext must be called with a valid value before this method can operate");
        }
        return this.indexOfStrategy.indexOf(string);
    }

    private class MultiCharacterIndexOfStrategy
    implements IndexOfStrategy {
        private final int subtextLength;
        private char[] subtextCharsUpper;
        private char[] subtextCharsLower;

        public MultiCharacterIndexOfStrategy(String string) {
            this.subtextLength = string.length();
            this.subtextCharsUpper = string.toUpperCase().toCharArray();
            this.subtextCharsLower = string.toLowerCase().toCharArray();
        }

        @Override
        public int indexOf(String string) {
            if (string.length() < this.subtextLength) {
                return -1;
            }
            for (int i2 = 0; i2 < this.subtextLength; ++i2) {
                char c2 = StartsWithCaseInsensitiveTextSearchStrategy.this.map(string.charAt(i2));
                if (this.subtextCharsLower[i2] == c2 || this.subtextCharsUpper[i2] == c2) continue;
                return -1;
            }
            return 0;
        }
    }

    private class SingleCharacterIndexOfStrategy
    implements IndexOfStrategy {
        private final char upperCase;
        private final char lowerCase;

        public SingleCharacterIndexOfStrategy(char c2) {
            this.upperCase = Character.toUpperCase(c2);
            this.lowerCase = Character.toLowerCase(c2);
        }

        @Override
        public int indexOf(String string) {
            if (string.length() < 1) {
                return -1;
            }
            char c2 = StartsWithCaseInsensitiveTextSearchStrategy.this.map(string.charAt(0));
            return c2 == this.upperCase || c2 == this.lowerCase ? 0 : -1;
        }
    }

    @FunctionalInterface
    private static interface IndexOfStrategy {
        public int indexOf(String var1);
    }
}

