/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.filter;

import ca.odell.glazedlists.impl.filter.AbstractTextSearchStrategy;

public class SingleCharacterCaseInsensitiveTextSearchStrategy
extends AbstractTextSearchStrategy {
    private char subtextCharLower;
    private char subtextCharUpper;
    private boolean subtextInitialized = false;

    @Override
    public void setSubtext(String string) {
        if (string == null) {
            throw new IllegalArgumentException("subtext may not be null");
        }
        if (string.length() != 1) {
            throw new IllegalArgumentException("subtext (" + string + ") must contain a single character");
        }
        char c2 = string.charAt(0);
        this.subtextCharLower = Character.toLowerCase(c2);
        this.subtextCharUpper = Character.toUpperCase(c2);
        this.subtextInitialized = true;
    }

    @Override
    public int indexOf(String string) {
        if (!this.subtextInitialized) {
            throw new IllegalStateException("setSubtext must be called with a valid value before this method can operate");
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = this.map(string.charAt(i2));
            if (c2 != this.subtextCharLower && c2 != this.subtextCharUpper) continue;
            return i2;
        }
        return -1;
    }
}

