/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.filter;

import ca.odell.glazedlists.matchers.SearchEngineTextMatcherEditor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class SearchTerm<E>
implements Serializable {
    private final String text;
    private final boolean negated;
    private final boolean required;
    private final SearchEngineTextMatcherEditor.Field<E> field;
    private final List<String> fieldFilterStrings = new ArrayList<String>();

    public SearchTerm(String string) {
        this(string, false, false, null);
    }

    public SearchTerm(String string, boolean bl, boolean bl2, SearchEngineTextMatcherEditor.Field<E> field) {
        if (string == null) {
            throw new IllegalArgumentException("text may not be null");
        }
        this.text = string;
        this.negated = bl;
        this.required = bl2;
        this.field = field;
    }

    public String getText() {
        return this.text;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public boolean isRequired() {
        return this.required;
    }

    public SearchEngineTextMatcherEditor.Field<E> getField() {
        return this.field;
    }

    List<String> getFieldFilterStrings() {
        return this.fieldFilterStrings;
    }

    public SearchTerm<E> newSearchTerm(String string) {
        return new SearchTerm<E>(string, this.isNegated(), this.isRequired(), this.getField());
    }

    boolean isConstrainment(SearchTerm searchTerm) {
        if (this.isNegated() != searchTerm.isNegated()) {
            return false;
        }
        if (!Objects.equals(this.getField(), searchTerm.getField())) {
            return false;
        }
        if (this.getText().equals(searchTerm.getText())) {
            return false;
        }
        return this.isNegated() ? searchTerm.getText().indexOf(this.getText()) != -1 : this.getText().indexOf(searchTerm.getText()) != -1;
    }

    boolean isRelaxation(SearchTerm searchTerm) {
        return searchTerm.isConstrainment(this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SearchTerm searchTerm = (SearchTerm)object;
        if (this.negated != searchTerm.negated) {
            return false;
        }
        if (this.required != searchTerm.required) {
            return false;
        }
        if (this.field != null ? !this.field.equals(searchTerm.field) : searchTerm.field != null) {
            return false;
        }
        return this.text.equals(searchTerm.text);
    }

    public int hashCode() {
        int n2 = this.text.hashCode();
        n2 = 31 * n2 + (this.negated ? 1 : 0);
        n2 = 31 * n2 + (this.required ? 1 : 0);
        n2 = 31 * n2 + (this.field != null ? this.field.hashCode() : 0);
        return n2;
    }
}

