/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.filter;

import ca.odell.glazedlists.impl.filter.AbstractTextSearchStrategy;
import java.util.Arrays;

public class BoyerMooreCaseInsensitiveTextSearchStrategy
extends AbstractTextSearchStrategy {
    private static final int CHARACTER_CACHE_SIZE = 256;
    private int subtextLength;
    private int lastSubtextIndex;
    private char[] subtextCharsUpper;
    private char[] subtextCharsLower;
    private int[] shiftTable = new int[256];

    @Override
    public void setSubtext(String string) {
        this.subtextLength = string.length();
        this.lastSubtextIndex = this.subtextLength - 1;
        this.subtextCharsUpper = string.toUpperCase().toCharArray();
        this.subtextCharsLower = string.toLowerCase().toCharArray();
        Arrays.fill(this.shiftTable, 0, this.shiftTable.length, this.subtextLength);
        for (int i2 = 0; i2 < this.lastSubtextIndex; ++i2) {
            this.shiftTable[this.subtextCharsUpper[i2] % 256] = this.lastSubtextIndex - i2;
            if (this.subtextCharsUpper[i2] == this.subtextCharsLower[i2]) continue;
            this.shiftTable[this.subtextCharsLower[i2] % 256] = this.lastSubtextIndex - i2;
        }
    }

    @Override
    public int indexOf(String string) {
        int n2;
        if (this.subtextCharsUpper == null) {
            throw new IllegalStateException("setSubtext must be called with a valid value before this method can operate");
        }
        char c2 = ' ';
        int n3 = string.length();
        for (int i2 = this.lastSubtextIndex; i2 < n3; i2 += Math.max(this.shiftTable[c2 % 256], this.subtextLength - n2)) {
            n2 = this.lastSubtextIndex;
            if (n2 >= 0) {
                c2 = this.map(string.charAt(i2));
                while (n2 >= 0 && (this.subtextCharsLower[n2] == c2 || this.subtextCharsUpper[n2] == c2)) {
                    if (--i2 != -1) {
                        c2 = this.map(string.charAt(i2));
                    }
                    --n2;
                }
            }
            if (n2 != -1) continue;
            return i2 + 1;
        }
        return -1;
    }
}

