/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.event;

import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.impl.adt.barcode2.Element;
import ca.odell.glazedlists.impl.adt.barcode2.FourColorTree;
import ca.odell.glazedlists.impl.adt.barcode2.FourColorTreeIterator;
import ca.odell.glazedlists.impl.adt.barcode2.ListToByteCoder;
import ca.odell.glazedlists.impl.event.BlockSequence;
import java.util.Arrays;

public class Tree4Deltas<E> {
    private static final ListToByteCoder<String> BYTE_CODER = new ListToByteCoder<String>(Arrays.asList("+", "U", "X", "_"));
    public static final byte INSERT = BYTE_CODER.colorToByte("+");
    public static final byte UPDATE = BYTE_CODER.colorToByte("U");
    public static final byte DELETE = BYTE_CODER.colorToByte("X");
    public static final byte NO_CHANGE = BYTE_CODER.colorToByte("_");
    private static final byte SOURCE_INDICES = BYTE_CODER.colorsToByte(Arrays.asList("U", "X", "_"));
    private static final byte TARGET_INDICES = BYTE_CODER.colorsToByte(Arrays.asList("U", "+", "_"));
    private static final byte ALL_INDICES = BYTE_CODER.colorsToByte(Arrays.asList("U", "X", "+", "_"));
    private static final byte CHANGE_INDICES = BYTE_CODER.colorsToByte(Arrays.asList("U", "X", "+"));
    private FourColorTree<E> tree = new FourColorTree(BYTE_CODER);
    private boolean allowContradictingEvents = false;
    private boolean initialCapacityKnown = false;
    public boolean horribleHackPreferMostRecentValue = false;

    public boolean getAllowContradictingEvents() {
        return this.allowContradictingEvents;
    }

    public void setAllowContradictingEvents(boolean bl) {
        this.allowContradictingEvents = bl;
    }

    public int targetToSource(int n2) {
        if (!this.initialCapacityKnown) {
            this.ensureCapacity(n2 + 1);
        }
        return this.tree.convertIndexColor(n2, TARGET_INDICES, SOURCE_INDICES);
    }

    public int sourceToTarget(int n2) {
        if (!this.initialCapacityKnown) {
            this.ensureCapacity(n2 + 1);
        }
        return this.tree.convertIndexColor(n2, SOURCE_INDICES, TARGET_INDICES);
    }

    public void targetUpdate(int n2, int n3, E e2, E e3) {
        if (!this.initialCapacityKnown) {
            this.ensureCapacity(n3);
        }
        for (int i2 = n2; i2 < n3; ++i2) {
            int n4 = this.tree.convertIndexColor(i2, TARGET_INDICES, ALL_INDICES);
            Element<E> element = this.tree.get(n4, ALL_INDICES);
            if (this.horribleHackPreferMostRecentValue) {
                byte by = element.getColor() == INSERT ? INSERT : UPDATE;
                this.tree.set(n4, ALL_INDICES, by, e2, 1);
                continue;
            }
            if (element.getColor() == INSERT) continue;
            if (element.getColor() == UPDATE) {
                e2 = element.get();
            }
            this.tree.set(n4, ALL_INDICES, UPDATE, e2, 1);
        }
    }

    public void targetInsert(int n2, int n3, E e2) {
        if (!this.initialCapacityKnown) {
            this.ensureCapacity(n3);
        }
        this.tree.add(n2, TARGET_INDICES, INSERT, e2, n3 - n2);
    }

    public void targetDelete(int n2, int n3, E e2) {
        if (!this.initialCapacityKnown) {
            this.ensureCapacity(n3);
        }
        for (int i2 = n2; i2 < n3; ++i2) {
            if (n2 > 0 && n2 > this.tree.size(TARGET_INDICES)) {
                throw new IllegalArgumentException();
            }
            int n4 = this.tree.convertIndexColor(n2, TARGET_INDICES, ALL_INDICES);
            Element<E> element = this.tree.get(n4, ALL_INDICES);
            if (element.getColor() == INSERT) {
                if (!this.allowContradictingEvents) {
                    throw new IllegalStateException("Remove " + i2 + " undoes prior insert at the same index! Consider enabling contradicting events.");
                }
                this.tree.remove(n4, ALL_INDICES, 1);
                continue;
            }
            if (element.getColor() == UPDATE) {
                e2 = element.get();
            }
            this.tree.set(n4, ALL_INDICES, DELETE, e2, 1);
        }
    }

    public void sourceInsert(int n2) {
        this.tree.add(n2, SOURCE_INDICES, NO_CHANGE, ListEvent.unknownValue(), 1);
    }

    public void sourceDelete(int n2) {
        this.tree.remove(n2, SOURCE_INDICES, 1);
    }

    public void sourceRevert(int n2) {
        this.tree.set(n2, SOURCE_INDICES, NO_CHANGE, ListEvent.unknownValue(), 1);
    }

    public int targetSize() {
        return this.tree.size(TARGET_INDICES);
    }

    public int sourceSize() {
        return this.tree.size(SOURCE_INDICES);
    }

    public byte getChangeType(int n2) {
        return this.tree.get(n2, SOURCE_INDICES).getColor();
    }

    public E getTargetValue(int n2) {
        return this.tree.get(n2, TARGET_INDICES).get();
    }

    public E getSourceValue(int n2) {
        return this.tree.get(n2, SOURCE_INDICES).get();
    }

    public void reset(int n2) {
        this.tree.clear();
        this.initialCapacityKnown = true;
        this.ensureCapacity(n2);
    }

    private void ensureCapacity(int n2) {
        int n3 = this.tree.size(TARGET_INDICES);
        int n4 = n2 - n3;
        if (n4 > 0) {
            int n5 = this.tree.size(ALL_INDICES);
            this.tree.add(n5, ALL_INDICES, NO_CHANGE, ListEvent.unknownValue(), n4);
        }
    }

    public void addAll(BlockSequence<E> blockSequence) {
        BlockSequence.Iterator iterator = blockSequence.iterator();
        while (iterator.nextBlock()) {
            int n2 = iterator.getBlockStart();
            int n3 = iterator.getBlockEnd();
            int n4 = iterator.getType();
            Object e2 = iterator.getOldValue();
            Object e3 = iterator.getNewValue();
            if (n4 == 2) {
                this.targetInsert(n2, n3, e3);
                continue;
            }
            if (n4 == 1) {
                this.targetUpdate(n2, n3, e2, e3);
                continue;
            }
            if (n4 == 0) {
                this.targetDelete(n2, n3, e2);
                continue;
            }
            throw new IllegalStateException();
        }
    }

    public boolean isEmpty() {
        return this.tree.size(CHANGE_INDICES) == 0;
    }

    public Iterator<E> iterator() {
        return new Iterator((FourColorTree)this.tree);
    }

    public String toString() {
        return this.tree.asSequenceOfColors();
    }

    public static class Iterator<E> {
        private final FourColorTree<E> tree;
        private final FourColorTreeIterator<E> treeIterator;

        private Iterator(FourColorTree<E> fourColorTree) {
            this.tree = fourColorTree;
            this.treeIterator = new FourColorTreeIterator<E>(fourColorTree);
        }

        private Iterator(FourColorTree<E> fourColorTree, FourColorTreeIterator<E> fourColorTreeIterator) {
            this.tree = fourColorTree;
            this.treeIterator = fourColorTreeIterator;
        }

        public Iterator<E> copy() {
            return new Iterator<E>(this.tree, this.treeIterator.copy());
        }

        public int getIndex() {
            return this.treeIterator.index(TARGET_INDICES);
        }

        public int getEndIndex() {
            return this.treeIterator.nodeStartIndex(TARGET_INDICES) + this.treeIterator.nodeSize(ALL_INDICES);
        }

        public int getType() {
            byte by = this.treeIterator.color();
            if (by == INSERT) {
                return 2;
            }
            if (by == UPDATE) {
                return 1;
            }
            if (by == DELETE) {
                return 0;
            }
            throw new IllegalStateException();
        }

        public boolean next() {
            if (!this.hasNext()) {
                return false;
            }
            this.treeIterator.next(CHANGE_INDICES);
            return true;
        }

        public boolean nextNode() {
            if (!this.hasNextNode()) {
                return false;
            }
            this.treeIterator.nextNode(CHANGE_INDICES);
            return true;
        }

        public boolean hasNext() {
            return this.treeIterator.hasNext(CHANGE_INDICES);
        }

        public boolean hasNextNode() {
            return this.treeIterator.hasNextNode(CHANGE_INDICES);
        }

        public E getOldValue() {
            return this.treeIterator.node().get();
        }
    }
}

