/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.beans;

import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.gui.WritableTableFormat;
import ca.odell.glazedlists.impl.beans.BeanProperty;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class BeanTableFormat<E>
implements WritableTableFormat<E>,
AdvancedTableFormat<E> {
    protected BeanProperty<E>[] beanProperties = null;
    protected String[] propertyNames;
    protected String[] columnLabels;
    private boolean[] editable;
    protected Comparator[] comparators;
    protected Class[] classes;
    protected static final Map<Class, Class> primitiveToObjectMap;

    public BeanTableFormat(Class<E> clazz, String[] stringArray, String[] stringArray2, boolean[] blArray) {
        this.propertyNames = stringArray;
        this.columnLabels = stringArray2;
        this.editable = blArray;
        this.comparators = new Comparator[stringArray.length];
        this.classes = new Class[stringArray.length];
        if (clazz == null) {
            for (int i2 = 0; i2 < this.classes.length; ++i2) {
                this.classes[i2] = Object.class;
                this.comparators[i2] = GlazedLists.comparableComparator();
            }
        } else {
            this.loadPropertyDescriptors(clazz);
            for (int i3 = 0; i3 < this.classes.length; ++i3) {
                Class clazz2 = this.beanProperties[i3].getValueClass();
                this.classes[i3] = primitiveToObjectMap.containsKey(clazz2) ? primitiveToObjectMap.get(clazz2) : clazz2;
                this.comparators[i3] = Comparable.class.isAssignableFrom(this.classes[i3]) ? GlazedLists.comparableComparator() : null;
            }
        }
    }

    public BeanTableFormat(Class<E> clazz, String[] stringArray, String[] stringArray2) {
        this(clazz, stringArray, stringArray2, new boolean[stringArray.length]);
    }

    protected void loadPropertyDescriptors(Class<E> clazz) {
        this.beanProperties = new BeanProperty[this.propertyNames.length];
        for (int i2 = 0; i2 < this.propertyNames.length; ++i2) {
            this.beanProperties[i2] = new BeanProperty<E>(clazz, this.propertyNames[i2], true, this.editable[i2]);
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnLabels.length;
    }

    @Override
    public String getColumnName(int n2) {
        return this.columnLabels[n2];
    }

    @Override
    public Object getColumnValue(E e2, int n2) {
        if (e2 == null) {
            return null;
        }
        if (this.beanProperties == null) {
            this.loadPropertyDescriptors(e2.getClass());
        }
        return this.beanProperties[n2].get(e2);
    }

    @Override
    public boolean isEditable(E e2, int n2) {
        return this.editable[n2];
    }

    @Override
    public E setColumnValue(E e2, Object object, int n2) {
        if (e2 == null) {
            return null;
        }
        if (this.beanProperties == null) {
            this.loadPropertyDescriptors(e2.getClass());
        }
        this.beanProperties[n2].set(e2, object);
        return e2;
    }

    @Override
    public Class getColumnClass(int n2) {
        return this.classes[n2];
    }

    @Override
    public Comparator getColumnComparator(int n2) {
        return this.comparators[n2];
    }

    static {
        HashMap<Class<Comparable<Boolean>>, Class> hashMap = new HashMap<Class<Comparable<Boolean>>, Class>();
        hashMap.put(Boolean.TYPE, Boolean.class);
        hashMap.put(Character.TYPE, Character.class);
        hashMap.put(Byte.TYPE, Byte.class);
        hashMap.put(Short.TYPE, Short.class);
        hashMap.put(Integer.TYPE, Integer.class);
        hashMap.put(Long.TYPE, Long.class);
        hashMap.put(Float.TYPE, Float.class);
        hashMap.put(Double.TYPE, Double.class);
        primitiveToObjectMap = Collections.unmodifiableMap(hashMap);
    }
}

