/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.beans;

import ca.odell.glazedlists.impl.reflect.J2SE50ReturnTypeResolver;
import ca.odell.glazedlists.impl.reflect.ReturnTypeResolver;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.List;

public class BeanProperty<T> {
    private static final ReturnTypeResolver TYPE_RESOLVER = new J2SE50ReturnTypeResolver();
    private final Class<T> beanClass;
    private final String propertyName;
    private final boolean identityProperty;
    private Class valueClass = null;
    private List<Method> getterChain = null;
    private List<Method> setterChain = null;
    private static final Object[] EMPTY_ARGUMENTS = new Object[0];
    private static final Class[] EMPTY_PARAMETER_TYPES = new Class[0];

    public BeanProperty(Class<T> clazz, String string, boolean bl, boolean bl2) {
        if (clazz == null) {
            throw new IllegalArgumentException("beanClass may not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("propertyName may not be null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("propertyName may not be empty");
        }
        this.beanClass = clazz;
        this.propertyName = string;
        this.identityProperty = "this".equals(string);
        if (this.identityProperty && bl2) {
            throw new IllegalArgumentException("The identity property name (this) cannot be writable");
        }
        String[] stringArray = string.split("\\.");
        ArrayList<Method> arrayList = new ArrayList<Method>(stringArray.length);
        Class<Object> clazz2 = clazz;
        for (int i2 = 0; i2 < stringArray.length - 1; ++i2) {
            Method method = this.findGetterMethod(clazz2, stringArray[i2]);
            arrayList.add(method);
            clazz2 = TYPE_RESOLVER.getReturnType(clazz2, method);
        }
        if (bl) {
            if (this.identityProperty) {
                this.valueClass = clazz;
            } else {
                this.getterChain = new ArrayList<Method>();
                this.getterChain.addAll(arrayList);
                Method method = this.findGetterMethod(clazz2, stringArray[stringArray.length - 1]);
                this.getterChain.add(method);
                this.valueClass = TYPE_RESOLVER.getReturnType(clazz2, method);
            }
        }
        if (bl2) {
            this.setterChain = new ArrayList<Method>();
            this.setterChain.addAll(arrayList);
            Method method = this.findSetterMethod(clazz2, stringArray[stringArray.length - 1]);
            this.setterChain.add(method);
            if (this.valueClass == null) {
                this.valueClass = TYPE_RESOLVER.getFirstParameterType(clazz2, method);
            }
        }
    }

    private Method findGetterMethod(Class clazz, String string) {
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            String string2 = "get" + this.capitalize(string);
            Method method = this.getMethod(clazz2, string2, EMPTY_PARAMETER_TYPES);
            if (method != null) {
                this.validateGetter(method);
                return method;
            }
            String string3 = "is" + this.capitalize(string);
            method = this.getMethod(clazz2, string3, EMPTY_PARAMETER_TYPES);
            if (method == null) continue;
            this.validateGetter(method);
            return method;
        }
        throw new IllegalArgumentException("Failed to find getter for property \"" + string + "\" of " + clazz);
    }

    private Method findSetterMethod(Class clazz, String string) {
        String string2 = "set" + this.capitalize(string);
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            Method[] methodArray = clazz2.getMethods();
            for (int i2 = 0; i2 < methodArray.length; ++i2) {
                if (!methodArray[i2].getName().equals(string2) || methodArray[i2].getParameterTypes().length != 1) continue;
                this.validateSetter(methodArray[i2]);
                return methodArray[i2];
            }
        }
        throw new IllegalArgumentException("Failed to find setter for property \"" + string + "\" of " + clazz);
    }

    private void validateGetter(Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new IllegalArgumentException("Getter \"" + method + "\" is not public");
        }
        if (Void.TYPE.equals(method.getReturnType())) {
            throw new IllegalArgumentException("Getter \"" + method + "\" returns void");
        }
        if (method.getParameterTypes().length != 0) {
            throw new IllegalArgumentException("Getter \"" + method + "\" has too many parameters; expected 0 but found " + method.getParameterTypes().length);
        }
    }

    private void validateSetter(Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new IllegalArgumentException("Setter \"" + method + "\" is not public");
        }
        if (method.getParameterTypes().length != 1) {
            throw new IllegalArgumentException("Setter \"" + method + "\" takes the wrong number of parameters; expected 1 but found " + method.getParameterTypes().length);
        }
    }

    private String capitalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Character.toUpperCase(string.charAt(0)));
        stringBuffer.append(string.substring(1));
        return stringBuffer.toString();
    }

    private Method getMethod(Class clazz, String string, Class[] classArray) {
        try {
            return clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public Class<T> getBeanClass() {
        return this.beanClass;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Class getValueClass() {
        return this.valueClass;
    }

    public boolean isReadable() {
        return this.getterChain != null || this.identityProperty;
    }

    public boolean isWritable() {
        return this.setterChain != null;
    }

    public Object get(T t2) {
        if (!this.isReadable()) {
            throw new IllegalStateException("Property " + this.propertyName + " of " + this.beanClass + " not readable");
        }
        if (this.identityProperty) {
            return t2;
        }
        try {
            Object object = t2;
            int n2 = this.getterChain.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Method method = this.getterChain.get(i2);
                object = method.invoke(object, EMPTY_ARGUMENTS);
                if (object != null) continue;
                return null;
            }
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            SecurityException securityException = new SecurityException();
            securityException.initCause(illegalAccessException);
            throw securityException;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UndeclaredThrowableException(invocationTargetException.getCause());
        }
    }

    public Object set(T t2, Object object) {
        if (!this.isWritable()) {
            throw new IllegalStateException("Property " + this.propertyName + " of " + this.beanClass + " not writable");
        }
        Method method = null;
        try {
            Object object2 = t2;
            int n2 = this.setterChain.size() - 1;
            for (int i2 = 0; i2 < n2; ++i2) {
                Method method2 = this.setterChain.get(i2);
                object2 = method2.invoke(object2, EMPTY_ARGUMENTS);
                if (object2 != null) continue;
                return null;
            }
            method = this.setterChain.get(this.setterChain.size() - 1);
            return method.invoke(object2, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = illegalArgumentException.getMessage();
            if ("argument type mismatch".equals(string) && method != null) {
                string = BeanProperty.getSimpleName(method.getDeclaringClass()) + "." + method.getName() + "(" + BeanProperty.getSimpleName(method.getParameterTypes()[0]) + ") cannot be called with an instance of " + BeanProperty.getSimpleName(object.getClass());
            }
            throw new IllegalArgumentException(string);
        }
        catch (IllegalAccessException illegalAccessException) {
            SecurityException securityException = new SecurityException();
            securityException.initCause(illegalAccessException);
            throw securityException;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UndeclaredThrowableException(invocationTargetException.getCause());
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeException("Failed to set property \"" + this.propertyName + "\" of " + this.beanClass + " to " + (object == null ? "null" : "instance of " + object.getClass()), runtimeException);
        }
    }

    private static String getSimpleName(Class clazz) {
        int n2;
        String string;
        Class<?> clazz2 = clazz.getDeclaringClass();
        String string2 = string = clazz2 == null ? null : clazz2.getName();
        if (string == null) {
            string = clazz.getName();
            return string.substring(string.lastIndexOf(".") + 1);
        }
        int n3 = string.length();
        if (n3 < 1 || string.charAt(0) != '$') {
            throw new InternalError("Malformed class name");
        }
        for (n2 = 1; n2 < n3 && BeanProperty.isAsciiDigit(string.charAt(n2)); ++n2) {
        }
        return string.substring(n2);
    }

    private static boolean isAsciiDigit(char c2) {
        return '0' <= c2 && c2 <= '9';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BeanProperty beanProperty = (BeanProperty)object;
        if (!this.beanClass.equals(beanProperty.beanClass)) {
            return false;
        }
        return this.propertyName.equals(beanProperty.propertyName);
    }

    public int hashCode() {
        int n2 = this.beanClass.hashCode();
        n2 = 29 * n2 + this.propertyName.hashCode();
        return n2;
    }
}

