/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.beans;

import ca.odell.glazedlists.ObservableElementChangeHandler;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.Matchers;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EventListener;

public class BeanConnector<E>
implements ObservableElementList.Connector<E> {
    private Method addListenerMethod;
    private Method removeListenerMethod;
    private ObservableElementChangeHandler<? extends E> list;
    protected PropertyChangeListener propertyChangeListener = this.createPropertyChangeListener();
    private Matcher<PropertyChangeEvent> eventMatcher = Matchers.trueMatcher();
    private final Object[] reflectionParameters = new Object[]{this.propertyChangeListener};
    private static final Class[] REFLECTION_TYPES = new Class[]{PropertyChangeListener.class};

    public BeanConnector(Class<E> clazz) {
        Method[] methodArray = clazz.getMethods();
        for (int i2 = 0; i2 < methodArray.length; ++i2) {
            if (methodArray[i2].getParameterTypes().length != 1 || methodArray[i2].getParameterTypes()[0] != PropertyChangeListener.class) continue;
            if (methodArray[i2].getName().startsWith("add")) {
                this.addListenerMethod = methodArray[i2];
            }
            if (!methodArray[i2].getName().startsWith("remove")) continue;
            this.removeListenerMethod = methodArray[i2];
        }
        if (this.addListenerMethod == null || this.removeListenerMethod == null) {
            throw new IllegalArgumentException("Couldn't find listener methods for " + clazz.getName());
        }
    }

    public BeanConnector(Class<E> clazz, Matcher<PropertyChangeEvent> matcher) {
        this(clazz);
        super.setEventMatcher(matcher);
    }

    public BeanConnector(Class<E> clazz, String string, String string2) {
        try {
            this.addListenerMethod = clazz.getMethod(string, REFLECTION_TYPES);
            this.removeListenerMethod = clazz.getMethod(string2, REFLECTION_TYPES);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("Failed to find method " + noSuchMethodException.getMessage() + " in " + clazz);
        }
    }

    public BeanConnector(Class<E> clazz, String string, String string2, Matcher<PropertyChangeEvent> matcher) {
        this(clazz, string, string2);
        super.setEventMatcher(matcher);
    }

    @Override
    public EventListener installListener(E e2) {
        try {
            this.addListenerMethod.invoke(e2, this.reflectionParameters);
            return this.propertyChangeListener;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException.getCause());
        }
    }

    @Override
    public void uninstallListener(E e2, EventListener eventListener) {
        try {
            this.removeListenerMethod.invoke(e2, this.reflectionParameters);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException.getCause());
        }
    }

    @Override
    public void setObservableElementList(ObservableElementChangeHandler<? extends E> observableElementChangeHandler) {
        this.list = observableElementChangeHandler;
    }

    public final Matcher<PropertyChangeEvent> getEventMatcher() {
        return this.eventMatcher;
    }

    private void setEventMatcher(Matcher<PropertyChangeEvent> matcher) {
        if (matcher == null) {
            throw new IllegalArgumentException("Event matcher may not be null.");
        }
        this.eventMatcher = matcher;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ObservableElementChangeHandler observableElementChangeHandler = BeanConnector.this.list;
            if (observableElementChangeHandler != null && BeanConnector.this.getEventMatcher().matches(propertyChangeEvent)) {
                observableElementChangeHandler.elementChanged(propertyChangeEvent.getSource());
            }
        }
    }
}

