/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.adt.barcode2;

import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.impl.adt.barcode2.Element;
import ca.odell.glazedlists.impl.adt.barcode2.SimpleNode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class SimpleTree<T0> {
    private SimpleNode<T0> root = null;
    private final List<SimpleNode<T0>> zeroQueue = new ArrayList<SimpleNode<T0>>();
    private final Comparator<? super T0> comparator;

    public SimpleTree(Comparator<? super T0> comparator) {
        if (comparator == null) {
            throw new NullPointerException("Comparator cannot be null.");
        }
        this.comparator = comparator;
    }

    public SimpleTree() {
        this(GlazedLists.comparableComparator());
    }

    public Comparator<? super T0> getComparator() {
        return this.comparator;
    }

    public Element<T0> get(int n2) {
        if (this.root == null) {
            throw new IndexOutOfBoundsException();
        }
        SimpleNode<T0> simpleNode = this.root;
        while (true) {
            int n3;
            assert (simpleNode != null);
            assert (n2 >= 0);
            SimpleNode simpleNode2 = simpleNode.left;
            int n4 = n3 = simpleNode2 != null ? simpleNode2.count1 : 0;
            if (n2 < n3) {
                simpleNode = simpleNode2;
                continue;
            }
            int n5 = 1;
            if ((n2 -= n3) < n5) {
                return simpleNode;
            }
            n2 -= n5;
            simpleNode = simpleNode.right;
        }
    }

    public Element<T0> add(int n2, T0 T0, int n3) {
        assert (n2 >= 0);
        assert (n2 <= this.size());
        assert (n3 >= 0);
        if (this.root == null) {
            if (n2 != 0) {
                throw new IndexOutOfBoundsException();
            }
            this.root = new SimpleNode<T0>(n3, T0, null);
            assert (this.valid());
            return this.root;
        }
        SimpleNode<T0> simpleNode = this.insertIntoSubtree(this.root, n2, T0, n3);
        assert (this.valid());
        return simpleNode;
    }

    private SimpleNode<T0> insertIntoSubtree(SimpleNode<T0> simpleNode, int n2, T0 T0, int n3) {
        while (true) {
            SimpleNode<Object> simpleNode2;
            int n4;
            assert (simpleNode != null);
            assert (n2 >= 0);
            SimpleNode simpleNode3 = simpleNode.left;
            int n5 = simpleNode3 != null ? simpleNode3.count1 : 0;
            int n6 = n5 + 1;
            if (n2 <= n5) {
                if (simpleNode3 == null) {
                    SimpleNode<T0> simpleNode4 = new SimpleNode<T0>(n3, T0, simpleNode);
                    simpleNode.left = simpleNode4;
                    this.fixCountsThruRoot(simpleNode, n3);
                    this.fixHeightPostChange(simpleNode, false);
                    return simpleNode4;
                }
                simpleNode = simpleNode3;
                continue;
            }
            if (n2 < n6) {
                n4 = n6 - n2;
                this.fixCountsThruRoot(simpleNode, -n4);
                simpleNode2 = this.insertIntoSubtree(simpleNode, n2, null, n4);
                simpleNode2.set(simpleNode.t0);
                n6 = n5 + 1;
            }
            n4 = simpleNode.count1;
            assert (n2 <= n4);
            simpleNode2 = simpleNode.right;
            if (simpleNode2 == null) {
                SimpleNode<T0> simpleNode5 = new SimpleNode<T0>(n3, T0, simpleNode);
                simpleNode.right = simpleNode5;
                this.fixCountsThruRoot(simpleNode, n3);
                this.fixHeightPostChange(simpleNode, false);
                return simpleNode5;
            }
            simpleNode = simpleNode2;
            n2 -= n6;
        }
    }

    public Element<T0> addInSortedOrder(byte by, T0 T0, int n2) {
        assert (n2 >= 0);
        if (this.root == null) {
            this.root = new SimpleNode<T0>(n2, T0, null);
            assert (this.valid());
            return this.root;
        }
        SimpleNode<T0> simpleNode = this.insertIntoSubtreeInSortedOrder(this.root, T0, n2);
        assert (this.valid());
        return simpleNode;
    }

    private SimpleNode<T0> insertIntoSubtreeInSortedOrder(SimpleNode<T0> simpleNode, T0 T0, int n2) {
        while (true) {
            SimpleNode simpleNode2;
            int n3;
            assert (simpleNode != null);
            SimpleNode<T0> simpleNode3 = simpleNode;
            while (true) {
                if (simpleNode3 == null) {
                    n3 = -1;
                    break;
                }
                if (simpleNode3.sorted == 0) {
                    n3 = this.comparator.compare(T0, simpleNode3.t0);
                    break;
                }
                simpleNode3 = SimpleTree.next(simpleNode3);
            }
            boolean bl = false;
            bl = bl || n3 < 0;
            bl = bl || n3 == 0 && simpleNode.left == null;
            boolean bl2 = bl = bl || n3 == 0 && simpleNode.right != null && simpleNode.left.height < simpleNode.right.height;
            if (bl) {
                simpleNode2 = simpleNode.left;
                if (simpleNode2 == null) {
                    SimpleNode<T0> simpleNode4 = new SimpleNode<T0>(n2, T0, simpleNode);
                    simpleNode.left = simpleNode4;
                    this.fixCountsThruRoot(simpleNode, n2);
                    this.fixHeightPostChange(simpleNode, false);
                    return simpleNode4;
                }
                simpleNode = simpleNode2;
                continue;
            }
            simpleNode2 = simpleNode.right;
            if (simpleNode2 == null) {
                SimpleNode<T0> simpleNode5 = new SimpleNode<T0>(n2, T0, simpleNode);
                simpleNode.right = simpleNode5;
                this.fixCountsThruRoot(simpleNode, n2);
                this.fixHeightPostChange(simpleNode, false);
                return simpleNode5;
            }
            simpleNode = simpleNode2;
        }
    }

    private final void fixCountsThruRoot(SimpleNode<T0> simpleNode, int n2) {
        while (simpleNode != null) {
            simpleNode.count1 += n2;
            simpleNode = simpleNode.parent;
        }
    }

    private final void fixHeightPostChange(SimpleNode<T0> simpleNode, boolean bl) {
        while (simpleNode != null) {
            byte by;
            byte by2;
            byte by3;
            byte by4 = simpleNode.left != null ? simpleNode.left.height : (byte)0;
            byte by5 = by3 = simpleNode.right != null ? simpleNode.right.height : (byte)0;
            if (by4 > by3 && by4 - by3 == 2) {
                by2 = simpleNode.left.left != null ? simpleNode.left.left.height : (byte)0;
                byte by6 = by = simpleNode.left.right != null ? simpleNode.left.right.height : (byte)0;
                if (by > by2) {
                    this.rotateRight(simpleNode.left);
                }
                simpleNode = this.rotateLeft(simpleNode);
            } else if (by3 > by4 && by3 - by4 == 2) {
                by2 = simpleNode.right.left != null ? simpleNode.right.left.height : (byte)0;
                byte by7 = by = simpleNode.right.right != null ? simpleNode.right.right.height : (byte)0;
                if (by2 > by) {
                    this.rotateLeft(simpleNode.right);
                }
                simpleNode = this.rotateRight(simpleNode);
            }
            by4 = simpleNode.left != null ? simpleNode.left.height : (byte)0;
            by3 = simpleNode.right != null ? simpleNode.right.height : (byte)0;
            by2 = (byte)(Math.max(by4, by3) + 1);
            if (!bl && simpleNode.height == by2) {
                return;
            }
            simpleNode.height = by2;
            simpleNode = simpleNode.parent;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final SimpleNode<T0> rotateLeft(SimpleNode<T0> simpleNode) {
        assert (simpleNode.left != null);
        SimpleNode simpleNode2 = simpleNode.left;
        simpleNode.left = simpleNode2.right;
        if (simpleNode2.right != null) {
            simpleNode2.right.parent = simpleNode;
        }
        simpleNode2.parent = simpleNode.parent;
        if (simpleNode2.parent != null) {
            if (simpleNode2.parent.left == simpleNode) {
                simpleNode2.parent.left = simpleNode2;
            } else {
                if (simpleNode2.parent.right != simpleNode) throw new IllegalStateException();
                simpleNode2.parent.right = simpleNode2;
            }
        } else {
            this.root = simpleNode2;
        }
        simpleNode2.right = simpleNode;
        simpleNode.parent = simpleNode2;
        byte by = simpleNode.left != null ? simpleNode.left.height : (byte)0;
        byte by2 = simpleNode.right != null ? simpleNode.right.height : (byte)0;
        simpleNode.height = (byte)(Math.max(by, by2) + 1);
        simpleNode.refreshCounts(!this.zeroQueue.contains(simpleNode));
        byte by3 = simpleNode2.left != null ? simpleNode2.left.height : (byte)0;
        byte by4 = simpleNode2.right != null ? simpleNode2.right.height : (byte)0;
        simpleNode2.height = (byte)(Math.max(by3, by4) + 1);
        simpleNode2.refreshCounts(!this.zeroQueue.contains(simpleNode2));
        return simpleNode2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final SimpleNode<T0> rotateRight(SimpleNode<T0> simpleNode) {
        assert (simpleNode.right != null);
        SimpleNode simpleNode2 = simpleNode.right;
        simpleNode.right = simpleNode2.left;
        if (simpleNode2.left != null) {
            simpleNode2.left.parent = simpleNode;
        }
        simpleNode2.parent = simpleNode.parent;
        if (simpleNode2.parent != null) {
            if (simpleNode2.parent.left == simpleNode) {
                simpleNode2.parent.left = simpleNode2;
            } else {
                if (simpleNode2.parent.right != simpleNode) throw new IllegalStateException();
                simpleNode2.parent.right = simpleNode2;
            }
        } else {
            this.root = simpleNode2;
        }
        simpleNode2.left = simpleNode;
        simpleNode.parent = simpleNode2;
        byte by = simpleNode.left != null ? simpleNode.left.height : (byte)0;
        byte by2 = simpleNode.right != null ? simpleNode.right.height : (byte)0;
        simpleNode.height = (byte)(Math.max(by, by2) + 1);
        simpleNode.refreshCounts(!this.zeroQueue.contains(simpleNode));
        byte by3 = simpleNode2.left != null ? simpleNode2.left.height : (byte)0;
        byte by4 = simpleNode2.right != null ? simpleNode2.right.height : (byte)0;
        simpleNode2.height = (byte)(Math.max(by3, by4) + 1);
        simpleNode2.refreshCounts(!this.zeroQueue.contains(simpleNode2));
        return simpleNode2;
    }

    public void remove(Element<T0> element) {
        SimpleNode simpleNode = (SimpleNode)element;
        assert (this.root != null);
        this.fixCountsThruRoot(simpleNode, -1);
        this.zeroQueue.add(simpleNode);
        this.drainZeroQueue();
        assert (this.valid());
    }

    public void remove(int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        assert (n2 >= 0);
        assert (n2 + n3 <= this.size());
        assert (this.root != null);
        this.removeFromSubtree(this.root, n2, n3);
        this.drainZeroQueue();
        assert (this.valid());
    }

    private void drainZeroQueue() {
        int n2 = this.zeroQueue.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SimpleNode<T0> simpleNode = this.zeroQueue.get(i2);
            if (simpleNode.right == null) {
                this.replaceChild(simpleNode, simpleNode.left);
                continue;
            }
            if (simpleNode.left == null) {
                this.replaceChild(simpleNode, simpleNode.right);
                continue;
            }
            simpleNode = this.replaceEmptyNodeWithChild(simpleNode);
        }
        this.zeroQueue.clear();
    }

    private void removeFromSubtree(SimpleNode<T0> simpleNode, int n2, int n3) {
        while (n3 > 0) {
            int n4;
            int n5;
            assert (simpleNode != null);
            assert (n2 >= 0);
            SimpleNode simpleNode2 = simpleNode.left;
            int n6 = n5 = simpleNode2 != null ? simpleNode2.count1 : 0;
            if (n2 < n5) {
                if (n2 + n3 > n5) {
                    n4 = n5 - n2;
                    this.removeFromSubtree(simpleNode2, n2, n4);
                    n3 -= n4;
                    n5 -= n4;
                } else {
                    simpleNode = simpleNode2;
                    continue;
                }
            }
            assert (n2 >= n5);
            n4 = n5 + 1;
            if (n2 < n4) {
                int n7 = Math.min(n4 - n2, n3);
                n4 -= n7;
                this.fixCountsThruRoot(simpleNode, -n7);
                this.zeroQueue.add(simpleNode);
                if ((n3 -= n7) == 0) {
                    return;
                }
            }
            assert (n2 >= n4);
            n2 -= n4;
            simpleNode = simpleNode.right;
        }
    }

    private void replaceChild(SimpleNode<T0> simpleNode, SimpleNode<T0> simpleNode2) {
        SimpleNode simpleNode3 = simpleNode.parent;
        if (simpleNode3 == null) {
            assert (simpleNode == this.root);
            this.root = simpleNode2;
        } else if (simpleNode3.left == simpleNode) {
            simpleNode3.left = simpleNode2;
        } else if (simpleNode3.right == simpleNode) {
            simpleNode3.right = simpleNode2;
        }
        if (simpleNode2 != null) {
            simpleNode2.parent = simpleNode3;
        }
        this.fixHeightPostChange(simpleNode3, true);
    }

    private SimpleNode<T0> replaceEmptyNodeWithChild(SimpleNode<T0> simpleNode) {
        assert (simpleNode.left != null);
        assert (simpleNode.right != null);
        SimpleNode simpleNode2 = simpleNode.left;
        while (simpleNode2.right != null) {
            simpleNode2 = simpleNode2.right;
        }
        assert (simpleNode2.right == null);
        this.fixCountsThruRoot(simpleNode2, -1);
        this.replaceChild(simpleNode2, simpleNode2.left);
        simpleNode2.left = simpleNode.left;
        if (simpleNode2.left != null) {
            simpleNode2.left.parent = simpleNode2;
        }
        simpleNode2.right = simpleNode.right;
        if (simpleNode2.right != null) {
            simpleNode2.right.parent = simpleNode2;
        }
        simpleNode2.height = simpleNode.height;
        simpleNode2.refreshCounts(!this.zeroQueue.contains(simpleNode2));
        this.replaceChild(simpleNode, simpleNode2);
        this.fixCountsThruRoot(simpleNode2.parent, 1);
        return simpleNode2;
    }

    public Element<T0> set(int n2, T0 T0, int n3) {
        this.remove(n2, n3);
        return this.add(n2, T0, n3);
    }

    public void clear() {
        this.root = null;
    }

    public int indexOfNode(Element<T0> element, byte by) {
        int n2;
        SimpleNode simpleNode = (SimpleNode)element;
        int n3 = n2 = simpleNode.left != null ? simpleNode.left.count1 : 0;
        while (simpleNode.parent != null) {
            if (simpleNode.parent.right == simpleNode) {
                n2 += simpleNode.parent.left != null ? simpleNode.parent.left.count1 : 0;
                ++n2;
            }
            simpleNode = simpleNode.parent;
        }
        return n2;
    }

    public int indexOfValue(T0 T0, boolean bl, boolean bl2, byte by) {
        int n2 = 0;
        boolean bl3 = false;
        SimpleNode<T0> simpleNode = this.root;
        while (true) {
            if (simpleNode == null) {
                if (bl3 && !bl) {
                    --n2;
                }
                if (bl3 || bl2) {
                    return n2;
                }
                return -1;
            }
            int n3 = this.comparator.compare(T0, simpleNode.get());
            if (n3 < 0) {
                simpleNode = simpleNode.left;
                continue;
            }
            SimpleNode simpleNode2 = simpleNode.left;
            if (n3 == 0) {
                bl3 = true;
                if (bl) {
                    simpleNode = simpleNode2;
                    continue;
                }
            }
            n2 += simpleNode2 != null ? simpleNode2.count1 : 0;
            ++n2;
            simpleNode = simpleNode.right;
        }
    }

    public int convertIndexColor(int n2, byte by, byte by2) {
        if (this.root == null) {
            if (n2 == 0) {
                return 0;
            }
            throw new IndexOutOfBoundsException();
        }
        int n3 = 0;
        SimpleNode<T0> simpleNode = this.root;
        while (true) {
            int n4;
            int n5;
            assert (simpleNode != null);
            assert (n2 >= 0);
            SimpleNode simpleNode2 = simpleNode.left;
            int n6 = n5 = simpleNode2 != null ? simpleNode2.count1 : 0;
            if (n2 < n5) {
                simpleNode = simpleNode2;
                continue;
            }
            if (simpleNode2 != null) {
                n3 += simpleNode2.count1;
            }
            if ((n2 -= n5) < (n4 = 1)) {
                return n3 += n2;
            }
            ++n3;
            n2 -= n4;
            simpleNode = simpleNode.right;
        }
    }

    public int size() {
        if (this.root == null) {
            return 0;
        }
        return this.root.count1;
    }

    public String toString() {
        if (this.root == null) {
            return "";
        }
        return this.root.toString();
    }

    public static <T0> SimpleNode<T0> next(SimpleNode<T0> simpleNode) {
        if (simpleNode.right != null) {
            SimpleNode simpleNode2 = simpleNode.right;
            while (simpleNode2.left != null) {
                simpleNode2 = simpleNode2.left;
            }
            return simpleNode2;
        }
        SimpleNode<T0> simpleNode3 = simpleNode;
        while (simpleNode3.parent != null && simpleNode3.parent.right == simpleNode3) {
            simpleNode3 = simpleNode3.parent;
        }
        return simpleNode3.parent;
    }

    public static <T0> SimpleNode<T0> previous(SimpleNode<T0> simpleNode) {
        if (simpleNode.left != null) {
            SimpleNode simpleNode2 = simpleNode.left;
            while (simpleNode2.right != null) {
                simpleNode2 = simpleNode2.right;
            }
            return simpleNode2;
        }
        SimpleNode<T0> simpleNode3 = simpleNode;
        while (simpleNode3.parent != null && simpleNode3.parent.left == simpleNode3) {
            simpleNode3 = simpleNode3.parent;
        }
        return simpleNode3.parent;
    }

    SimpleNode<T0> firstNode() {
        if (this.root == null) {
            return null;
        }
        SimpleNode<T0> simpleNode = this.root;
        while (simpleNode.left != null) {
            simpleNode = simpleNode.left;
        }
        return simpleNode;
    }

    private boolean valid() {
        SimpleNode<T0> simpleNode = this.firstNode();
        while (simpleNode != null) {
            byte by;
            int n2 = simpleNode.count1;
            simpleNode.refreshCounts(!this.zeroQueue.contains(simpleNode));
            assert (n2 == simpleNode.count1) : "Incorrect count 0 on node: \n" + simpleNode + "\n Expected " + simpleNode.count1 + " but was " + n2;
            byte by2 = simpleNode.left != null ? simpleNode.left.height : (byte)0;
            byte by3 = by = simpleNode.right != null ? simpleNode.right.height : (byte)0;
            assert (Math.max(by2, by) + 1 == simpleNode.height);
            assert (simpleNode.left == null || simpleNode.left.parent == simpleNode);
            assert (simpleNode.right == null || simpleNode.right.parent == simpleNode);
            assert (Math.abs(by2 - by) < 2) : "Subtree is not AVL: \n" + simpleNode;
            simpleNode = SimpleTree.next(simpleNode);
        }
        return true;
    }

    static final int colorAsIndex(byte by) {
        switch (by) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 8: {
                return 3;
            }
            case 16: {
                return 4;
            }
            case 32: {
                return 5;
            }
            case 64: {
                return 6;
            }
        }
        throw new IllegalArgumentException();
    }
}

