/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.adt.barcode2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ListToByteCoder<C> {
    private final List<C> allColors;
    private final int colorCount;

    public ListToByteCoder(List<C> list) {
        if (list.size() > 7) {
            throw new IllegalArgumentException("Max 7 colors!");
        }
        this.allColors = Collections.unmodifiableList(new ArrayList<C>(list));
        this.colorCount = this.allColors.size();
    }

    public List<C> getColors() {
        return this.allColors;
    }

    public byte colorsToByte(List<C> list) {
        int n2 = 0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            C c2 = list.get(i2);
            int n3 = this.allColors.indexOf(c2);
            n2 |= 1 << n3;
        }
        return (byte)n2;
    }

    public byte colorToByte(C c2) {
        int n2 = this.allColors.indexOf(c2);
        int n3 = 1 << n2;
        return (byte)n3;
    }

    public C byteToColor(byte by) {
        for (int i2 = 0; i2 < this.colorCount; ++i2) {
            if ((1 << i2 & by) <= 0) continue;
            return this.allColors.get(i2);
        }
        throw new IllegalStateException();
    }

    public List<C> byteToColors(byte by) {
        ArrayList<C> arrayList = new ArrayList<C>(this.colorCount);
        for (int i2 = 0; i2 < this.colorCount; ++i2) {
            if ((1 << i2 & by) <= 0) continue;
            arrayList.add(this.allColors.get(i2));
        }
        return arrayList;
    }
}

