/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.adt.barcode2;

import ca.odell.glazedlists.impl.adt.barcode2.Element;
import ca.odell.glazedlists.impl.adt.barcode2.FourColorNode;
import ca.odell.glazedlists.impl.adt.barcode2.FourColorTree;
import java.util.NoSuchElementException;

public class FourColorTreeIterator<T0> {
    int count1;
    int count2;
    int count4;
    int count8;
    private FourColorTree<T0> tree;
    private FourColorNode<T0> node;
    private int index;

    public FourColorTreeIterator(FourColorTree<T0> fourColorTree) {
        this(fourColorTree, 0, 0);
    }

    public FourColorTreeIterator(FourColorTree<T0> fourColorTree, int n2, byte by) {
        this.tree = fourColorTree;
        if (n2 != 0) {
            int n3 = n2 - 1;
            this.node = (FourColorNode)fourColorTree.get(n3, by);
            this.count1 = fourColorTree.convertIndexColor(n3, by, (byte)1) + (this.node.color == 1 ? 0 : 1);
            this.count2 = fourColorTree.convertIndexColor(n3, by, (byte)2) + (this.node.color == 2 ? 0 : 1);
            this.count4 = fourColorTree.convertIndexColor(n3, by, (byte)4) + (this.node.color == 4 ? 0 : 1);
            this.count8 = fourColorTree.convertIndexColor(n3, by, (byte)8) + (this.node.color == 8 ? 0 : 1);
            if (this.node.color == 1) {
                this.index = this.count1 - fourColorTree.indexOfNode(this.node, (byte)1);
            }
            if (this.node.color == 2) {
                this.index = this.count2 - fourColorTree.indexOfNode(this.node, (byte)2);
            }
            if (this.node.color == 4) {
                this.index = this.count4 - fourColorTree.indexOfNode(this.node, (byte)4);
            }
            if (this.node.color == 8) {
                this.index = this.count8 - fourColorTree.indexOfNode(this.node, (byte)8);
            }
        } else {
            this.node = null;
            this.index = 0;
        }
    }

    public FourColorTreeIterator<T0> copy() {
        FourColorTreeIterator<T0> fourColorTreeIterator = new FourColorTreeIterator<T0>(this.tree);
        fourColorTreeIterator.count1 = this.count1;
        fourColorTreeIterator.count2 = this.count2;
        fourColorTreeIterator.count4 = this.count4;
        fourColorTreeIterator.count8 = this.count8;
        fourColorTreeIterator.node = this.node;
        fourColorTreeIterator.index = this.index;
        return fourColorTreeIterator;
    }

    public boolean hasNext(byte by) {
        if (this.node == null) {
            return this.tree.size(by) > 0;
        }
        if ((by & this.node.color) != 0) {
            return this.index(by) < this.tree.size(by) - 1;
        }
        return this.index(by) < this.tree.size(by);
    }

    public boolean hasNextNode(byte by) {
        if (this.node == null) {
            return this.tree.size(by) > 0;
        }
        return this.nodeEndIndex(by) < this.tree.size(by);
    }

    public void next(byte by) {
        if (!this.hasNext(by)) {
            throw new NoSuchElementException();
        }
        if (this.node == null) {
            this.node = this.tree.firstNode();
            this.index = 0;
            if ((this.node.color & by) != 0) {
                return;
            }
        } else if ((this.node.color & by) != 0 && this.index < this.node.size - 1) {
            if (this.node.color == 1) {
                ++this.count1;
            }
            if (this.node.color == 2) {
                ++this.count2;
            }
            if (this.node.color == 4) {
                ++this.count4;
            }
            if (this.node.color == 8) {
                ++this.count8;
            }
            ++this.index;
            return;
        }
        do {
            if (this.node.color == 1) {
                this.count1 += this.node.size - this.index;
            }
            if (this.node.color == 2) {
                this.count2 += this.node.size - this.index;
            }
            if (this.node.color == 4) {
                this.count4 += this.node.size - this.index;
            }
            if (this.node.color == 8) {
                this.count8 += this.node.size - this.index;
            }
            this.node = FourColorTree.next(this.node);
            this.index = 0;
        } while ((this.node.color & by) == 0);
    }

    public void nextNode(byte by) {
        if (!this.hasNextNode(by)) {
            throw new NoSuchElementException();
        }
        if (this.node == null) {
            this.node = this.tree.firstNode();
            this.index = 0;
            if ((this.node.color & by) != 0) {
                return;
            }
        }
        do {
            if (this.node.color == 1) {
                this.count1 += this.node.size - this.index;
            }
            if (this.node.color == 2) {
                this.count2 += this.node.size - this.index;
            }
            if (this.node.color == 4) {
                this.count4 += this.node.size - this.index;
            }
            if (this.node.color == 8) {
                this.count8 += this.node.size - this.index;
            }
            this.node = FourColorTree.next(this.node);
            this.index = 0;
        } while ((this.node.color & by) == 0);
    }

    public int nodeSize(byte by) {
        if ((this.node.color & by) != 0) {
            return this.node.size;
        }
        return 0;
    }

    public byte color() {
        if (this.node == null) {
            throw new IllegalStateException();
        }
        return this.node.color;
    }

    public int index(byte by) {
        if (this.node == null) {
            throw new NoSuchElementException();
        }
        int n2 = 0;
        if ((by & 1) != 0) {
            n2 += this.count1;
        }
        if ((by & 2) != 0) {
            n2 += this.count2;
        }
        if ((by & 4) != 0) {
            n2 += this.count4;
        }
        if ((by & 8) != 0) {
            n2 += this.count8;
        }
        return n2;
    }

    public int nodeStartIndex(byte by) {
        if (this.node == null) {
            throw new NoSuchElementException();
        }
        int n2 = 0;
        if ((by & 1) != 0) {
            n2 += this.count1;
        }
        if ((by & 2) != 0) {
            n2 += this.count2;
        }
        if ((by & 4) != 0) {
            n2 += this.count4;
        }
        if ((by & 8) != 0) {
            n2 += this.count8;
        }
        if ((this.node.color & by) != 0) {
            n2 -= this.index;
        }
        return n2;
    }

    public int nodeEndIndex(byte by) {
        if (this.node == null) {
            throw new NoSuchElementException();
        }
        return this.nodeStartIndex(by) + this.nodeSize(by);
    }

    public T0 value() {
        if (this.node == null) {
            throw new IllegalStateException();
        }
        return this.node.get();
    }

    public Element<T0> node() {
        if (this.node == null) {
            throw new IllegalStateException();
        }
        return this.node;
    }
}

