/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.adt.barcode2;

import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.impl.adt.barcode2.Element;
import ca.odell.glazedlists.impl.adt.barcode2.FourColorNode;
import ca.odell.glazedlists.impl.adt.barcode2.ListToByteCoder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class FourColorTree<T0> {
    private final ListToByteCoder coder;
    private FourColorNode<T0> root = null;
    private final List<FourColorNode<T0>> zeroQueue = new ArrayList<FourColorNode<T0>>();
    private final Comparator<? super T0> comparator;

    public FourColorTree(ListToByteCoder listToByteCoder, Comparator<? super T0> comparator) {
        if (listToByteCoder == null) {
            throw new NullPointerException("Coder cannot be null.");
        }
        if (comparator == null) {
            throw new NullPointerException("Comparator cannot be null.");
        }
        this.coder = listToByteCoder;
        this.comparator = comparator;
    }

    public FourColorTree(ListToByteCoder listToByteCoder) {
        this(listToByteCoder, GlazedLists.comparableComparator());
    }

    public ListToByteCoder getCoder() {
        return this.coder;
    }

    public Comparator<? super T0> getComparator() {
        return this.comparator;
    }

    public Element<T0> get(int n2, byte by) {
        if (this.root == null) {
            throw new IndexOutOfBoundsException();
        }
        FourColorNode<T0> fourColorNode = this.root;
        while (true) {
            int n3;
            assert (fourColorNode != null);
            assert (n2 >= 0);
            FourColorNode fourColorNode2 = fourColorNode.left;
            int n4 = n3 = fourColorNode2 != null ? fourColorNode2.size(by) : 0;
            if (n2 < n3) {
                fourColorNode = fourColorNode2;
                continue;
            }
            int n5 = fourColorNode.nodeSize(by);
            if ((n2 -= n3) < n5) {
                return fourColorNode;
            }
            n2 -= n5;
            fourColorNode = fourColorNode.right;
        }
    }

    public Element<T0> add(int n2, byte by, byte by2, T0 T0, int n3) {
        assert (n2 >= 0);
        assert (n2 <= this.size(by));
        assert (n3 >= 0);
        if (this.root == null) {
            if (n2 != 0) {
                throw new IndexOutOfBoundsException();
            }
            this.root = new FourColorNode<T0>(by2, n3, T0, null);
            assert (this.valid());
            return this.root;
        }
        FourColorNode<T0> fourColorNode = this.insertIntoSubtree(this.root, n2, by, by2, T0, n3);
        assert (this.valid());
        return fourColorNode;
    }

    private FourColorNode<T0> insertIntoSubtree(FourColorNode<T0> fourColorNode, int n2, byte by, byte by2, T0 T0, int n3) {
        while (true) {
            FourColorNode<Object> fourColorNode2;
            int n4;
            assert (fourColorNode != null);
            assert (n2 >= 0);
            FourColorNode fourColorNode3 = fourColorNode.left;
            int n5 = fourColorNode3 != null ? fourColorNode3.size(by) : 0;
            int n6 = n5 + fourColorNode.nodeSize(by);
            if (by2 == fourColorNode.color && T0 == fourColorNode.t0 && T0 != null && n2 >= n5 && n2 <= n6) {
                fourColorNode.size += n3;
                this.fixCountsThruRoot(fourColorNode, by2, n3);
                return fourColorNode;
            }
            if (n2 <= n5) {
                if (fourColorNode3 == null) {
                    FourColorNode<T0> fourColorNode4 = new FourColorNode<T0>(by2, n3, T0, fourColorNode);
                    fourColorNode.left = fourColorNode4;
                    this.fixCountsThruRoot(fourColorNode, by2, n3);
                    this.fixHeightPostChange(fourColorNode, false);
                    return fourColorNode4;
                }
                fourColorNode = fourColorNode3;
                continue;
            }
            if (n2 < n6) {
                n4 = n6 - n2;
                fourColorNode.size -= n4;
                this.fixCountsThruRoot(fourColorNode, fourColorNode.color, -n4);
                fourColorNode2 = this.insertIntoSubtree(fourColorNode, n2, by, fourColorNode.color, null, n4);
                fourColorNode2.set(fourColorNode.t0);
                n6 = n5 + fourColorNode.nodeSize(by);
            }
            n4 = fourColorNode.size(by);
            assert (n2 <= n4);
            fourColorNode2 = fourColorNode.right;
            if (fourColorNode2 == null) {
                FourColorNode<T0> fourColorNode5 = new FourColorNode<T0>(by2, n3, T0, fourColorNode);
                fourColorNode.right = fourColorNode5;
                this.fixCountsThruRoot(fourColorNode, by2, n3);
                this.fixHeightPostChange(fourColorNode, false);
                return fourColorNode5;
            }
            fourColorNode = fourColorNode2;
            n2 -= n6;
        }
    }

    public Element<T0> addInSortedOrder(byte by, T0 T0, int n2) {
        assert (n2 >= 0);
        if (this.root == null) {
            this.root = new FourColorNode<T0>(by, n2, T0, null);
            assert (this.valid());
            return this.root;
        }
        FourColorNode<T0> fourColorNode = this.insertIntoSubtreeInSortedOrder(this.root, by, T0, n2);
        assert (this.valid());
        return fourColorNode;
    }

    private FourColorNode<T0> insertIntoSubtreeInSortedOrder(FourColorNode<T0> fourColorNode, byte by, T0 T0, int n2) {
        while (true) {
            FourColorNode fourColorNode2;
            int n3;
            assert (fourColorNode != null);
            FourColorNode<T0> fourColorNode3 = fourColorNode;
            while (true) {
                if (fourColorNode3 == null) {
                    n3 = -1;
                    break;
                }
                if (fourColorNode3.sorted == 0) {
                    n3 = this.comparator.compare(T0, fourColorNode3.t0);
                    break;
                }
                fourColorNode3 = FourColorTree.next(fourColorNode3);
            }
            if (n3 == 0 && by == fourColorNode.color && T0 == fourColorNode.t0 && T0 != null) {
                fourColorNode.size += n2;
                this.fixCountsThruRoot(fourColorNode, by, n2);
                return fourColorNode;
            }
            boolean bl = false;
            bl = bl || n3 < 0;
            bl = bl || n3 == 0 && fourColorNode.left == null;
            boolean bl2 = bl = bl || n3 == 0 && fourColorNode.right != null && fourColorNode.left.height < fourColorNode.right.height;
            if (bl) {
                fourColorNode2 = fourColorNode.left;
                if (fourColorNode2 == null) {
                    FourColorNode<T0> fourColorNode4 = new FourColorNode<T0>(by, n2, T0, fourColorNode);
                    fourColorNode.left = fourColorNode4;
                    this.fixCountsThruRoot(fourColorNode, by, n2);
                    this.fixHeightPostChange(fourColorNode, false);
                    return fourColorNode4;
                }
                fourColorNode = fourColorNode2;
                continue;
            }
            fourColorNode2 = fourColorNode.right;
            if (fourColorNode2 == null) {
                FourColorNode<T0> fourColorNode5 = new FourColorNode<T0>(by, n2, T0, fourColorNode);
                fourColorNode.right = fourColorNode5;
                this.fixCountsThruRoot(fourColorNode, by, n2);
                this.fixHeightPostChange(fourColorNode, false);
                return fourColorNode5;
            }
            fourColorNode = fourColorNode2;
        }
    }

    private final void fixCountsThruRoot(FourColorNode<T0> fourColorNode, byte by, int n2) {
        if (by == 1) {
            while (fourColorNode != null) {
                fourColorNode.count1 += n2;
                fourColorNode = fourColorNode.parent;
            }
        }
        if (by == 2) {
            while (fourColorNode != null) {
                fourColorNode.count2 += n2;
                fourColorNode = fourColorNode.parent;
            }
        }
        if (by == 4) {
            while (fourColorNode != null) {
                fourColorNode.count4 += n2;
                fourColorNode = fourColorNode.parent;
            }
        }
        if (by == 8) {
            while (fourColorNode != null) {
                fourColorNode.count8 += n2;
                fourColorNode = fourColorNode.parent;
            }
        }
    }

    public final void setColor(Element<T0> element, byte by) {
        FourColorNode fourColorNode = (FourColorNode)element;
        byte by2 = fourColorNode.getColor();
        if (by2 == by) {
            return;
        }
        this.fixCountsThruRoot(fourColorNode, by2, -fourColorNode.size);
        fourColorNode.color = by;
        this.fixCountsThruRoot(fourColorNode, by, fourColorNode.size);
    }

    private final void fixHeightPostChange(FourColorNode<T0> fourColorNode, boolean bl) {
        while (fourColorNode != null) {
            byte by;
            byte by2;
            byte by3;
            byte by4 = fourColorNode.left != null ? fourColorNode.left.height : (byte)0;
            byte by5 = by3 = fourColorNode.right != null ? fourColorNode.right.height : (byte)0;
            if (by4 > by3 && by4 - by3 == 2) {
                by2 = fourColorNode.left.left != null ? fourColorNode.left.left.height : (byte)0;
                byte by6 = by = fourColorNode.left.right != null ? fourColorNode.left.right.height : (byte)0;
                if (by > by2) {
                    this.rotateRight(fourColorNode.left);
                }
                fourColorNode = this.rotateLeft(fourColorNode);
            } else if (by3 > by4 && by3 - by4 == 2) {
                by2 = fourColorNode.right.left != null ? fourColorNode.right.left.height : (byte)0;
                byte by7 = by = fourColorNode.right.right != null ? fourColorNode.right.right.height : (byte)0;
                if (by2 > by) {
                    this.rotateLeft(fourColorNode.right);
                }
                fourColorNode = this.rotateRight(fourColorNode);
            }
            by4 = fourColorNode.left != null ? fourColorNode.left.height : (byte)0;
            by3 = fourColorNode.right != null ? fourColorNode.right.height : (byte)0;
            by2 = (byte)(Math.max(by4, by3) + 1);
            if (!bl && fourColorNode.height == by2) {
                return;
            }
            fourColorNode.height = by2;
            fourColorNode = fourColorNode.parent;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final FourColorNode<T0> rotateLeft(FourColorNode<T0> fourColorNode) {
        assert (fourColorNode.left != null);
        FourColorNode fourColorNode2 = fourColorNode.left;
        fourColorNode.left = fourColorNode2.right;
        if (fourColorNode2.right != null) {
            fourColorNode2.right.parent = fourColorNode;
        }
        fourColorNode2.parent = fourColorNode.parent;
        if (fourColorNode2.parent != null) {
            if (fourColorNode2.parent.left == fourColorNode) {
                fourColorNode2.parent.left = fourColorNode2;
            } else {
                if (fourColorNode2.parent.right != fourColorNode) throw new IllegalStateException();
                fourColorNode2.parent.right = fourColorNode2;
            }
        } else {
            this.root = fourColorNode2;
        }
        fourColorNode2.right = fourColorNode;
        fourColorNode.parent = fourColorNode2;
        byte by = fourColorNode.left != null ? fourColorNode.left.height : (byte)0;
        byte by2 = fourColorNode.right != null ? fourColorNode.right.height : (byte)0;
        fourColorNode.height = (byte)(Math.max(by, by2) + 1);
        fourColorNode.refreshCounts();
        byte by3 = fourColorNode2.left != null ? fourColorNode2.left.height : (byte)0;
        byte by4 = fourColorNode2.right != null ? fourColorNode2.right.height : (byte)0;
        fourColorNode2.height = (byte)(Math.max(by3, by4) + 1);
        fourColorNode2.refreshCounts();
        return fourColorNode2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final FourColorNode<T0> rotateRight(FourColorNode<T0> fourColorNode) {
        assert (fourColorNode.right != null);
        FourColorNode fourColorNode2 = fourColorNode.right;
        fourColorNode.right = fourColorNode2.left;
        if (fourColorNode2.left != null) {
            fourColorNode2.left.parent = fourColorNode;
        }
        fourColorNode2.parent = fourColorNode.parent;
        if (fourColorNode2.parent != null) {
            if (fourColorNode2.parent.left == fourColorNode) {
                fourColorNode2.parent.left = fourColorNode2;
            } else {
                if (fourColorNode2.parent.right != fourColorNode) throw new IllegalStateException();
                fourColorNode2.parent.right = fourColorNode2;
            }
        } else {
            this.root = fourColorNode2;
        }
        fourColorNode2.left = fourColorNode;
        fourColorNode.parent = fourColorNode2;
        byte by = fourColorNode.left != null ? fourColorNode.left.height : (byte)0;
        byte by2 = fourColorNode.right != null ? fourColorNode.right.height : (byte)0;
        fourColorNode.height = (byte)(Math.max(by, by2) + 1);
        fourColorNode.refreshCounts();
        byte by3 = fourColorNode2.left != null ? fourColorNode2.left.height : (byte)0;
        byte by4 = fourColorNode2.right != null ? fourColorNode2.right.height : (byte)0;
        fourColorNode2.height = (byte)(Math.max(by3, by4) + 1);
        fourColorNode2.refreshCounts();
        return fourColorNode2;
    }

    public void remove(Element<T0> element) {
        FourColorNode fourColorNode = (FourColorNode)element;
        assert (fourColorNode.size > 0);
        assert (this.root != null);
        this.fixCountsThruRoot(fourColorNode, fourColorNode.color, -fourColorNode.size);
        fourColorNode.size = 0;
        this.zeroQueue.add(fourColorNode);
        this.drainZeroQueue();
        assert (this.valid());
    }

    public void remove(int n2, byte by, int n3) {
        if (n3 == 0) {
            return;
        }
        assert (n2 >= 0);
        assert (n2 + n3 <= this.size(by));
        assert (this.root != null);
        this.removeFromSubtree(this.root, n2, by, n3);
        this.drainZeroQueue();
        assert (this.valid());
    }

    private void drainZeroQueue() {
        int n2 = this.zeroQueue.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            FourColorNode<T0> fourColorNode = this.zeroQueue.get(i2);
            assert (fourColorNode.size == 0);
            if (fourColorNode.right == null) {
                this.replaceChild(fourColorNode, fourColorNode.left);
                continue;
            }
            if (fourColorNode.left == null) {
                this.replaceChild(fourColorNode, fourColorNode.right);
                continue;
            }
            fourColorNode = this.replaceEmptyNodeWithChild(fourColorNode);
        }
        this.zeroQueue.clear();
    }

    private void removeFromSubtree(FourColorNode<T0> fourColorNode, int n2, byte by, int n3) {
        while (n3 > 0) {
            int n4;
            int n5;
            assert (fourColorNode != null);
            assert (n2 >= 0);
            FourColorNode fourColorNode2 = fourColorNode.left;
            int n6 = n5 = fourColorNode2 != null ? fourColorNode2.size(by) : 0;
            if (n2 < n5) {
                if (n2 + n3 > n5) {
                    n4 = n5 - n2;
                    this.removeFromSubtree(fourColorNode2, n2, by, n4);
                    n3 -= n4;
                    n5 -= n4;
                } else {
                    fourColorNode = fourColorNode2;
                    continue;
                }
            }
            assert (n2 >= n5);
            n4 = n5 + fourColorNode.nodeSize(by);
            if (n2 < n4) {
                int n7 = Math.min(n4 - n2, n3);
                fourColorNode.size -= n7;
                n3 -= n7;
                n4 -= n7;
                this.fixCountsThruRoot(fourColorNode, fourColorNode.color, -n7);
                if (fourColorNode.size == 0) {
                    this.zeroQueue.add(fourColorNode);
                }
                if (n3 == 0) {
                    return;
                }
            }
            assert (n2 >= n4);
            n2 -= n4;
            fourColorNode = fourColorNode.right;
        }
    }

    private void replaceChild(FourColorNode<T0> fourColorNode, FourColorNode<T0> fourColorNode2) {
        FourColorNode fourColorNode3 = fourColorNode.parent;
        if (fourColorNode3 == null) {
            assert (fourColorNode == this.root);
            this.root = fourColorNode2;
        } else if (fourColorNode3.left == fourColorNode) {
            fourColorNode3.left = fourColorNode2;
        } else if (fourColorNode3.right == fourColorNode) {
            fourColorNode3.right = fourColorNode2;
        }
        if (fourColorNode2 != null) {
            fourColorNode2.parent = fourColorNode3;
        }
        this.fixHeightPostChange(fourColorNode3, true);
    }

    private FourColorNode<T0> replaceEmptyNodeWithChild(FourColorNode<T0> fourColorNode) {
        assert (fourColorNode.size == 0);
        assert (fourColorNode.left != null);
        assert (fourColorNode.right != null);
        FourColorNode fourColorNode2 = fourColorNode.left;
        while (fourColorNode2.right != null) {
            fourColorNode2 = fourColorNode2.right;
        }
        assert (fourColorNode2.right == null);
        this.fixCountsThruRoot(fourColorNode2, fourColorNode2.color, -fourColorNode2.size);
        this.replaceChild(fourColorNode2, fourColorNode2.left);
        fourColorNode2.left = fourColorNode.left;
        if (fourColorNode2.left != null) {
            fourColorNode2.left.parent = fourColorNode2;
        }
        fourColorNode2.right = fourColorNode.right;
        if (fourColorNode2.right != null) {
            fourColorNode2.right.parent = fourColorNode2;
        }
        fourColorNode2.height = fourColorNode.height;
        fourColorNode2.refreshCounts();
        this.replaceChild(fourColorNode, fourColorNode2);
        this.fixCountsThruRoot(fourColorNode2.parent, fourColorNode2.color, fourColorNode2.size);
        return fourColorNode2;
    }

    public Element<T0> set(int n2, byte by, byte by2, T0 T0, int n3) {
        this.remove(n2, by, n3);
        return this.add(n2, by, by2, T0, n3);
    }

    public void clear() {
        this.root = null;
    }

    public int indexOfNode(Element<T0> element, byte by) {
        int n2;
        FourColorNode fourColorNode = (FourColorNode)element;
        int n3 = n2 = fourColorNode.left != null ? fourColorNode.left.size(by) : 0;
        while (fourColorNode.parent != null) {
            if (fourColorNode.parent.right == fourColorNode) {
                n2 += fourColorNode.parent.left != null ? fourColorNode.parent.left.size(by) : 0;
                n2 += fourColorNode.parent.nodeSize(by);
            }
            fourColorNode = fourColorNode.parent;
        }
        return n2;
    }

    public int indexOfValue(T0 T0, boolean bl, boolean bl2, byte by) {
        int n2 = 0;
        boolean bl3 = false;
        FourColorNode<T0> fourColorNode = this.root;
        while (true) {
            if (fourColorNode == null) {
                if (bl3 && !bl) {
                    --n2;
                }
                if (bl3 || bl2) {
                    return n2;
                }
                return -1;
            }
            int n3 = this.comparator.compare(T0, fourColorNode.get());
            if (n3 < 0) {
                fourColorNode = fourColorNode.left;
                continue;
            }
            FourColorNode fourColorNode2 = fourColorNode.left;
            if (n3 == 0) {
                bl3 = true;
                if (bl) {
                    fourColorNode = fourColorNode2;
                    continue;
                }
            }
            n2 += fourColorNode2 != null ? fourColorNode2.size(by) : 0;
            n2 += fourColorNode.nodeSize(by);
            fourColorNode = fourColorNode.right;
        }
    }

    public int convertIndexColor(int n2, byte by, byte by2) {
        if (this.root == null) {
            if (n2 == 0) {
                return 0;
            }
            throw new IndexOutOfBoundsException();
        }
        int n3 = 0;
        FourColorNode<T0> fourColorNode = this.root;
        while (true) {
            int n4;
            int n5;
            assert (fourColorNode != null);
            assert (n2 >= 0);
            FourColorNode fourColorNode2 = fourColorNode.left;
            int n6 = n5 = fourColorNode2 != null ? fourColorNode2.size(by) : 0;
            if (n2 < n5) {
                fourColorNode = fourColorNode2;
                continue;
            }
            if (fourColorNode2 != null) {
                n3 += fourColorNode2.size(by2);
            }
            if ((n2 -= n5) < (n4 = fourColorNode.nodeSize(by))) {
                n3 = (by2 & fourColorNode.color) > 0 ? (n3 += n2) : --n3;
                return n3;
            }
            n3 += fourColorNode.nodeSize(by2);
            n2 -= n4;
            fourColorNode = fourColorNode.right;
        }
    }

    public int size(byte by) {
        if (this.root == null) {
            return 0;
        }
        return this.root.size(by);
    }

    public String toString() {
        if (this.root == null) {
            return "";
        }
        return this.root.toString(this.coder.getColors());
    }

    public String asSequenceOfColors() {
        if (this.root == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        FourColorNode<T0> fourColorNode = this.firstNode();
        while (fourColorNode != null) {
            Object c2 = this.coder.getColors().get(FourColorTree.colorAsIndex(fourColorNode.color));
            for (int i2 = 0; i2 < fourColorNode.size; ++i2) {
                stringBuffer.append(c2);
            }
            fourColorNode = FourColorTree.next(fourColorNode);
        }
        return stringBuffer.toString();
    }

    public static <T0> FourColorNode<T0> next(FourColorNode<T0> fourColorNode) {
        if (fourColorNode.right != null) {
            FourColorNode fourColorNode2 = fourColorNode.right;
            while (fourColorNode2.left != null) {
                fourColorNode2 = fourColorNode2.left;
            }
            return fourColorNode2;
        }
        FourColorNode<T0> fourColorNode3 = fourColorNode;
        while (fourColorNode3.parent != null && fourColorNode3.parent.right == fourColorNode3) {
            fourColorNode3 = fourColorNode3.parent;
        }
        return fourColorNode3.parent;
    }

    public static <T0> FourColorNode<T0> previous(FourColorNode<T0> fourColorNode) {
        if (fourColorNode.left != null) {
            FourColorNode fourColorNode2 = fourColorNode.left;
            while (fourColorNode2.right != null) {
                fourColorNode2 = fourColorNode2.right;
            }
            return fourColorNode2;
        }
        FourColorNode<T0> fourColorNode3 = fourColorNode;
        while (fourColorNode3.parent != null && fourColorNode3.parent.left == fourColorNode3) {
            fourColorNode3 = fourColorNode3.parent;
        }
        return fourColorNode3.parent;
    }

    FourColorNode<T0> firstNode() {
        if (this.root == null) {
            return null;
        }
        FourColorNode<T0> fourColorNode = this.root;
        while (fourColorNode.left != null) {
            fourColorNode = fourColorNode.left;
        }
        return fourColorNode;
    }

    private boolean valid() {
        FourColorNode<T0> fourColorNode = this.firstNode();
        while (fourColorNode != null) {
            byte by;
            int n2 = fourColorNode.count1;
            int n3 = fourColorNode.count2;
            int n4 = fourColorNode.count4;
            int n5 = fourColorNode.count8;
            fourColorNode.refreshCounts();
            assert (n2 == fourColorNode.count1) : "Incorrect count 0 on node: \n" + fourColorNode + "\n Expected " + fourColorNode.count1 + " but was " + n2;
            assert (n3 == fourColorNode.count2) : "Incorrect count 1 on node: \n" + fourColorNode + "\n Expected " + fourColorNode.count2 + " but was " + n3;
            assert (n4 == fourColorNode.count4) : "Incorrect count 2 on node: \n" + fourColorNode + "\n Expected " + fourColorNode.count4 + " but was " + n4;
            assert (n5 == fourColorNode.count8) : "Incorrect count 3 on node: \n" + fourColorNode + "\n Expected " + fourColorNode.count8 + " but was " + n5;
            byte by2 = fourColorNode.left != null ? fourColorNode.left.height : (byte)0;
            byte by3 = by = fourColorNode.right != null ? fourColorNode.right.height : (byte)0;
            assert (Math.max(by2, by) + 1 == fourColorNode.height);
            assert (fourColorNode.left == null || fourColorNode.left.parent == fourColorNode);
            assert (fourColorNode.right == null || fourColorNode.right.parent == fourColorNode);
            assert (Math.abs(by2 - by) < 2) : "Subtree is not AVL: \n" + fourColorNode;
            fourColorNode = FourColorTree.next(fourColorNode);
        }
        return true;
    }

    static final int colorAsIndex(byte by) {
        switch (by) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 8: {
                return 3;
            }
            case 16: {
                return 4;
            }
            case 32: {
                return 5;
            }
            case 64: {
                return 6;
            }
        }
        throw new IllegalArgumentException();
    }
}

