/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.adt.barcode2;

import ca.odell.glazedlists.impl.adt.barcode2.BciiNode;
import ca.odell.glazedlists.impl.adt.barcode2.BciiTree;
import ca.odell.glazedlists.impl.adt.barcode2.Element;
import java.util.NoSuchElementException;

public class BciiTreeIterator<T0, T1> {
    int count1;
    int count2;
    int count4;
    private BciiTree<T0, T1> tree;
    private BciiNode<T0, T1> node;
    private int index;

    public BciiTreeIterator(BciiTree<T0, T1> bciiTree) {
        this(bciiTree, 0, 0);
    }

    public BciiTreeIterator(BciiTree<T0, T1> bciiTree, int n2, byte by) {
        this.tree = bciiTree;
        if (n2 != 0) {
            int n3 = n2 - 1;
            this.node = (BciiNode)bciiTree.get(n3, by);
            this.count1 = bciiTree.convertIndexColor(n3, by, (byte)1) + (this.node.color == 1 ? 0 : 1);
            this.count2 = bciiTree.convertIndexColor(n3, by, (byte)2) + (this.node.color == 2 ? 0 : 1);
            this.count4 = bciiTree.convertIndexColor(n3, by, (byte)4) + (this.node.color == 4 ? 0 : 1);
            if (this.node.color == 1) {
                this.index = this.count1 - bciiTree.indexOfNode(this.node, (byte)1);
            }
            if (this.node.color == 2) {
                this.index = this.count2 - bciiTree.indexOfNode(this.node, (byte)2);
            }
            if (this.node.color == 4) {
                this.index = this.count4 - bciiTree.indexOfNode(this.node, (byte)4);
            }
        } else {
            this.node = null;
            this.index = 0;
        }
    }

    public BciiTreeIterator<T0, T1> copy() {
        BciiTreeIterator<T0, T1> bciiTreeIterator = new BciiTreeIterator<T0, T1>(this.tree);
        bciiTreeIterator.count1 = this.count1;
        bciiTreeIterator.count2 = this.count2;
        bciiTreeIterator.count4 = this.count4;
        bciiTreeIterator.node = this.node;
        bciiTreeIterator.index = this.index;
        return bciiTreeIterator;
    }

    public boolean hasNext(byte by) {
        if (this.node == null) {
            return this.tree.size(by) > 0;
        }
        if ((by & this.node.color) != 0) {
            return this.index(by) < this.tree.size(by) - 1;
        }
        return this.index(by) < this.tree.size(by);
    }

    public boolean hasNextNode(byte by) {
        if (this.node == null) {
            return this.tree.size(by) > 0;
        }
        return this.nodeEndIndex(by) < this.tree.size(by);
    }

    public void next(byte by) {
        if (!this.hasNext(by)) {
            throw new NoSuchElementException();
        }
        if (this.node == null) {
            this.node = this.tree.firstNode();
            this.index = 0;
            if ((this.node.color & by) != 0) {
                return;
            }
        } else if ((this.node.color & by) != 0 && this.index < this.node.size - 1) {
            if (this.node.color == 1) {
                ++this.count1;
            }
            if (this.node.color == 2) {
                ++this.count2;
            }
            if (this.node.color == 4) {
                ++this.count4;
            }
            ++this.index;
            return;
        }
        do {
            if (this.node.color == 1) {
                this.count1 += this.node.size - this.index;
            }
            if (this.node.color == 2) {
                this.count2 += this.node.size - this.index;
            }
            if (this.node.color == 4) {
                this.count4 += this.node.size - this.index;
            }
            this.node = BciiTree.next(this.node);
            this.index = 0;
        } while ((this.node.color & by) == 0);
    }

    public void nextNode(byte by) {
        if (!this.hasNextNode(by)) {
            throw new NoSuchElementException();
        }
        if (this.node == null) {
            this.node = this.tree.firstNode();
            this.index = 0;
            if ((this.node.color & by) != 0) {
                return;
            }
        }
        do {
            if (this.node.color == 1) {
                this.count1 += this.node.size - this.index;
            }
            if (this.node.color == 2) {
                this.count2 += this.node.size - this.index;
            }
            if (this.node.color == 4) {
                this.count4 += this.node.size - this.index;
            }
            this.node = BciiTree.next(this.node);
            this.index = 0;
        } while ((this.node.color & by) == 0);
    }

    public int nodeSize(byte by) {
        if ((this.node.color & by) != 0) {
            return this.node.size;
        }
        return 0;
    }

    public byte color() {
        if (this.node == null) {
            throw new IllegalStateException();
        }
        return this.node.color;
    }

    public int index(byte by) {
        if (this.node == null) {
            throw new NoSuchElementException();
        }
        int n2 = 0;
        if ((by & 1) != 0) {
            n2 += this.count1;
        }
        if ((by & 2) != 0) {
            n2 += this.count2;
        }
        if ((by & 4) != 0) {
            n2 += this.count4;
        }
        return n2;
    }

    public int nodeStartIndex(byte by) {
        if (this.node == null) {
            throw new NoSuchElementException();
        }
        int n2 = 0;
        if ((by & 1) != 0) {
            n2 += this.count1;
        }
        if ((by & 2) != 0) {
            n2 += this.count2;
        }
        if ((by & 4) != 0) {
            n2 += this.count4;
        }
        if ((this.node.color & by) != 0) {
            n2 -= this.index;
        }
        return n2;
    }

    public int nodeEndIndex(byte by) {
        if (this.node == null) {
            throw new NoSuchElementException();
        }
        return this.nodeStartIndex(by) + this.nodeSize(by);
    }

    public T0 value() {
        if (this.node == null) {
            throw new IllegalStateException();
        }
        return this.node.get();
    }

    public Element<T0> node() {
        if (this.node == null) {
            throw new IllegalStateException();
        }
        return this.node;
    }
}

