/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.adt.barcode2;

import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.impl.adt.barcode2.BciiNode;
import ca.odell.glazedlists.impl.adt.barcode2.Element;
import ca.odell.glazedlists.impl.adt.barcode2.ListToByteCoder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class BciiTree<T0, T1> {
    private final ListToByteCoder coder;
    private BciiNode<T0, T1> root = null;
    private final List<BciiNode<T0, T1>> zeroQueue = new ArrayList<BciiNode<T0, T1>>();
    private final Comparator<? super T0> comparator;

    public BciiTree(ListToByteCoder listToByteCoder, Comparator<? super T0> comparator) {
        if (listToByteCoder == null) {
            throw new NullPointerException("Coder cannot be null.");
        }
        if (comparator == null) {
            throw new NullPointerException("Comparator cannot be null.");
        }
        this.coder = listToByteCoder;
        this.comparator = comparator;
    }

    public BciiTree(ListToByteCoder listToByteCoder) {
        this(listToByteCoder, GlazedLists.comparableComparator());
    }

    public ListToByteCoder getCoder() {
        return this.coder;
    }

    public Comparator<? super T0> getComparator() {
        return this.comparator;
    }

    public Element<T0> get(int n2, byte by) {
        if (this.root == null) {
            throw new IndexOutOfBoundsException();
        }
        BciiNode<T0, T1> bciiNode = this.root;
        while (true) {
            int n3;
            assert (bciiNode != null);
            assert (n2 >= 0);
            BciiNode bciiNode2 = bciiNode.left;
            int n4 = n3 = bciiNode2 != null ? bciiNode2.size(by) : 0;
            if (n2 < n3) {
                bciiNode = bciiNode2;
                continue;
            }
            int n5 = bciiNode.nodeSize(by);
            if ((n2 -= n3) < n5) {
                return bciiNode;
            }
            n2 -= n5;
            bciiNode = bciiNode.right;
        }
    }

    public Element<T0> add(int n2, byte by, byte by2, T0 T0, int n3) {
        assert (n2 >= 0);
        assert (n2 <= this.size(by));
        assert (n3 >= 0);
        if (this.root == null) {
            if (n2 != 0) {
                throw new IndexOutOfBoundsException();
            }
            this.root = new BciiNode(by2, n3, T0, null);
            assert (this.valid());
            return this.root;
        }
        BciiNode<T0, T1> bciiNode = this.insertIntoSubtree(this.root, n2, by, by2, T0, n3);
        assert (this.valid());
        return bciiNode;
    }

    private BciiNode<T0, T1> insertIntoSubtree(BciiNode<T0, T1> bciiNode, int n2, byte by, byte by2, T0 T0, int n3) {
        while (true) {
            BciiNode bciiNode2;
            int n4;
            assert (bciiNode != null);
            assert (n2 >= 0);
            BciiNode bciiNode3 = bciiNode.left;
            int n5 = bciiNode3 != null ? bciiNode3.size(by) : 0;
            int n6 = n5 + bciiNode.nodeSize(by);
            if (by2 == bciiNode.color && T0 == bciiNode.t0 && T0 != null && n2 >= n5 && n2 <= n6) {
                bciiNode.size += n3;
                this.fixCountsThruRoot(bciiNode, by2, n3);
                return bciiNode;
            }
            if (n2 <= n5) {
                if (bciiNode3 == null) {
                    BciiNode<T0, T1> bciiNode4 = new BciiNode<T0, T1>(by2, n3, T0, bciiNode);
                    bciiNode.left = bciiNode4;
                    this.fixCountsThruRoot(bciiNode, by2, n3);
                    this.fixHeightPostChange(bciiNode, false);
                    return bciiNode4;
                }
                bciiNode = bciiNode3;
                continue;
            }
            if (n2 < n6) {
                n4 = n6 - n2;
                bciiNode.size -= n4;
                this.fixCountsThruRoot(bciiNode, bciiNode.color, -n4);
                bciiNode2 = this.insertIntoSubtree(bciiNode, n2, by, bciiNode.color, null, n4);
                bciiNode2.set(bciiNode.t0);
                n6 = n5 + bciiNode.nodeSize(by);
            }
            n4 = bciiNode.size(by);
            assert (n2 <= n4);
            bciiNode2 = bciiNode.right;
            if (bciiNode2 == null) {
                BciiNode<T0, T1> bciiNode5 = new BciiNode<T0, T1>(by2, n3, T0, bciiNode);
                bciiNode.right = bciiNode5;
                this.fixCountsThruRoot(bciiNode, by2, n3);
                this.fixHeightPostChange(bciiNode, false);
                return bciiNode5;
            }
            bciiNode = bciiNode2;
            n2 -= n6;
        }
    }

    public Element<T0> addInSortedOrder(byte by, T0 T0, int n2) {
        assert (n2 >= 0);
        if (this.root == null) {
            this.root = new BciiNode(by, n2, T0, null);
            assert (this.valid());
            return this.root;
        }
        BciiNode<T0, T1> bciiNode = this.insertIntoSubtreeInSortedOrder(this.root, by, T0, n2);
        assert (this.valid());
        return bciiNode;
    }

    private BciiNode<T0, T1> insertIntoSubtreeInSortedOrder(BciiNode<T0, T1> bciiNode, byte by, T0 T0, int n2) {
        while (true) {
            BciiNode bciiNode2;
            int n3;
            assert (bciiNode != null);
            BciiNode<T0, T1> bciiNode3 = bciiNode;
            while (true) {
                if (bciiNode3 == null) {
                    n3 = -1;
                    break;
                }
                if (bciiNode3.sorted == 0) {
                    n3 = this.comparator.compare(T0, bciiNode3.t0);
                    break;
                }
                bciiNode3 = BciiTree.next(bciiNode3);
            }
            if (n3 == 0 && by == bciiNode.color && T0 == bciiNode.t0 && T0 != null) {
                bciiNode.size += n2;
                this.fixCountsThruRoot(bciiNode, by, n2);
                return bciiNode;
            }
            boolean bl = false;
            bl = bl || n3 < 0;
            bl = bl || n3 == 0 && bciiNode.left == null;
            boolean bl2 = bl = bl || n3 == 0 && bciiNode.right != null && bciiNode.left.height < bciiNode.right.height;
            if (bl) {
                bciiNode2 = bciiNode.left;
                if (bciiNode2 == null) {
                    BciiNode<T0, T1> bciiNode4 = new BciiNode<T0, T1>(by, n2, T0, bciiNode);
                    bciiNode.left = bciiNode4;
                    this.fixCountsThruRoot(bciiNode, by, n2);
                    this.fixHeightPostChange(bciiNode, false);
                    return bciiNode4;
                }
                bciiNode = bciiNode2;
                continue;
            }
            bciiNode2 = bciiNode.right;
            if (bciiNode2 == null) {
                BciiNode<T0, T1> bciiNode5 = new BciiNode<T0, T1>(by, n2, T0, bciiNode);
                bciiNode.right = bciiNode5;
                this.fixCountsThruRoot(bciiNode, by, n2);
                this.fixHeightPostChange(bciiNode, false);
                return bciiNode5;
            }
            bciiNode = bciiNode2;
        }
    }

    private final void fixCountsThruRoot(BciiNode<T0, T1> bciiNode, byte by, int n2) {
        if (by == 1) {
            while (bciiNode != null) {
                bciiNode.count1 += n2;
                bciiNode = bciiNode.parent;
            }
        }
        if (by == 2) {
            while (bciiNode != null) {
                bciiNode.count2 += n2;
                bciiNode = bciiNode.parent;
            }
        }
        if (by == 4) {
            while (bciiNode != null) {
                bciiNode.count4 += n2;
                bciiNode = bciiNode.parent;
            }
        }
    }

    public final void setColor(Element<T0> element, byte by) {
        BciiNode bciiNode = (BciiNode)element;
        byte by2 = bciiNode.getColor();
        if (by2 == by) {
            return;
        }
        this.fixCountsThruRoot(bciiNode, by2, -bciiNode.size);
        bciiNode.color = by;
        this.fixCountsThruRoot(bciiNode, by, bciiNode.size);
    }

    private final void fixHeightPostChange(BciiNode<T0, T1> bciiNode, boolean bl) {
        while (bciiNode != null) {
            byte by;
            byte by2;
            byte by3;
            byte by4 = bciiNode.left != null ? bciiNode.left.height : (byte)0;
            byte by5 = by3 = bciiNode.right != null ? bciiNode.right.height : (byte)0;
            if (by4 > by3 && by4 - by3 == 2) {
                by2 = bciiNode.left.left != null ? bciiNode.left.left.height : (byte)0;
                byte by6 = by = bciiNode.left.right != null ? bciiNode.left.right.height : (byte)0;
                if (by > by2) {
                    this.rotateRight(bciiNode.left);
                }
                bciiNode = this.rotateLeft(bciiNode);
            } else if (by3 > by4 && by3 - by4 == 2) {
                by2 = bciiNode.right.left != null ? bciiNode.right.left.height : (byte)0;
                byte by7 = by = bciiNode.right.right != null ? bciiNode.right.right.height : (byte)0;
                if (by2 > by) {
                    this.rotateLeft(bciiNode.right);
                }
                bciiNode = this.rotateRight(bciiNode);
            }
            by4 = bciiNode.left != null ? bciiNode.left.height : (byte)0;
            by3 = bciiNode.right != null ? bciiNode.right.height : (byte)0;
            by2 = (byte)(Math.max(by4, by3) + 1);
            if (!bl && bciiNode.height == by2) {
                return;
            }
            bciiNode.height = by2;
            bciiNode = bciiNode.parent;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final BciiNode<T0, T1> rotateLeft(BciiNode<T0, T1> bciiNode) {
        assert (bciiNode.left != null);
        BciiNode bciiNode2 = bciiNode.left;
        bciiNode.left = bciiNode2.right;
        if (bciiNode2.right != null) {
            bciiNode2.right.parent = bciiNode;
        }
        bciiNode2.parent = bciiNode.parent;
        if (bciiNode2.parent != null) {
            if (bciiNode2.parent.left == bciiNode) {
                bciiNode2.parent.left = bciiNode2;
            } else {
                if (bciiNode2.parent.right != bciiNode) throw new IllegalStateException();
                bciiNode2.parent.right = bciiNode2;
            }
        } else {
            this.root = bciiNode2;
        }
        bciiNode2.right = bciiNode;
        bciiNode.parent = bciiNode2;
        byte by = bciiNode.left != null ? bciiNode.left.height : (byte)0;
        byte by2 = bciiNode.right != null ? bciiNode.right.height : (byte)0;
        bciiNode.height = (byte)(Math.max(by, by2) + 1);
        bciiNode.refreshCounts();
        byte by3 = bciiNode2.left != null ? bciiNode2.left.height : (byte)0;
        byte by4 = bciiNode2.right != null ? bciiNode2.right.height : (byte)0;
        bciiNode2.height = (byte)(Math.max(by3, by4) + 1);
        bciiNode2.refreshCounts();
        return bciiNode2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final BciiNode<T0, T1> rotateRight(BciiNode<T0, T1> bciiNode) {
        assert (bciiNode.right != null);
        BciiNode bciiNode2 = bciiNode.right;
        bciiNode.right = bciiNode2.left;
        if (bciiNode2.left != null) {
            bciiNode2.left.parent = bciiNode;
        }
        bciiNode2.parent = bciiNode.parent;
        if (bciiNode2.parent != null) {
            if (bciiNode2.parent.left == bciiNode) {
                bciiNode2.parent.left = bciiNode2;
            } else {
                if (bciiNode2.parent.right != bciiNode) throw new IllegalStateException();
                bciiNode2.parent.right = bciiNode2;
            }
        } else {
            this.root = bciiNode2;
        }
        bciiNode2.left = bciiNode;
        bciiNode.parent = bciiNode2;
        byte by = bciiNode.left != null ? bciiNode.left.height : (byte)0;
        byte by2 = bciiNode.right != null ? bciiNode.right.height : (byte)0;
        bciiNode.height = (byte)(Math.max(by, by2) + 1);
        bciiNode.refreshCounts();
        byte by3 = bciiNode2.left != null ? bciiNode2.left.height : (byte)0;
        byte by4 = bciiNode2.right != null ? bciiNode2.right.height : (byte)0;
        bciiNode2.height = (byte)(Math.max(by3, by4) + 1);
        bciiNode2.refreshCounts();
        return bciiNode2;
    }

    public void remove(Element<T0> element) {
        BciiNode bciiNode = (BciiNode)element;
        assert (bciiNode.size > 0);
        assert (this.root != null);
        this.fixCountsThruRoot(bciiNode, bciiNode.color, -bciiNode.size);
        bciiNode.size = 0;
        this.zeroQueue.add(bciiNode);
        this.drainZeroQueue();
        assert (this.valid());
    }

    public void remove(int n2, byte by, int n3) {
        if (n3 == 0) {
            return;
        }
        assert (n2 >= 0);
        assert (n2 + n3 <= this.size(by));
        assert (this.root != null);
        this.removeFromSubtree(this.root, n2, by, n3);
        this.drainZeroQueue();
        assert (this.valid());
    }

    private void drainZeroQueue() {
        int n2 = this.zeroQueue.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            BciiNode<T0, T1> bciiNode = this.zeroQueue.get(i2);
            assert (bciiNode.size == 0);
            if (bciiNode.right == null) {
                this.replaceChild(bciiNode, bciiNode.left);
                continue;
            }
            if (bciiNode.left == null) {
                this.replaceChild(bciiNode, bciiNode.right);
                continue;
            }
            bciiNode = this.replaceEmptyNodeWithChild(bciiNode);
        }
        this.zeroQueue.clear();
    }

    private void removeFromSubtree(BciiNode<T0, T1> bciiNode, int n2, byte by, int n3) {
        while (n3 > 0) {
            int n4;
            int n5;
            assert (bciiNode != null);
            assert (n2 >= 0);
            BciiNode bciiNode2 = bciiNode.left;
            int n6 = n5 = bciiNode2 != null ? bciiNode2.size(by) : 0;
            if (n2 < n5) {
                if (n2 + n3 > n5) {
                    n4 = n5 - n2;
                    this.removeFromSubtree(bciiNode2, n2, by, n4);
                    n3 -= n4;
                    n5 -= n4;
                } else {
                    bciiNode = bciiNode2;
                    continue;
                }
            }
            assert (n2 >= n5);
            n4 = n5 + bciiNode.nodeSize(by);
            if (n2 < n4) {
                int n7 = Math.min(n4 - n2, n3);
                bciiNode.size -= n7;
                n3 -= n7;
                n4 -= n7;
                this.fixCountsThruRoot(bciiNode, bciiNode.color, -n7);
                if (bciiNode.size == 0) {
                    this.zeroQueue.add(bciiNode);
                }
                if (n3 == 0) {
                    return;
                }
            }
            assert (n2 >= n4);
            n2 -= n4;
            bciiNode = bciiNode.right;
        }
    }

    private void replaceChild(BciiNode<T0, T1> bciiNode, BciiNode<T0, T1> bciiNode2) {
        BciiNode bciiNode3 = bciiNode.parent;
        if (bciiNode3 == null) {
            assert (bciiNode == this.root);
            this.root = bciiNode2;
        } else if (bciiNode3.left == bciiNode) {
            bciiNode3.left = bciiNode2;
        } else if (bciiNode3.right == bciiNode) {
            bciiNode3.right = bciiNode2;
        }
        if (bciiNode2 != null) {
            bciiNode2.parent = bciiNode3;
        }
        this.fixHeightPostChange(bciiNode3, true);
    }

    private BciiNode<T0, T1> replaceEmptyNodeWithChild(BciiNode<T0, T1> bciiNode) {
        assert (bciiNode.size == 0);
        assert (bciiNode.left != null);
        assert (bciiNode.right != null);
        BciiNode bciiNode2 = bciiNode.left;
        while (bciiNode2.right != null) {
            bciiNode2 = bciiNode2.right;
        }
        assert (bciiNode2.right == null);
        this.fixCountsThruRoot(bciiNode2, bciiNode2.color, -bciiNode2.size);
        this.replaceChild(bciiNode2, bciiNode2.left);
        bciiNode2.left = bciiNode.left;
        if (bciiNode2.left != null) {
            bciiNode2.left.parent = bciiNode2;
        }
        bciiNode2.right = bciiNode.right;
        if (bciiNode2.right != null) {
            bciiNode2.right.parent = bciiNode2;
        }
        bciiNode2.height = bciiNode.height;
        bciiNode2.refreshCounts();
        this.replaceChild(bciiNode, bciiNode2);
        this.fixCountsThruRoot(bciiNode2.parent, bciiNode2.color, bciiNode2.size);
        return bciiNode2;
    }

    public Element<T0> set(int n2, byte by, byte by2, T0 T0, int n3) {
        this.remove(n2, by, n3);
        return this.add(n2, by, by2, T0, n3);
    }

    public void clear() {
        this.root = null;
    }

    public int indexOfNode(Element<T0> element, byte by) {
        int n2;
        BciiNode bciiNode = (BciiNode)element;
        int n3 = n2 = bciiNode.left != null ? bciiNode.left.size(by) : 0;
        while (bciiNode.parent != null) {
            if (bciiNode.parent.right == bciiNode) {
                n2 += bciiNode.parent.left != null ? bciiNode.parent.left.size(by) : 0;
                n2 += bciiNode.parent.nodeSize(by);
            }
            bciiNode = bciiNode.parent;
        }
        return n2;
    }

    public int indexOfValue(T0 T0, boolean bl, boolean bl2, byte by) {
        int n2 = 0;
        boolean bl3 = false;
        BciiNode<T0, T1> bciiNode = this.root;
        while (true) {
            if (bciiNode == null) {
                if (bl3 && !bl) {
                    --n2;
                }
                if (bl3 || bl2) {
                    return n2;
                }
                return -1;
            }
            int n3 = this.comparator.compare(T0, bciiNode.get());
            if (n3 < 0) {
                bciiNode = bciiNode.left;
                continue;
            }
            BciiNode bciiNode2 = bciiNode.left;
            if (n3 == 0) {
                bl3 = true;
                if (bl) {
                    bciiNode = bciiNode2;
                    continue;
                }
            }
            n2 += bciiNode2 != null ? bciiNode2.size(by) : 0;
            n2 += bciiNode.nodeSize(by);
            bciiNode = bciiNode.right;
        }
    }

    public int convertIndexColor(int n2, byte by, byte by2) {
        if (this.root == null) {
            if (n2 == 0) {
                return 0;
            }
            throw new IndexOutOfBoundsException();
        }
        int n3 = 0;
        BciiNode<T0, T1> bciiNode = this.root;
        while (true) {
            int n4;
            int n5;
            assert (bciiNode != null);
            assert (n2 >= 0);
            BciiNode bciiNode2 = bciiNode.left;
            int n6 = n5 = bciiNode2 != null ? bciiNode2.size(by) : 0;
            if (n2 < n5) {
                bciiNode = bciiNode2;
                continue;
            }
            if (bciiNode2 != null) {
                n3 += bciiNode2.size(by2);
            }
            if ((n2 -= n5) < (n4 = bciiNode.nodeSize(by))) {
                n3 = (by2 & bciiNode.color) > 0 ? (n3 += n2) : --n3;
                return n3;
            }
            n3 += bciiNode.nodeSize(by2);
            n2 -= n4;
            bciiNode = bciiNode.right;
        }
    }

    public int size(byte by) {
        if (this.root == null) {
            return 0;
        }
        return this.root.size(by);
    }

    public String toString() {
        if (this.root == null) {
            return "";
        }
        return this.root.toString(this.coder.getColors());
    }

    public String asSequenceOfColors() {
        if (this.root == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        BciiNode<T0, T1> bciiNode = this.firstNode();
        while (bciiNode != null) {
            Object c2 = this.coder.getColors().get(BciiTree.colorAsIndex(bciiNode.color));
            for (int i2 = 0; i2 < bciiNode.size; ++i2) {
                stringBuffer.append(c2);
            }
            bciiNode = BciiTree.next(bciiNode);
        }
        return stringBuffer.toString();
    }

    public static <T0, T1> BciiNode<T0, T1> next(BciiNode<T0, T1> bciiNode) {
        if (bciiNode.right != null) {
            BciiNode bciiNode2 = bciiNode.right;
            while (bciiNode2.left != null) {
                bciiNode2 = bciiNode2.left;
            }
            return bciiNode2;
        }
        BciiNode<T0, T1> bciiNode3 = bciiNode;
        while (bciiNode3.parent != null && bciiNode3.parent.right == bciiNode3) {
            bciiNode3 = bciiNode3.parent;
        }
        return bciiNode3.parent;
    }

    public static <T0, T1> BciiNode<T0, T1> previous(BciiNode<T0, T1> bciiNode) {
        if (bciiNode.left != null) {
            BciiNode bciiNode2 = bciiNode.left;
            while (bciiNode2.right != null) {
                bciiNode2 = bciiNode2.right;
            }
            return bciiNode2;
        }
        BciiNode<T0, T1> bciiNode3 = bciiNode;
        while (bciiNode3.parent != null && bciiNode3.parent.left == bciiNode3) {
            bciiNode3 = bciiNode3.parent;
        }
        return bciiNode3.parent;
    }

    BciiNode<T0, T1> firstNode() {
        if (this.root == null) {
            return null;
        }
        BciiNode<T0, T1> bciiNode = this.root;
        while (bciiNode.left != null) {
            bciiNode = bciiNode.left;
        }
        return bciiNode;
    }

    private boolean valid() {
        BciiNode<T0, T1> bciiNode = this.firstNode();
        while (bciiNode != null) {
            byte by;
            int n2 = bciiNode.count1;
            int n3 = bciiNode.count2;
            int n4 = bciiNode.count4;
            bciiNode.refreshCounts();
            assert (n2 == bciiNode.count1) : "Incorrect count 1 on node: \n" + bciiNode + "\n Expected " + bciiNode.count1 + " but was " + n2;
            assert (n3 == bciiNode.count2) : "Incorrect count 2 on node: \n" + bciiNode + "\n Expected " + bciiNode.count2 + " but was " + n3;
            assert (n4 == bciiNode.count4) : "Incorrect count 4 on node: \n" + bciiNode + "\n Expected " + bciiNode.count4 + " but was " + n4;
            byte by2 = bciiNode.left != null ? bciiNode.left.height : (byte)0;
            byte by3 = by = bciiNode.right != null ? bciiNode.right.height : (byte)0;
            assert (Math.max(by2, by) + 1 == bciiNode.height);
            assert (bciiNode.left == null || bciiNode.left.parent == bciiNode);
            assert (bciiNode.right == null || bciiNode.right.parent == bciiNode);
            assert (Math.abs(by2 - by) < 2) : "Subtree is not AVL: \n" + bciiNode;
            bciiNode = BciiTree.next(bciiNode);
        }
        return true;
    }

    static final int colorAsIndex(byte by) {
        switch (by) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 8: {
                return 3;
            }
            case 16: {
                return 4;
            }
            case 32: {
                return 5;
            }
            case 64: {
                return 6;
            }
        }
        throw new IllegalArgumentException();
    }
}

