/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.adt.barcode2;

import ca.odell.glazedlists.impl.adt.barcode2.BciiTree;
import ca.odell.glazedlists.impl.adt.barcode2.Element;
import java.util.Arrays;
import java.util.List;

class BciiNode<T0, T1>
implements Element<T0> {
    int count1;
    int count2;
    int count4;
    byte color;
    T0 t0;
    T1 t1;
    int size;
    byte height;
    BciiNode<T0, T1> left;
    BciiNode<T0, T1> right;
    BciiNode<T0, T1> parent;
    int sorted = 0;

    public BciiNode(byte by, int n2, T0 T0, BciiNode<T0, T1> bciiNode) {
        assert (BciiTree.colorAsIndex(by) >= 0 && BciiTree.colorAsIndex(by) < 7);
        this.color = by;
        this.size = n2;
        this.t0 = T0;
        this.height = 1;
        this.parent = bciiNode;
        if (by == 1) {
            this.count1 += n2;
        }
        if (by == 2) {
            this.count2 += n2;
        }
        if (by == 4) {
            this.count4 += n2;
        }
    }

    @Override
    public T0 get() {
        return this.t0;
    }

    @Override
    public void set(T0 T0) {
        this.t0 = T0;
    }

    @Override
    public byte getColor() {
        return this.color;
    }

    final int size(byte by) {
        int n2 = 0;
        if ((by & 1) != 0) {
            n2 += this.count1;
        }
        if ((by & 2) != 0) {
            n2 += this.count2;
        }
        if ((by & 4) != 0) {
            n2 += this.count4;
        }
        return n2;
    }

    final int nodeSize(byte by) {
        return (by & this.color) > 0 ? this.size : 0;
    }

    final void refreshCounts() {
        this.count1 = 0;
        this.count2 = 0;
        this.count4 = 0;
        if (this.left != null) {
            this.count1 += this.left.count1;
            this.count2 += this.left.count2;
            this.count4 += this.left.count4;
        }
        if (this.right != null) {
            this.count1 += this.right.count1;
            this.count2 += this.right.count2;
            this.count4 += this.right.count4;
        }
        if (this.color == 1) {
            this.count1 += this.size;
        }
        if (this.color == 2) {
            this.count2 += this.size;
        }
        if (this.color == 4) {
            this.count4 += this.size;
        }
    }

    public String toString() {
        return this.toString(Arrays.asList("A", "B", "C", "D", "E", "F", "G", "H"));
    }

    String toString(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        this.asTree(0, stringBuffer, list);
        return stringBuffer.toString();
    }

    void asTree(int n2, StringBuffer stringBuffer, List list) {
        if (this.left != null) {
            this.left.asTree(n2 + 1, stringBuffer, list);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append("   ");
        }
        stringBuffer.append(list.get(BciiTree.colorAsIndex(this.color)));
        stringBuffer.append(" [").append(this.size).append("]");
        if (this.t0 != null) {
            stringBuffer.append(": ");
            if (this.t0 instanceof BciiNode) {
                stringBuffer.append("<Node>");
            } else {
                stringBuffer.append(this.t0);
            }
        }
        stringBuffer.append("\n");
        if (this.right != null) {
            this.right.asTree(n2 + 1, stringBuffer, list);
        }
    }

    @Override
    public void setSorted(int n2) {
        this.sorted = n2;
    }

    @Override
    public int getSorted() {
        return this.sorted;
    }

    @Override
    public Element<T0> next() {
        return BciiTree.next(this);
    }

    @Override
    public Element<T0> previous() {
        return BciiTree.previous(this);
    }
}

