/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.adt;

import ca.odell.glazedlists.impl.adt.SparseList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class SparseListNode {
    private SparseListNode parent;
    private SparseList host;
    private SparseListNode left = null;
    private SparseListNode right = null;
    private int totalRightSize = 0;
    private int totalLeftSize = 0;
    private int emptySpace = 0;
    private int height = 1;
    private Object value = null;

    SparseListNode(SparseList sparseList, SparseListNode sparseListNode, Object object) {
        this.host = sparseList;
        this.parent = sparseListNode;
        this.value = object;
    }

    SparseListNode(SparseList sparseList, SparseListNode sparseListNode, Object object, int n2) {
        this(sparseList, sparseListNode, object);
        this.emptySpace = n2;
    }

    int size() {
        return this.totalLeftSize + this.emptySpace + this.totalRightSize + 1;
    }

    void insert(int n2, Object object) {
        int n3 = n2 - this.totalLeftSize;
        if (n3 < 0) {
            ++this.totalLeftSize;
            this.left.insert(n2, object);
        } else if (n3 > this.emptySpace) {
            ++this.totalRightSize;
            this.right.insert(n3 - this.emptySpace - 1, object);
        } else if (n3 < this.emptySpace) {
            this.emptySpace -= n3;
            this.totalLeftSize += n3 + 1;
            if (this.left == null) {
                this.left = new SparseListNode(this.host, this, object, n3);
                this.ensureAVL();
            } else {
                this.left.insertAtEnd(object, n3);
            }
        } else {
            this.insertAtThisNode(object);
        }
    }

    private void insertAtThisNode(Object object) {
        SparseListNode sparseListNode = new SparseListNode(this.host, this.parent, object, this.emptySpace);
        this.emptySpace = 0;
        sparseListNode.height = this.height;
        this.height = 1;
        sparseListNode.totalRightSize = this.totalRightSize + 1;
        sparseListNode.left = this.left;
        if (this.left != null) {
            sparseListNode.left.parent = sparseListNode;
            sparseListNode.totalLeftSize = this.totalLeftSize;
            this.totalLeftSize = 0;
            this.left = null;
        }
        if (this.parent == null) {
            this.host.setRootNode(sparseListNode);
        } else {
            this.parent.replace(this, sparseListNode);
        }
        if (this.right == null) {
            this.parent = sparseListNode;
            sparseListNode.right = this;
            sparseListNode.ensureAVL();
        } else {
            sparseListNode.right = this.right;
            sparseListNode.right.parent = sparseListNode;
            this.totalRightSize = 0;
            this.right = null;
            sparseListNode.right.moveToSmallest(this);
        }
    }

    void insertAtEnd(Object object, int n2) {
        this.totalRightSize += n2 + 1;
        if (this.right != null) {
            this.right.insertAtEnd(object, n2);
        } else {
            this.right = new SparseListNode(this.host, this, object, n2);
            this.ensureAVL();
        }
    }

    void insertEmptySpace(int n2, int n3) {
        int n4 = n2 - this.totalLeftSize;
        if (n4 < 0) {
            this.totalLeftSize += n3;
            this.left.insertEmptySpace(n2, n3);
        } else if (n4 > this.emptySpace) {
            this.totalRightSize += n3;
            this.right.insertEmptySpace(n4 - this.emptySpace - 1, n3);
        } else {
            this.emptySpace += n3;
        }
    }

    private void moveToSmallest(SparseListNode sparseListNode) {
        this.totalLeftSize += sparseListNode.emptySpace + 1;
        if (this.left != null) {
            this.left.moveToSmallest(sparseListNode);
        } else {
            sparseListNode.parent = this;
            this.left = sparseListNode;
            this.ensureAVL();
        }
    }

    public int getIndex() {
        if (this.parent != null) {
            return this.parent.getIndex(this) + this.totalLeftSize + this.emptySpace;
        }
        return this.totalLeftSize + this.emptySpace;
    }

    private int getIndex(SparseListNode sparseListNode) {
        if (sparseListNode == this.left) {
            if (this.parent != null) {
                return this.parent.getIndex(this);
            }
            return 0;
        }
        if (this.parent != null) {
            return this.parent.getIndex(this) + this.totalLeftSize + this.emptySpace + 1;
        }
        return this.totalLeftSize + this.emptySpace + 1;
    }

    SparseListNode getNode(int n2) {
        int n3 = n2 - this.totalLeftSize;
        if (n3 < 0) {
            return this.left.getNode(n2);
        }
        if (n3 > this.emptySpace) {
            return this.right.getNode(n3 - this.emptySpace - 1);
        }
        if (n3 < this.emptySpace) {
            return null;
        }
        return this;
    }

    public Object getValue() {
        return this.value;
    }

    public Object setValue(Object object) {
        if (object != null) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }
        ++this.emptySpace;
        return this.unlink();
    }

    Object set(int n2, Object object) {
        int n3 = n2 - this.totalLeftSize;
        if (n3 < 0) {
            return this.left.set(n2, object);
        }
        if (n3 > this.emptySpace) {
            return this.right.set(n3 - this.emptySpace - 1, object);
        }
        if (n3 < this.emptySpace) {
            if (object == null) {
                return null;
            }
            --this.emptySpace;
            this.insert(n2, object);
            return null;
        }
        return this.setValue(object);
    }

    Object remove(int n2) {
        int n3 = n2 - this.totalLeftSize;
        if (n3 < 0) {
            --this.totalLeftSize;
            return this.left.remove(n2);
        }
        if (n3 > this.emptySpace) {
            --this.totalRightSize;
            return this.right.remove(n3 - this.emptySpace - 1);
        }
        if (n3 < this.emptySpace) {
            --this.emptySpace;
            return null;
        }
        return this.unlink();
    }

    private Object unlink() {
        int n2 = -1;
        SparseListNode sparseListNode = null;
        boolean bl = false;
        if (this.right != null && this.left != null) {
            return this.unlinkFromTwoChildren();
        }
        if (this.right != null) {
            sparseListNode = this.right;
            sparseListNode.parent = this.parent;
            sparseListNode.emptySpace += this.emptySpace;
        } else {
            if (this.left != null) {
                sparseListNode = this.left;
                sparseListNode.parent = this.parent;
            } else {
                sparseListNode = null;
            }
            if (this.parent == null) {
                n2 = this.emptySpace == 0 ? -1 : this.host.size();
            } else if (this.parent.left == this) {
                bl = true;
                this.parent.emptySpace += this.emptySpace;
                this.parent.totalLeftSize -= this.emptySpace;
            } else if (this.emptySpace != 0) {
                n2 = this.getIndex() - this.emptySpace;
            }
        }
        if (this.parent != null) {
            this.parent.replace(this, sparseListNode);
            this.parent.ensureAVL();
        } else {
            this.host.setRootNode(sparseListNode);
        }
        if (n2 != -1) {
            if (this.parent != null) {
                this.parent.prepareForReinsert(bl, this.emptySpace);
            }
            this.host.addNulls(n2, this.emptySpace);
        }
        return this.clear();
    }

    private Object unlinkFromTwoChildren() {
        SparseListNode sparseListNode = this.right.pruneSmallestChild();
        SparseListNode sparseListNode2 = sparseListNode.parent;
        sparseListNode.emptySpace += this.emptySpace;
        sparseListNode.height = this.height;
        sparseListNode.left = this.left;
        sparseListNode.left.parent = sparseListNode;
        sparseListNode.totalLeftSize = this.totalLeftSize;
        sparseListNode.parent = this.parent;
        if (this.parent == null) {
            this.host.setRootNode(sparseListNode);
        } else {
            this.parent.replace(this, sparseListNode);
        }
        if (sparseListNode2 == this) {
            sparseListNode.ensureAVL();
        } else {
            sparseListNode2.left = sparseListNode.right;
            if (sparseListNode2.left != null) {
                sparseListNode2.left.parent = sparseListNode2;
            }
            sparseListNode2.totalLeftSize = sparseListNode.totalRightSize;
            sparseListNode.right = this.right;
            sparseListNode.right.parent = sparseListNode;
            sparseListNode.totalRightSize = sparseListNode.right.size();
            sparseListNode2.ensureAVL();
        }
        return this.clear();
    }

    private SparseListNode pruneSmallestChild() {
        if (this.left != null) {
            SparseListNode sparseListNode = this.left.pruneSmallestChild();
            this.totalLeftSize -= sparseListNode.emptySpace + 1;
            return sparseListNode;
        }
        return this;
    }

    private void prepareForReinsert(boolean bl, int n2) {
        if (bl) {
            this.totalLeftSize -= n2;
        } else {
            this.totalRightSize -= n2;
        }
        if (this.parent != null) {
            this.parent.prepareForReinsert(this.parent.left == this, n2);
        } else {
            this.host.treeSizeChanged();
        }
    }

    private Object clear() {
        this.left = null;
        this.totalLeftSize = 0;
        this.right = null;
        this.totalRightSize = 0;
        this.host = null;
        this.parent = null;
        this.emptySpace = 0;
        this.height = -1;
        Object object = this.value;
        this.value = null;
        return object;
    }

    private void ensureAVL() {
        int n2 = this.height;
        this.recalculateHeight();
        this.avlRotate();
        if (this.height != n2 && this.parent != null) {
            this.parent.ensureAVL();
        }
    }

    private void replace(SparseListNode sparseListNode, SparseListNode sparseListNode2) {
        if (sparseListNode == this.left) {
            this.left = sparseListNode2;
        } else {
            this.right = sparseListNode2;
        }
    }

    private void recalculateHeight() {
        int n2 = this.left == null ? 0 : this.left.height;
        int n3 = this.right == null ? 0 : this.right.height;
        this.height = 1 + Math.max(n2, n3);
    }

    private void avlRotate() {
        int n2;
        int n3 = this.left != null ? this.left.height : 0;
        int n4 = n2 = this.right != null ? this.right.height : 0;
        if (n3 - n2 >= 2) {
            int n5;
            int n6 = this.left.left != null ? this.left.left.height : 0;
            int n7 = n5 = this.left.right != null ? this.left.right.height : 0;
            if (n5 > n6) {
                this.left.rotateRight();
            }
            this.rotateLeft();
        } else if (n2 - n3 >= 2) {
            int n8;
            int n9 = this.right.left != null ? this.right.left.height : 0;
            int n10 = n8 = this.right.right != null ? this.right.right.height : 0;
            if (n9 > n8) {
                this.right.rotateLeft();
            }
            this.rotateRight();
        }
    }

    private void rotateLeft() {
        SparseListNode sparseListNode = this.left;
        this.left = sparseListNode.right;
        this.totalLeftSize = sparseListNode.totalRightSize;
        if (sparseListNode.right != null) {
            sparseListNode.right.parent = this;
        }
        sparseListNode.right = this;
        sparseListNode.totalRightSize = this.size();
        if (this.parent != null) {
            this.parent.replace(this, sparseListNode);
        } else {
            this.host.setRootNode(sparseListNode);
        }
        sparseListNode.parent = this.parent;
        this.parent = sparseListNode;
        this.recalculateHeight();
        sparseListNode.height = 0;
    }

    private void rotateRight() {
        SparseListNode sparseListNode = this.right;
        this.right = sparseListNode.left;
        this.totalRightSize = sparseListNode.totalLeftSize;
        if (sparseListNode.left != null) {
            sparseListNode.left.parent = this;
        }
        sparseListNode.left = this;
        sparseListNode.totalLeftSize = this.size();
        if (this.parent != null) {
            this.parent.replace(this, sparseListNode);
        } else {
            this.host.setRootNode(sparseListNode);
        }
        sparseListNode.parent = this.parent;
        this.parent = sparseListNode;
        this.recalculateHeight();
        sparseListNode.height = 0;
    }

    public String toString() {
        return "[ " + this.left + " <" + this.emptySpace + "> " + this.value + " <" + this.height + "> " + this.right + " ]";
    }

    private void correctSizes(int n2) {
        if (this.parent != null) {
            if (this.parent.left == this) {
                this.totalLeftSize += n2;
            } else {
                this.totalRightSize += n2;
            }
            this.parent.correctSizes(n2);
        } else {
            this.host.treeSizeChanged();
        }
    }

    static final class SparseListIterator
    implements Iterator {
        private SparseListNode currentNode = null;
        private int timesRequested = -1;
        private SparseList sparseList = null;
        private int treeSize = 0;
        private int size = 0;
        private int index = -1;

        SparseListIterator(SparseList sparseList, SparseListNode sparseListNode) {
            if (sparseListNode != null) {
                this.treeSize = sparseListNode.size();
                this.currentNode = sparseListNode;
                while (this.currentNode.left != null) {
                    this.currentNode = this.currentNode.left;
                }
            }
            this.sparseList = sparseList;
            this.size = sparseList.size();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.treeSize - 1 || this.index != this.size - 1;
        }

        public Object next() {
            ++this.timesRequested;
            ++this.index;
            if (this.currentNode == null) {
                if (this.index < this.size) {
                    return null;
                }
                throw new NoSuchElementException();
            }
            if (this.timesRequested > this.currentNode.emptySpace) {
                if (this.index < this.treeSize) {
                    this.findNextNode();
                    this.timesRequested = 0;
                } else {
                    if (this.index < this.size) {
                        return null;
                    }
                    throw new NoSuchElementException();
                }
            }
            if (this.timesRequested < this.currentNode.emptySpace) {
                return null;
            }
            if (this.timesRequested == this.currentNode.emptySpace) {
                return this.currentNode.value;
            }
            throw new IllegalStateException();
        }

        @Override
        public void remove() {
            if (this.timesRequested == -1) {
                throw new IllegalStateException("Cannot remove() without a prior call to next()");
            }
            if (this.currentNode == null || this.index >= this.treeSize) {
                this.sparseList.remove(this.index);
            } else if (this.timesRequested < this.currentNode.emptySpace) {
                this.currentNode.correctSizes(-1);
                this.currentNode.emptySpace--;
            } else if (this.timesRequested == this.currentNode.emptySpace) {
                this.currentNode.correctSizes(-1);
                SparseListNode sparseListNode = this.currentNode;
                this.findNextNode();
                this.timesRequested = -1;
                sparseListNode.unlink();
            } else {
                throw new IllegalStateException();
            }
        }

        private void findNextNode() {
            if (this.currentNode.right != null) {
                this.currentNode = this.currentNode.right;
                while (this.currentNode.left != null) {
                    this.currentNode = this.currentNode.left;
                }
            } else if (this.currentNode.parent.left == this.currentNode) {
                this.currentNode = this.currentNode.parent;
            } else if (this.currentNode.parent.right == this.currentNode) {
                while (this.currentNode.parent.right == this.currentNode) {
                    this.currentNode = this.currentNode.parent;
                }
                this.currentNode = this.currentNode.parent;
            } else {
                throw new IllegalStateException();
            }
        }

        private void findPreviousNode() {
            throw new UnsupportedOperationException("Not implemented yet.");
        }

        public String toString() {
            return "Accessing " + this.currentNode + " for the " + this.timesRequested + " time.";
        }
    }
}

