/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.adt;

import ca.odell.glazedlists.impl.adt.SparseListNode;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Iterator;

public final class SparseList
extends AbstractList {
    private SparseListNode root = null;
    private int size = 0;
    private int treeSize = 0;

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void add(int n2, Object object) {
        if (object == null) {
            this.addNulls(n2, 1);
        } else if (this.root != null) {
            if (n2 >= this.treeSize) {
                int n3 = n2 - this.treeSize;
                this.size -= n3;
                this.root.insertAtEnd(object, n3);
                this.treeSizeChanged();
            } else {
                this.root.insert(n2, object);
                this.treeSizeChanged();
            }
        } else {
            this.root = new SparseListNode(this, null, object, n2);
            this.treeSize = n2 + 1;
            ++this.size;
        }
    }

    public void addNulls(int n2, int n3) {
        this.size += n3;
        if (this.root != null && n2 < this.treeSize) {
            this.root.insertEmptySpace(n2, n3);
            this.treeSize += n3;
        }
    }

    @Override
    public Object get(int n2) {
        SparseListNode sparseListNode = this.getNode(n2);
        if (sparseListNode == null) {
            return null;
        }
        return sparseListNode.getValue();
    }

    public SparseListNode getNode(int n2) {
        if (this.root != null && n2 < this.treeSize) {
            return this.root.getNode(n2);
        }
        return null;
    }

    @Override
    public Object set(int n2, Object object) {
        if (this.root != null && n2 < this.treeSize) {
            Object object2 = this.root.set(n2, object);
            this.treeSizeChanged();
            return object2;
        }
        if (object == null) {
            return null;
        }
        --this.size;
        this.add(n2, object);
        return null;
    }

    @Override
    public Object remove(int n2) {
        if (this.root != null && n2 < this.treeSize) {
            Object object = this.root.remove(n2);
            this.treeSizeChanged();
            return object;
        }
        --this.size;
        return null;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.root = null;
    }

    void setRootNode(SparseListNode sparseListNode) {
        this.root = sparseListNode;
        if (sparseListNode == null) {
            this.size -= this.treeSize;
            this.treeSize = 0;
        }
    }

    void treeSizeChanged() {
        this.size -= this.treeSize;
        this.treeSize = this.root != null ? this.root.size() : 0;
        this.size += this.treeSize;
    }

    @Override
    public Iterator iterator() {
        if (this.size == 0) {
            return Collections.EMPTY_LIST.iterator();
        }
        return new SparseListNode.SparseListIterator(this, this.root);
    }

    public void printDebug() {
        System.out.println(this.root.toString());
    }
}

