/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.adt;

import java.util.Comparator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public final class KeyedCollection<P, V> {
    private final Map<V, Object> values;
    private final Comparator<P> positionComparator;
    private P first;
    private P last;

    public KeyedCollection(Comparator<P> comparator, Map<V, Object> map) {
        if (!map.isEmpty()) {
            throw new IllegalArgumentException("mapWithValuesAsKeys must be empty");
        }
        this.positionComparator = comparator;
        this.values = map;
    }

    public void insert(P p2, V v2) {
        Object object = this.values.get(v2);
        if (object == null) {
            this.values.put(v2, p2);
        } else if (object instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)object;
            sortedSet.add(p2);
        } else {
            TreeSet<P> treeSet = new TreeSet<P>(this.positionComparator);
            treeSet.add(object);
            treeSet.add(p2);
            this.values.put((TreeSet<P>)v2, treeSet);
        }
        if (this.first == null || this.lessThan(p2, this.first)) {
            this.first = p2;
        }
        if (this.last == null || this.greaterThan(p2, this.last)) {
            this.last = p2;
        }
    }

    public P find(P p2, P p3, V v2) {
        if (this.positionComparator.compare(p2, p3) > 0) {
            throw new IllegalArgumentException("min " + p2 + " > max " + p3);
        }
        Object object = this.values.get(v2);
        if (object == null) {
            return null;
        }
        if (object instanceof SortedSet) {
            SortedSet sortedSet = (SortedSet)object;
            SortedSet<P> sortedSet2 = sortedSet.subSet(p2, p3);
            return sortedSet2.isEmpty() ? null : (P)sortedSet2.iterator().next();
        }
        Object object2 = object;
        if (!this.lessThan(object2, p2) && this.lessThan(object2, p3)) {
            return (P)object2;
        }
        return null;
    }

    public P last() {
        return this.last;
    }

    public P first() {
        return this.first;
    }

    private boolean lessThan(P p2, P p3) {
        return this.positionComparator.compare(p2, p3) < 0;
    }

    private boolean greaterThan(P p2, P p3) {
        return this.positionComparator.compare(p2, p3) > 0;
    }
}

