/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.adt;

public class IntArrayList {
    private int[] data;
    private int size = 0;

    public IntArrayList() {
        this(10);
    }

    public IntArrayList(int n2) {
        this.data = new int[n2];
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        this.size = 0;
    }

    public int get(int n2) {
        this.checkAccess(n2);
        return this.data[n2];
    }

    public void add(int n2) {
        this.checkGrow(1);
        this.data[this.size] = n2;
        ++this.size;
    }

    public void set(int n2, int n3) {
        this.checkAccess(n2);
        this.data[n2] = n3;
    }

    private void checkAccess(int n2) {
        if (this.size <= n2) {
            throw new IndexOutOfBoundsException("Index " + n2 + " is outside list bounds (size=" + this.size + ")");
        }
    }

    private void checkGrow(int n2) {
        if (this.size + n2 <= this.data.length) {
            return;
        }
        int n3 = this.data.length * 2;
        while (n3 < this.size + n2) {
            n3 = this.data.length * 2;
        }
        int[] nArray = new int[n3];
        System.arraycopy(this.data, 0, nArray, 0, this.size);
        this.data = nArray;
    }
}

