/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.adt;

import java.util.AbstractList;

public class CircularArrayList<T>
extends AbstractList<T> {
    int head = 0;
    int size = 0;
    Object[] values = new Object[10];
    int arrayLength = this.values.length;

    @Override
    public T get(int n2) {
        return (T)this.values[this.toCircularIndex(n2)];
    }

    @Override
    public void add(int n2, T t2) {
        this.growIfNecessary();
        int n3 = this.toCircularIndex(n2);
        int n4 = this.distanceToHead(n3);
        int n5 = this.distanceToTail(n3);
        if (n5 <= n4) {
            int n6 = this.tail();
            this.shift(n3, n6, 1);
            this.values[n3] = t2;
        } else {
            this.shift(this.head, n3, -1);
            this.values[this.modIndex((int)(n3 - 1))] = t2;
            this.head = this.modIndex(this.head - 1);
        }
        ++this.size;
    }

    int tail() {
        return this.modIndex(this.head + this.size);
    }

    void growIfNecessary() {
        int n2 = this.size();
        if (n2 < this.arrayLength) {
            return;
        }
        Object[] objectArray = new Object[this.values.length * 2];
        int n3 = this.tail();
        if (this.head < n3) {
            System.arraycopy(this.values, this.head, objectArray, 0, n3 - this.head);
        } else {
            System.arraycopy(this.values, this.head, objectArray, 0, this.arrayLength - this.head);
            System.arraycopy(this.values, 0, objectArray, this.arrayLength - this.head, n3);
        }
        this.values = objectArray;
        this.arrayLength = objectArray.length;
        this.head = 0;
    }

    @Override
    public T remove(int n2) {
        int n3 = this.toCircularIndex(n2);
        int n4 = this.distanceToHead(n3);
        int n5 = this.distanceToTail(n3);
        T t2 = this.get(n2);
        if (n5 < n4) {
            int n6 = this.tail();
            this.shift(n3 + 1, n6, -1);
            this.values[this.modIndex((int)(n6 - 1))] = null;
        } else {
            this.shift(this.head, n3, 1);
            this.values[this.head] = null;
            this.head = this.modIndex(this.head + 1);
        }
        --this.size;
        return t2;
    }

    void shift(int n2, int n3, int n4) {
        if (n4 != 1 && n4 != -1) {
            throw new IllegalArgumentException();
        }
        if (n2 == n3) {
            return;
        }
        if (n3 == 0) {
            n3 = this.arrayLength;
        }
        if (n2 > n3 && n3 != 0) {
            if (n4 == 1) {
                System.arraycopy(this.values, 0, this.values, 1, n3);
                this.values[0] = this.values[this.arrayLength - 1];
                System.arraycopy(this.values, n2, this.values, n2 + 1, this.arrayLength - n2 - 1);
                this.values[n2] = null;
            } else if (n4 == -1) {
                System.arraycopy(this.values, n2, this.values, n2 - 1, this.arrayLength - n2);
                this.values[this.arrayLength - 1] = this.values[0];
                System.arraycopy(this.values, 1, this.values, 0, n3 - 1);
                this.values[n3 - 1] = null;
            }
        } else if (n4 == -1 && n2 == 0) {
            this.values[this.arrayLength - 1] = this.values[0];
            System.arraycopy(this.values, 1, this.values, 0, n3 - 1);
            this.values[n3 - 1] = null;
        } else if (n4 == 1 && n3 == this.arrayLength) {
            this.values[0] = this.values[this.arrayLength - 1];
            System.arraycopy(this.values, n2, this.values, n2 + 1, n3 - n2 - 1);
            this.values[n2] = null;
        } else if (n4 == 1) {
            System.arraycopy(this.values, n2, this.values, n2 + 1, n3 - n2);
            this.values[n2] = null;
        } else if (n4 == -1) {
            System.arraycopy(this.values, n2, this.values, n2 - 1, n3 - n2);
            this.values[n3 - 1] = null;
        }
    }

    private int distanceToTail(int n2) {
        int n3 = this.tail();
        return n2 <= n3 ? n3 - n2 : n3 + this.arrayLength - n2;
    }

    private int distanceToHead(int n2) {
        return n2 >= this.head ? n2 - this.head : n2 + this.arrayLength - this.head;
    }

    @Override
    public int size() {
        return this.size;
    }

    int toCircularIndex(int n2) {
        if (n2 < 0 || n2 > this.size()) {
            throw new IndexOutOfBoundsException("Index " + n2 + " on List of size: " + this.size);
        }
        return this.modIndex(n2 + this.head);
    }

    int modIndex(int n2) {
        return (n2 + this.arrayLength) % this.arrayLength;
    }
}

