/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.adt;

import ca.odell.glazedlists.impl.adt.Barcode;

final class BarcodeNode {
    BarcodeNode parent;
    private Barcode host;
    BarcodeNode left = null;
    BarcodeNode right = null;
    private int blackLeftSize = 0;
    private int blackRightSize = 0;
    private int treeLeftSize = 0;
    private int treeRightSize = 0;
    int whiteSpace = 0;
    int rootSize = 1;
    private int height = 1;

    private BarcodeNode(Barcode barcode, BarcodeNode barcodeNode) {
        this.host = barcode;
        this.parent = barcodeNode;
    }

    BarcodeNode(Barcode barcode, BarcodeNode barcodeNode, int n2, int n3) {
        this(barcode, barcodeNode);
        this.whiteSpace = n3;
        this.rootSize = n2;
    }

    int size() {
        return this.treeLeftSize + this.whiteSpace + this.rootSize + this.treeRightSize;
    }

    int blackSize() {
        return this.blackLeftSize + this.rootSize + this.blackRightSize;
    }

    int whiteSize() {
        return this.treeLeftSize - this.blackLeftSize + this.whiteSpace + (this.treeRightSize - this.blackRightSize);
    }

    void insertBlack(int n2, int n3) {
        int n4 = n2 - this.treeLeftSize;
        if (n4 < 0) {
            this.blackLeftSize += n3;
            this.treeLeftSize += n3;
            this.left.insertBlack(n2, n3);
        } else if (n4 > this.whiteSpace + this.rootSize) {
            this.blackRightSize += n3;
            this.treeRightSize += n3;
            this.right.insertBlack(n4 - this.whiteSpace - this.rootSize, n3);
        } else if (n4 == this.whiteSpace + this.rootSize) {
            this.rootSize += n3;
        } else if (n4 < this.whiteSpace) {
            this.whiteSpace -= n4;
            this.blackLeftSize += n3;
            this.treeLeftSize += n4 + n3;
            if (this.left == null) {
                this.left = new BarcodeNode(this.host, this, n3, n4);
                this.ensureAVL();
            } else {
                this.left.insertBlackAtEnd(n3, n4);
            }
        } else {
            this.rootSize += n3;
        }
    }

    void insertBlackAtEnd(int n2, int n3) {
        if (this.right != null) {
            this.blackRightSize += n2;
            this.treeRightSize += n2 + n3;
            this.right.insertBlackAtEnd(n2, n3);
        } else if (n3 == 0) {
            this.rootSize += n2;
        } else {
            this.blackRightSize += n2;
            this.treeRightSize += n2 + n3;
            this.right = new BarcodeNode(this.host, this, n2, n3);
            this.ensureAVL();
        }
    }

    void insertWhite(int n2, int n3) {
        int n4 = n2 - this.treeLeftSize;
        if (n4 < 0) {
            this.treeLeftSize += n3;
            this.left.insertWhite(n2, n3);
        } else if (n4 > this.whiteSpace + this.rootSize - 1) {
            this.treeRightSize += n3;
            this.right.insertWhite(n4 - this.whiteSpace - this.rootSize, n3);
        } else if (n4 <= this.whiteSpace) {
            this.whiteSpace += n3;
        } else {
            int n5 = this.rootSize - (n4 -= this.whiteSpace);
            this.rootSize = n4;
            this.blackRightSize += n5;
            this.treeRightSize += n5 + n3;
            if (this.right == null) {
                this.right = new BarcodeNode(this.host, this, n5, n3);
                this.ensureAVL();
            } else {
                BarcodeNode barcodeNode = new BarcodeNode(this.host, null, n5, n3);
                this.right.moveToSmallest(barcodeNode);
            }
        }
    }

    private void moveToSmallest(BarcodeNode barcodeNode) {
        if (this.left != null) {
            this.blackLeftSize += barcodeNode.rootSize;
            this.treeLeftSize += barcodeNode.whiteSpace + barcodeNode.rootSize;
            this.left.moveToSmallest(barcodeNode);
        } else if (this.whiteSpace == 0) {
            this.rootSize += barcodeNode.rootSize;
            this.whiteSpace += barcodeNode.whiteSpace;
            barcodeNode.clear();
        } else {
            this.blackLeftSize += barcodeNode.rootSize;
            this.treeLeftSize += barcodeNode.whiteSpace + barcodeNode.rootSize;
            barcodeNode.parent = this;
            this.left = barcodeNode;
            this.ensureAVL();
        }
    }

    int getWhiteIndex(int n2) {
        return this.getWhiteIndex(n2, 0);
    }

    private int getWhiteIndex(int n2, int n3) {
        int n4 = n2 - this.treeLeftSize;
        if (n4 < 0) {
            return this.left.getWhiteIndex(n2, n3);
        }
        if (n4 > this.whiteSpace + this.rootSize - 1) {
            return this.right.getWhiteIndex(n4 - this.whiteSpace - this.rootSize, n3 += this.treeLeftSize - this.blackLeftSize + this.whiteSpace);
        }
        if (n4 < this.whiteSpace) {
            return n3 + (this.treeLeftSize - this.blackLeftSize) + n4;
        }
        return -1;
    }

    int getBlackIndex(int n2) {
        return this.getBlackIndex(n2, 0);
    }

    private int getBlackIndex(int n2, int n3) {
        int n4 = n2 - this.treeLeftSize;
        if (n4 < 0) {
            return this.left.getBlackIndex(n2, n3);
        }
        if (n4 > this.whiteSpace + this.rootSize - 1) {
            return this.right.getBlackIndex(n4 - this.whiteSpace - this.rootSize, n3 + this.blackLeftSize + this.rootSize);
        }
        if (n4 < this.whiteSpace) {
            return -1;
        }
        return n3 + this.blackLeftSize + n4 - this.whiteSpace;
    }

    public int getWhiteIndex(int n2, boolean bl) {
        int n3 = n2 - this.treeLeftSize;
        if (n3 < 0) {
            return this.left.getWhiteIndex(n2, bl);
        }
        if (n3 > this.whiteSpace + this.rootSize - 1) {
            return this.right.getWhiteIndex(n3 - this.whiteSpace - this.rootSize, bl) + this.treeLeftSize - this.blackLeftSize + this.whiteSpace;
        }
        if (n3 < this.whiteSpace) {
            return this.treeLeftSize - this.blackLeftSize + n3;
        }
        if (bl) {
            return this.treeLeftSize - this.blackLeftSize + this.whiteSpace - 1;
        }
        return this.treeLeftSize - this.blackLeftSize + this.whiteSpace;
    }

    public int getBlackIndex(int n2, boolean bl) {
        int n3 = n2 - this.treeLeftSize;
        if (n3 < 0) {
            return this.left.getBlackIndex(n2, bl);
        }
        if (n3 > this.whiteSpace + this.rootSize - 1) {
            return this.right.getBlackIndex(n3 - this.whiteSpace - this.rootSize, bl) + this.blackLeftSize + this.rootSize;
        }
        if (n3 < this.whiteSpace) {
            if (bl) {
                return this.blackLeftSize - 1;
            }
            return this.blackLeftSize;
        }
        return this.blackLeftSize + n3 - this.whiteSpace;
    }

    public int getIndexByWhiteIndex(int n2) {
        int n3 = n2 - (this.treeLeftSize - this.blackLeftSize);
        if (n3 < 0) {
            return this.left.getIndexByWhiteIndex(n2);
        }
        if (n3 >= this.whiteSpace) {
            return this.right.getIndexByWhiteIndex(n3 - this.whiteSpace) + this.treeLeftSize + this.whiteSpace + this.rootSize;
        }
        return this.treeLeftSize + n3;
    }

    public int getIndexByBlackIndex(int n2) {
        int n3 = n2 - this.blackLeftSize;
        if (n3 < 0) {
            return this.left.getIndexByBlackIndex(n2);
        }
        if (n3 >= this.rootSize) {
            return this.right.getIndexByBlackIndex(n3 - this.rootSize) + this.treeLeftSize + this.whiteSpace + this.rootSize;
        }
        return this.treeLeftSize + this.whiteSpace + n3;
    }

    public int getWhiteSequenceIndex(int n2) {
        int n3 = n2 - (this.treeLeftSize - this.blackLeftSize);
        if (n3 < 0) {
            return this.left.getWhiteSequenceIndex(n2);
        }
        if (n3 >= this.whiteSpace) {
            return this.right.getWhiteSequenceIndex(n3 - this.whiteSpace);
        }
        return n3;
    }

    public int getBlackBeforeWhite(int n2) {
        int n3 = n2 - (this.treeLeftSize - this.blackLeftSize);
        if (n3 < 0) {
            return this.left.getBlackBeforeWhite(n2);
        }
        if (n3 >= this.whiteSpace) {
            return this.right.getBlackBeforeWhite(n3 - this.whiteSpace) + this.blackLeftSize + this.rootSize;
        }
        return this.blackLeftSize - 1;
    }

    public int findSequenceOfMinimumSize(int n2, Object object) {
        return this.findFirstFitSequence(n2, object, 0);
    }

    private int findFirstFitSequence(int n2, Object object, int n3) {
        int n4 = -1;
        if (this.left != null) {
            n4 = this.left.findFirstFitSequence(n2, object, n3);
        }
        if (n4 == -1) {
            if (object == Barcode.WHITE && n2 <= this.whiteSpace) {
                return n3 + this.treeLeftSize;
            }
            if (object == Barcode.BLACK && n2 <= this.rootSize) {
                return n3 + this.treeLeftSize + this.whiteSpace;
            }
        }
        if (n4 == -1 && this.right != null) {
            n4 = this.right.findFirstFitSequence(n2, object, n3 + this.treeLeftSize + this.whiteSpace + this.rootSize);
        }
        return n4;
    }

    void set(int n2, Object object, int n3) {
        if (n3 == 1) {
            this.setBaseCase(n2, n2, object);
        } else {
            this.set(n2, n2, object, n3);
        }
    }

    private void set(int n2, int n3, Object object, int n4) {
        int n5 = n3 - this.treeLeftSize;
        if (n5 < 0) {
            this.left.set(n2, n3, object, n4);
        } else if (n5 > this.whiteSpace + this.rootSize - 1) {
            this.right.set(n2, n5 - this.whiteSpace - this.rootSize, object, n4);
        } else if (object == Barcode.WHITE) {
            this.setWhite(n2, n5, n4);
        } else {
            this.setBlack(n2, n5, n4);
        }
    }

    void setWhite(int n2, int n3, int n4) {
        int n5 = n3 + n4 - 1;
        if (n5 >= this.whiteSpace) {
            if (n3 > this.whiteSpace - 1) {
                int n6 = Math.min(n4, this.whiteSpace + this.rootSize - n3);
                if (this.rootSize == n6) {
                    this.whiteSpace += n6;
                    this.rootSize = 0;
                    this.correctSizes(-n6, 0);
                    this.unlink(n2 - n3);
                } else {
                    this.rootSize -= n6;
                    if (n3 < this.whiteSpace + this.rootSize) {
                        this.correctSizes(-n6, 0);
                        this.insertWhite(n3 + this.treeLeftSize, n6);
                    } else {
                        this.correctSizes(-n6, -n6);
                        this.host.addWhite(n2, n6);
                    }
                }
                if (n6 != n4) {
                    this.host.remove(n2 + n6, n4 - n6);
                    this.host.addWhite(n2 + n6, n4 - n6);
                }
            } else if (n3 < this.whiteSpace + 1 && n5 < this.whiteSpace + this.rootSize) {
                int n7 = Math.min(n4, this.whiteSpace + this.rootSize - n3) + (n3 - this.whiteSpace);
                this.rootSize -= n7;
                this.whiteSpace += n7;
                this.correctSizes(-n7, 0);
            } else {
                this.whiteSpace += this.rootSize;
                int n8 = this.whiteSpace - n3;
                this.unlink(n2 - n3);
                if (n8 != n4) {
                    this.host.remove(n2 + n8, n4 - n8);
                    this.host.addWhite(n2 + n8, n4 - n8);
                }
            }
        }
    }

    void setBlack(int n2, int n3, int n4) {
        int n5 = n3 + n4 - 1;
        int n6 = Math.min(n4, this.whiteSpace + this.rootSize - n3);
        if (n3 <= this.whiteSpace - 1) {
            if (n5 > this.whiteSpace - 1) {
                int n7 = this.whiteSpace - n3;
                this.rootSize += n7;
                this.whiteSpace -= n7;
                this.correctSizes(n7, 0);
                this.compressNode(n2 - n3);
            } else {
                this.whiteSpace -= n4;
                this.correctSizes(0, -n4);
                this.host.addBlack(n2, n4);
                this.compressNode(n2 - n3);
            }
        }
        if (n6 != n4) {
            this.host.remove(n2 + n6, n4 - n6);
            this.host.addBlack(n2 + n6, n4 - n6);
        }
    }

    private void setBaseCase(int n2, int n3, Object object) {
        int n4 = n3 - this.treeLeftSize;
        if (n4 < 0) {
            this.left.setBaseCase(n2, n3, object);
        } else if (n4 > this.whiteSpace + this.rootSize) {
            this.right.setBaseCase(n2, n4 - this.whiteSpace - this.rootSize, object);
        } else if (n4 == this.whiteSpace + this.rootSize) {
            if (object != Barcode.WHITE) {
                ++this.rootSize;
                --this.treeRightSize;
                this.correctSizes(1, 0);
                this.right.setFirstNullToTrue(n2, n4 - this.whiteSpace - this.rootSize + 1);
            }
        } else if (n4 < this.whiteSpace) {
            if (object == Barcode.WHITE) {
                return;
            }
            --this.whiteSpace;
            this.correctSizes(1, 0);
            this.insertBlack(n3, 1);
            this.compressNode(n2);
        } else if (n4 == this.whiteSpace) {
            if (object == Barcode.WHITE) {
                ++this.whiteSpace;
                --this.rootSize;
                this.correctSizes(-1, 0);
                if (this.rootSize == 0) {
                    this.unlink(n2 - n4);
                }
            }
        } else if (n4 == this.whiteSpace + this.rootSize - 1) {
            if (object == Barcode.WHITE) {
                --this.rootSize;
                if (this.right != null) {
                    ++this.treeRightSize;
                    this.right.insertWhite(n4 - this.whiteSpace - this.rootSize, 1);
                    this.correctSizes(-1, 0);
                } else if (this.parent != null && this.parent.left == this) {
                    ++this.parent.whiteSpace;
                    --this.parent.treeLeftSize;
                    this.parent.correctSizes(true, -1, 0);
                } else {
                    this.correctSizes(-1, -1);
                    this.host.addWhite(n2, 1);
                }
            }
        } else if (object == Barcode.WHITE) {
            --this.rootSize;
            this.correctSizes(-1, 0);
            this.insertWhite(n3, 1);
        }
    }

    private void setFirstNullToTrue(int n2, int n3) {
        int n4 = n3 - this.treeLeftSize;
        if (n4 < 0) {
            --this.treeLeftSize;
            this.left.setFirstNullToTrue(n2, n3);
        } else if (n4 > this.whiteSpace + this.rootSize - 1) {
            --this.treeRightSize;
            this.right.setFirstNullToTrue(n2, n4 - this.whiteSpace - this.rootSize);
        } else {
            --this.whiteSpace;
            this.compressNode(n2);
        }
    }

    void remove(int n2, int n3) {
        if (n3 == 1) {
            this.removeBaseCase(n2, n2);
        } else {
            this.remove(n2, n2, n3);
        }
    }

    private void remove(int n2, int n3, int n4) {
        int n5 = n3 - this.treeLeftSize;
        if (n5 < 0) {
            this.left.remove(n2, n3, n4);
        } else if (n5 > this.whiteSpace + this.rootSize - 1) {
            this.right.remove(n2, n5 - this.whiteSpace - this.rootSize, n4);
        } else {
            n4 = Math.min(n5 + n4, this.whiteSpace + this.rootSize) - n5;
            int n6 = n5 + n4 - 1;
            if (n5 < this.whiteSpace && n6 < this.whiteSpace + this.rootSize) {
                int n7 = Math.min(this.whiteSpace - n5, n4);
                int n8 = Math.max(n6 - this.whiteSpace + 1, 0);
                this.whiteSpace -= n7;
                this.rootSize -= n8;
                this.correctSizes(-n8, -(n7 + n8));
                this.compressNode(n2 - n5);
            } else if (n5 > this.whiteSpace - 1) {
                if (n4 == this.rootSize) {
                    this.unlink(n2 - n5);
                } else {
                    this.rootSize -= n4;
                    this.correctSizes(-n4, -n4);
                }
            } else {
                int n9 = this.whiteSpace;
                int n10 = this.rootSize;
                this.whiteSpace = 0;
                this.rootSize = 0;
                this.correctSizes(-n10, -(n9 + n10));
                this.unlink(n2 - n5);
            }
        }
    }

    void removeBaseCase(int n2, int n3) {
        int n4 = n3 - this.treeLeftSize;
        if (n4 < 0) {
            --this.treeLeftSize;
            this.left.removeBaseCase(n2, n3);
        } else if (n4 > this.whiteSpace + this.rootSize - 1) {
            --this.treeRightSize;
            this.right.removeBaseCase(n2, n4 - this.whiteSpace - this.rootSize);
        } else if (n4 < this.whiteSpace) {
            --this.whiteSpace;
            this.compressNode(n2);
        } else {
            --this.rootSize;
            if (this.rootSize == 0) {
                this.rootSize = 1;
                this.unlink(n2 - n4, false);
            } else {
                this.correctSizes(-1, 0);
            }
        }
    }

    private void unlink(int n2) {
        this.unlink(n2, true);
    }

    private void unlink(int n2, boolean bl) {
        if (this.right != null && this.left != null) {
            if (this.rootSize != 0) {
                this.correctSizes(-this.rootSize, -this.rootSize, bl);
            }
            this.unlinkWithTwoChildren();
        } else if (this.right != null) {
            this.unlinkWithRightChild(bl);
        } else {
            BarcodeNode barcodeNode = null;
            if (this.left != null) {
                barcodeNode = this.left;
                barcodeNode.parent = this.parent;
            } else {
                barcodeNode = null;
            }
            if (this.parent == null) {
                this.host.setRootNode(barcodeNode);
                if (this.whiteSpace != 0) {
                    this.host.addWhite(this.host.size() + 1, this.whiteSpace);
                }
            } else if (this.parent.left == this) {
                this.parent.whiteSpace += this.whiteSpace;
                this.parent.treeLeftSize -= this.whiteSpace;
                this.parent.left = barcodeNode;
                this.parent.ensureAVL();
                if (this.rootSize != 0) {
                    this.parent.correctSizes(true, -this.rootSize, -this.rootSize, bl);
                }
                this.clear();
            } else {
                this.parent.right = barcodeNode;
                this.parent.ensureAVL();
                if (this.whiteSpace != 0) {
                    this.parent.correctSizes(false, -this.rootSize, -(this.whiteSpace + this.rootSize), bl);
                    this.host.addWhite(n2, this.whiteSpace);
                } else if (this.rootSize != 0) {
                    this.parent.correctSizes(false, -this.rootSize, -this.rootSize, bl);
                }
                this.clear();
            }
        }
    }

    private void unlinkWithTwoChildren() {
        BarcodeNode barcodeNode = this.right.pruneSmallestChild();
        BarcodeNode barcodeNode2 = barcodeNode.parent;
        this.whiteSpace += barcodeNode.whiteSpace;
        this.rootSize = barcodeNode.rootSize;
        this.treeRightSize -= barcodeNode.whiteSpace + barcodeNode.rootSize;
        this.blackRightSize -= barcodeNode.rootSize;
        if (barcodeNode2 == this) {
            this.right = barcodeNode.right;
            if (this.right != null) {
                this.right.parent = this;
            }
            this.ensureAVL();
        } else {
            barcodeNode2.left = barcodeNode.right;
            if (barcodeNode2.left != null) {
                barcodeNode2.left.parent = barcodeNode2;
            }
            barcodeNode2.ensureAVL();
        }
        barcodeNode.clear();
    }

    private void unlinkWithRightChild(boolean bl) {
        this.whiteSpace += this.right.whiteSpace;
        int n2 = this.rootSize;
        this.rootSize = this.right.rootSize;
        this.right.clear();
        this.right = null;
        this.blackRightSize = 0;
        this.treeRightSize = 0;
        this.height = 1;
        if (this.parent != null) {
            if (n2 != 0) {
                this.parent.correctSizes(this.parent.left == this, -n2, -n2, bl);
            }
            this.parent.ensureAVL();
        }
    }

    private BarcodeNode pruneSmallestChild() {
        if (this.left != null) {
            BarcodeNode barcodeNode = this.left.pruneSmallestChild();
            this.blackLeftSize -= barcodeNode.rootSize;
            this.treeLeftSize -= barcodeNode.whiteSpace + barcodeNode.rootSize;
            return barcodeNode;
        }
        return this;
    }

    private void correctSizes(int n2, int n3, boolean bl) {
        if (bl) {
            this.correctSizes(n2, n3);
        } else {
            this.correctSizes(-1, n3 - n2);
        }
    }

    private void correctSizes(boolean bl, int n2, int n3, boolean bl2) {
        if (bl2) {
            this.correctSizes(bl, n2, n3);
        } else {
            this.correctSizes(bl, -1, n3 - n2);
        }
    }

    private void correctSizes(int n2, int n3) {
        if (this.parent != null) {
            this.parent.correctSizes(this.parent.left == this, n2, n3);
        } else {
            this.host.treeSizeChanged();
        }
    }

    private void correctSizes(boolean bl, int n2, int n3) {
        if (bl) {
            this.blackLeftSize += n2;
            this.treeLeftSize += n3;
        } else {
            this.blackRightSize += n2;
            this.treeRightSize += n3;
        }
        if (this.parent != null) {
            this.parent.correctSizes(this.parent.left == this, n2, n3);
        } else {
            this.host.treeSizeChanged();
        }
    }

    private void clear() {
        this.left = null;
        this.blackLeftSize = 0;
        this.treeLeftSize = 0;
        this.right = null;
        this.blackRightSize = 0;
        this.treeRightSize = 0;
        this.host = null;
        this.parent = null;
        this.whiteSpace = 0;
        this.rootSize = 0;
        this.height = -1;
    }

    private void replace(BarcodeNode barcodeNode, BarcodeNode barcodeNode2) {
        if (barcodeNode == this.left) {
            this.left = barcodeNode2;
        } else {
            this.right = barcodeNode2;
        }
    }

    private void compressNode(int n2) {
        if (this.whiteSpace != 0) {
            return;
        }
        if (this.parent == null) {
            this.compressRoot(n2);
        } else if (this.parent.left == this) {
            this.compressLeftChild(n2);
        } else {
            this.compressRightChild(n2);
        }
    }

    private void compressRoot(int n2) {
        if (this.left != null) {
            if (this.right == null) {
                this.left.rootSize += this.rootSize;
                this.left.parent = null;
                this.host.setRootNode(this.left);
                this.clear();
            } else {
                this.left.compressToTheRight(this.rootSize);
                this.blackLeftSize += this.rootSize;
                this.treeLeftSize += this.rootSize;
                this.rootSize = 0;
                this.unlink(n2);
            }
        }
    }

    private void compressLeftChild(int n2) {
        if (this.left != null) {
            this.left.compressToTheRight(this.rootSize);
            this.blackLeftSize += this.rootSize;
            this.treeLeftSize += this.rootSize;
            this.rootSize = 0;
            this.unlink(n2);
        } else {
            if (n2 == 0) {
                return;
            }
            this.parent.left = this.right;
            if (this.right != null) {
                this.parent.left.parent = this.parent;
            }
            this.parent.correctSizes(true, -this.rootSize, -this.rootSize);
            this.parent.ensureAVL();
            this.host.addBlack(n2 - 1, this.rootSize);
            this.clear();
        }
    }

    private void compressRightChild(int n2) {
        if (this.left == null) {
            this.parent.blackRightSize -= this.rootSize;
            this.parent.treeRightSize -= this.rootSize;
            this.parent.rootSize += this.rootSize;
            this.rootSize = 0;
            this.unlink(n2);
        } else {
            this.left.compressToTheRight(this.rootSize);
            this.blackLeftSize += this.rootSize;
            this.treeLeftSize += this.rootSize;
            this.rootSize = 0;
            this.unlink(n2);
        }
    }

    private void compressToTheRight(int n2) {
        if (this.right != null) {
            this.blackRightSize += n2;
            this.treeRightSize += n2;
            this.right.compressToTheRight(n2);
        } else {
            this.rootSize += n2;
        }
    }

    private void ensureAVL() {
        int n2 = this.height;
        this.recalculateHeight();
        this.avlRotate();
        if (this.height != n2 && this.parent != null) {
            this.parent.ensureAVL();
        }
    }

    private void recalculateHeight() {
        int n2 = this.left == null ? 0 : this.left.height;
        int n3 = this.right == null ? 0 : this.right.height;
        this.height = 1 + Math.max(n2, n3);
    }

    private void avlRotate() {
        int n2;
        int n3 = this.left != null ? this.left.height : 0;
        int n4 = n2 = this.right != null ? this.right.height : 0;
        if (n3 - n2 >= 2) {
            int n5;
            int n6 = this.left.left != null ? this.left.left.height : 0;
            int n7 = n5 = this.left.right != null ? this.left.right.height : 0;
            if (n5 > n6) {
                this.left.rotateRight();
            }
            this.rotateLeft();
        } else if (n2 - n3 >= 2) {
            int n8;
            int n9 = this.right.left != null ? this.right.left.height : 0;
            int n10 = n8 = this.right.right != null ? this.right.right.height : 0;
            if (n9 > n8) {
                this.right.rotateLeft();
            }
            this.rotateRight();
        }
    }

    private void rotateLeft() {
        BarcodeNode barcodeNode = this.left;
        this.left = barcodeNode.right;
        this.blackLeftSize = barcodeNode.blackRightSize;
        this.treeLeftSize = barcodeNode.treeRightSize;
        if (barcodeNode.right != null) {
            barcodeNode.right.parent = this;
        }
        barcodeNode.right = this;
        barcodeNode.blackRightSize = this.blackSize();
        barcodeNode.treeRightSize = this.size();
        if (this.parent != null) {
            this.parent.replace(this, barcodeNode);
        } else {
            this.host.setRootNode(barcodeNode);
        }
        barcodeNode.parent = this.parent;
        this.parent = barcodeNode;
        this.recalculateHeight();
        barcodeNode.height = 0;
    }

    private void rotateRight() {
        BarcodeNode barcodeNode = this.right;
        this.right = barcodeNode.left;
        this.blackRightSize = barcodeNode.blackLeftSize;
        this.treeRightSize = barcodeNode.treeLeftSize;
        if (barcodeNode.left != null) {
            barcodeNode.left.parent = this;
        }
        barcodeNode.left = this;
        barcodeNode.blackLeftSize = this.blackSize();
        barcodeNode.treeLeftSize = this.size();
        if (this.parent != null) {
            this.parent.replace(this, barcodeNode);
        } else {
            this.host.setRootNode(barcodeNode);
        }
        barcodeNode.parent = this.parent;
        this.parent = barcodeNode;
        this.recalculateHeight();
        barcodeNode.height = 0;
    }

    public String toString() {
        return "[ " + this.left + " (" + this.blackLeftSize + ", " + this.treeLeftSize + ") <" + this.whiteSpace + "> " + this.rootSize + " <" + this.height + "> (" + this.blackRightSize + ", " + this.treeRightSize + ") " + this.right + " ]";
    }

    public void validate() {
        this.validateLineage();
        this.validateHeight();
        this.validateTreeSize();
        this.validateBlackSize();
        this.validateCompression();
        this.validateRootSize();
    }

    private int validateBlackSize() {
        int n2;
        int n3 = this.left == null ? 0 : this.left.validateBlackSize();
        int n4 = n2 = this.right == null ? 0 : this.right.validateBlackSize();
        if (n3 != this.blackLeftSize) {
            throw new IllegalStateException("Black Size Validation Failure in Left Subtree\nExpected: " + n3 + "\nActual: " + this.blackLeftSize + "\n" + this);
        }
        if (n2 != this.blackRightSize) {
            throw new IllegalStateException("Black Size Validation Failure in Right Subtree\nExpected: " + n2 + "\nActual: " + this.blackRightSize + "\n" + this);
        }
        return n3 + n2 + this.rootSize;
    }

    private int validateHeight() {
        int n2;
        int n3 = this.left == null ? 0 : this.left.validateHeight();
        int n4 = n2 = this.right == null ? 0 : this.right.validateHeight();
        if (this.height != 1 + Math.max(n3, n2)) {
            throw new IllegalStateException("Height Validation Failure\nExpected: " + (1 + Math.max(n3, n2)) + "\nActual: " + this.height + "\n" + this);
        }
        if (Math.abs(n3 - n2) > 1) {
            throw new IllegalStateException("AVL Property Validation Failure\n" + this);
        }
        return 1 + Math.max(n3, n2);
    }

    private void validateLineage() {
        if (this.left != null) {
            if (this.left.parent != this) {
                throw new IllegalStateException("Lineage Validation Failure\nLeft child is orphaned :\n" + this.left);
            }
            this.left.validateLineage();
        }
        if (this.right != null) {
            if (this.right.parent != this) {
                throw new IllegalStateException("Lineage Validation Failure\nRight child is orphaned :\n" + this.right);
            }
            this.right.validateLineage();
        }
    }

    private void validateCompression() {
        if (this.left != null) {
            this.left.validateCompression();
        }
        if (this.right != null) {
            this.right.validateCompression();
        }
        if (this.whiteSpace == 0 && this.getIndexForValidation() != 0) {
            throw new IllegalStateException("Compression Validation Failure\nThe following node was found that could be compressed: \n" + this);
        }
    }

    private int validateTreeSize() {
        int n2;
        int n3 = this.left == null ? 0 : this.left.validateTreeSize();
        int n4 = n2 = this.right == null ? 0 : this.right.validateTreeSize();
        if (this.treeLeftSize != n3) {
            throw new IllegalStateException("Tree Size Validation Failure\nThe following node was found that had a tree size failure on the left subtree: \n" + this);
        }
        if (this.treeRightSize != n2) {
            throw new IllegalStateException("Tree Size Validation Failure\nThe following node was found that had a tree size failure on the right subtree: \n" + this);
        }
        return this.treeLeftSize + this.whiteSpace + this.rootSize + this.treeRightSize;
    }

    private int getIndexForValidation() {
        if (this.parent != null) {
            return this.parent.getIndexForValidation(this) + this.treeLeftSize;
        }
        return this.treeLeftSize;
    }

    private int getIndexForValidation(BarcodeNode barcodeNode) {
        if (barcodeNode == this.left) {
            if (this.parent != null) {
                return this.parent.getIndexForValidation(this);
            }
            return 0;
        }
        if (this.parent != null) {
            return this.parent.getIndexForValidation(this) + this.treeLeftSize + this.whiteSpace + this.rootSize;
        }
        return this.treeLeftSize + this.whiteSpace + this.rootSize;
    }

    private void validateRootSize() {
        if (this.left != null) {
            this.left.validateRootSize();
        }
        if (this.right != null) {
            this.right.validateRootSize();
        }
        if (this.rootSize == 0) {
            throw new IllegalStateException("Root Size Validation Failure\nA node was found with a root size of zero.");
        }
    }
}

