/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.adt;

import ca.odell.glazedlists.impl.adt.BarcodeIterator;
import ca.odell.glazedlists.impl.adt.BarcodeNode;

public final class Barcode {
    public static final Object WHITE = Boolean.FALSE;
    public static final Object BLACK = Boolean.TRUE;
    private BarcodeNode root = null;
    private int whiteSpace = 0;
    private int treeSize = 0;

    public void printDebug() {
        System.out.println("\nTotal Size: " + this.size());
        System.out.println("Trailing Whitespace : " + this.whiteSpace);
        System.out.println("Tree Size: " + this.treeSize);
        System.out.println("Tree Structure:\n" + this.root);
    }

    public void validate() {
        if (this.root != null) {
            this.root.validate();
        }
    }

    public int size() {
        return this.treeSize + this.whiteSpace;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int whiteSize() {
        return this.root == null ? this.whiteSpace : this.root.whiteSize() + this.whiteSpace;
    }

    public int blackSize() {
        return this.root == null ? 0 : this.root.blackSize();
    }

    public int colourSize(Object object) {
        if (object == WHITE) {
            return this.whiteSize();
        }
        return this.blackSize();
    }

    public void add(int n2, Object object, int n3) {
        if (object == WHITE) {
            this.addWhite(n2, n3);
        } else {
            this.addBlack(n2, n3);
        }
    }

    public void addWhite(int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalStateException();
        }
        if (n3 == 0) {
            return;
        }
        if (this.root == null || n2 >= this.treeSize) {
            this.whiteSpace += n3;
        } else {
            this.root.insertWhite(n2, n3);
            this.treeSizeChanged();
        }
    }

    public void addBlack(int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException();
        }
        if (n3 == 0) {
            return;
        }
        if (this.root == null) {
            this.root = new BarcodeNode(this, null, n3, n2);
            this.treeSize = n2 + n3;
            this.whiteSpace -= n2;
        } else if (n2 >= this.treeSize) {
            int n4 = n2 - this.treeSize;
            this.whiteSpace -= n4;
            this.root.insertBlackAtEnd(n3, n4);
            this.treeSizeChanged();
        } else {
            this.root.insertBlack(n2, n3);
            this.treeSizeChanged();
        }
    }

    public Object get(int n2) {
        if (this.getBlackIndex(n2) == -1) {
            return WHITE;
        }
        return BLACK;
    }

    public void set(int n2, Object object, int n3) {
        int n4;
        if (n3 < 1) {
            throw new IllegalArgumentException();
        }
        int n5 = n4 = n2 > this.treeSize - 1 ? n3 : n2 + n3 - this.treeSize;
        if (n4 > 0) {
            if (object == BLACK) {
                this.whiteSpace -= n4;
                this.addBlack(n2, n4);
            }
            if ((n3 -= n4) == 0) {
                return;
            }
        }
        if (this.root != null) {
            this.root.set(n2, object, n3);
            if (this.root != null) {
                this.treeSizeChanged();
            }
        }
    }

    public void setWhite(int n2, int n3) {
        this.set(n2, WHITE, n3);
    }

    public void setBlack(int n2, int n3) {
        this.set(n2, BLACK, n3);
    }

    public void remove(int n2, int n3) {
        int n4;
        if (n3 < 1) {
            throw new IllegalArgumentException();
        }
        int n5 = n4 = n2 > this.treeSize ? n3 : n2 + n3 - this.treeSize;
        if (n4 > 0) {
            this.whiteSpace -= n4;
            n3 -= n4;
        }
        if (this.root != null && n2 < this.treeSize) {
            int n6 = -1;
            while (n3 > 0) {
                n6 = this.treeSize;
                this.root.remove(n2, n3);
                if (this.root != null) {
                    this.treeSizeChanged();
                }
                n3 -= n6 - this.treeSize;
            }
            if (this.root != null) {
                this.treeSizeChanged();
            }
        }
    }

    public void clear() {
        this.treeSize = 0;
        this.whiteSpace = 0;
        this.root = null;
    }

    BarcodeNode getRootNode() {
        return this.root;
    }

    void setRootNode(BarcodeNode barcodeNode) {
        this.root = barcodeNode;
        if (barcodeNode == null) {
            this.treeSize = 0;
        }
    }

    int treeSize() {
        return this.treeSize;
    }

    void treeSizeChanged() {
        this.treeSize = this.root.size();
    }

    public int getIndex(int n2, Object object) {
        if (object == WHITE) {
            if (this.root == null) {
                return n2;
            }
            if (n2 >= this.root.whiteSize()) {
                return n2 - this.root.whiteSize() + this.treeSize;
            }
            return this.root.getIndexByWhiteIndex(n2);
        }
        return this.root.getIndexByBlackIndex(n2);
    }

    public int getColourIndex(int n2, Object object) {
        if (object == WHITE) {
            return this.getWhiteIndex(n2);
        }
        return this.getBlackIndex(n2);
    }

    public int getWhiteIndex(int n2) {
        if (this.root != null && n2 < this.treeSize) {
            return this.root.getWhiteIndex(n2);
        }
        if (this.root != null) {
            return n2 - this.treeSize + this.root.whiteSize();
        }
        return n2;
    }

    public int getBlackIndex(int n2) {
        if (this.root != null && n2 < this.treeSize) {
            return this.root.getBlackIndex(n2);
        }
        return -1;
    }

    public int getColourIndex(int n2, boolean bl, Object object) {
        if (object == WHITE) {
            return this.getWhiteIndex(n2, bl);
        }
        return this.getBlackIndex(n2, bl);
    }

    public int getWhiteIndex(int n2, boolean bl) {
        if (this.root == null) {
            return n2;
        }
        if (n2 >= this.treeSize) {
            return n2 - this.treeSize + this.root.whiteSize();
        }
        return this.root.getWhiteIndex(n2, bl);
    }

    public int getBlackIndex(int n2, boolean bl) {
        if (this.root == null) {
            if (bl) {
                return -1;
            }
            return 0;
        }
        if (n2 >= this.treeSize) {
            if (bl) {
                return this.root.blackSize() - 1;
            }
            return this.root.blackSize();
        }
        return this.root.getBlackIndex(n2, bl);
    }

    public int getWhiteSequenceIndex(int n2) {
        if (this.root == null) {
            return n2;
        }
        if (n2 >= this.root.whiteSize()) {
            return n2 - this.root.whiteSize();
        }
        return this.root.getWhiteSequenceIndex(n2);
    }

    public int getBlackBeforeWhite(int n2) {
        if (this.root == null) {
            return -1;
        }
        if (n2 >= this.root.whiteSize()) {
            return this.root.blackSize() - 1;
        }
        return this.root.getBlackBeforeWhite(n2);
    }

    public int findSequenceOfMinimumSize(int n2, Object object) {
        if (this.root == null) {
            if (object == BLACK) {
                return -1;
            }
            if (this.whiteSpace >= n2) {
                return 0;
            }
            return -1;
        }
        if (object == BLACK) {
            return this.root.findSequenceOfMinimumSize(n2, object);
        }
        int n3 = this.root.findSequenceOfMinimumSize(n2, object);
        if (n3 == -1 && this.whiteSpace >= n2) {
            n3 = this.treeSize;
        }
        return n3;
    }

    public BarcodeIterator iterator() {
        return new BarcodeIterator(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        BarcodeIterator barcodeIterator = this.iterator();
        while (barcodeIterator.hasNext()) {
            stringBuffer.append(barcodeIterator.next() == BLACK ? "X" : "_");
        }
        return stringBuffer.toString();
    }
}

