/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.lang.ref.WeakReference;

public final class WeakReferenceProxy<E>
implements ListEventListener<E> {
    private final WeakReference<ListEventListener<E>> proxyTargetReference;
    private EventList<E> source;

    public WeakReferenceProxy(EventList<E> eventList, ListEventListener<E> listEventListener) {
        if (eventList == null) {
            throw new IllegalArgumentException("source may not be null");
        }
        if (listEventListener == null) {
            throw new IllegalArgumentException("proxyTarget may not be null");
        }
        this.source = eventList;
        this.proxyTargetReference = new WeakReference<ListEventListener<E>>(listEventListener);
    }

    @Override
    public void listChanged(ListEvent<E> listEvent) {
        if (this.source == null) {
            return;
        }
        ListEventListener<E> listEventListener = this.getReferent();
        if (listEventListener == null) {
            this.source.removeListEventListener(this);
            this.dispose();
        } else {
            listEventListener.listChanged(listEvent);
        }
    }

    public ListEventListener<E> getReferent() {
        return (ListEventListener)this.proxyTargetReference.get();
    }

    public void dispose() {
        this.source = null;
    }
}

