/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.util.Set;

public class TypeSafetyListener<E>
implements ListEventListener<E> {
    private final Class[] types;

    public TypeSafetyListener(EventList<E> eventList, Set<Class> set) {
        this.types = set.toArray(new Class[set.size()]);
        eventList.addListEventListener(this);
    }

    @Override
    public void listChanged(ListEvent<E> listEvent) {
        EventList<E> eventList = listEvent.getSourceList();
        while (listEvent.next()) {
            int n2 = listEvent.getType();
            if (n2 == 0) continue;
            int n3 = listEvent.getIndex();
            Object e2 = eventList.get(n3);
            if (n2 == 2 && !this.checkType(e2)) {
                Class<?> clazz = e2 == null ? null : e2.getClass();
                throw new IllegalArgumentException("Element with illegal type " + clazz + " inserted at index " + n3 + ": " + e2);
            }
            if (n2 != 1 || this.checkType(e2)) continue;
            Class<?> clazz = e2 == null ? null : e2.getClass();
            throw new IllegalArgumentException("Element with illegal type " + clazz + " updated at index " + n3 + ": " + e2);
        }
    }

    private boolean checkType(E e2) {
        for (int i2 = 0; i2 < this.types.length; ++i2) {
            if (e2 == null && this.types[i2] != null || !(this.types[i2] == null ? e2 == null : this.types[i2].isAssignableFrom(e2.getClass()))) continue;
            return true;
        }
        return false;
    }
}

