/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import java.util.Collection;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public final class ThreadSafeList<E>
extends TransformedList<E, E> {
    public ThreadSafeList(EventList<E> eventList) {
        super(eventList);
        eventList.addListEventListener(this);
    }

    @Override
    public void listChanged(ListEvent<E> listEvent) {
        this.updates.forwardEvent(listEvent);
    }

    @Override
    public E get(int n2) {
        this.getReadWriteLock().readLock().lock();
        try {
            Object e2 = this.source.get(n2);
            return e2;
        }
        finally {
            this.getReadWriteLock().readLock().unlock();
        }
    }

    @Override
    public int size() {
        this.getReadWriteLock().readLock().lock();
        try {
            int n2 = this.source.size();
            return n2;
        }
        finally {
            this.getReadWriteLock().readLock().unlock();
        }
    }

    @Override
    protected boolean isWritable() {
        return true;
    }

    @Override
    public boolean contains(Object object) {
        this.getReadWriteLock().readLock().lock();
        try {
            boolean bl = this.source.contains(object);
            return bl;
        }
        finally {
            this.getReadWriteLock().readLock().unlock();
        }
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        this.getReadWriteLock().readLock().lock();
        try {
            boolean bl = this.source.containsAll(collection);
            return bl;
        }
        finally {
            this.getReadWriteLock().readLock().unlock();
        }
    }

    @Override
    public boolean equals(Object object) {
        this.getReadWriteLock().readLock().lock();
        try {
            boolean bl = this.source.equals(object);
            return bl;
        }
        finally {
            this.getReadWriteLock().readLock().unlock();
        }
    }

    @Override
    public int hashCode() {
        this.getReadWriteLock().readLock().lock();
        try {
            int n2 = this.source.hashCode();
            return n2;
        }
        finally {
            this.getReadWriteLock().readLock().unlock();
        }
    }

    @Override
    public int indexOf(Object object) {
        this.getReadWriteLock().readLock().lock();
        try {
            int n2 = this.source.indexOf(object);
            return n2;
        }
        finally {
            this.getReadWriteLock().readLock().unlock();
        }
    }

    @Override
    public int lastIndexOf(Object object) {
        this.getReadWriteLock().readLock().lock();
        try {
            int n2 = this.source.lastIndexOf(object);
            return n2;
        }
        finally {
            this.getReadWriteLock().readLock().unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.getReadWriteLock().readLock().lock();
        try {
            boolean bl = this.source.isEmpty();
            return bl;
        }
        finally {
            this.getReadWriteLock().readLock().unlock();
        }
    }

    @Override
    public void forEach(Consumer<? super E> consumer) {
        this.getReadWriteLock().readLock().lock();
        try {
            this.source.forEach(consumer);
        }
        finally {
            this.getReadWriteLock().readLock().unlock();
        }
    }

    @Override
    public Object[] toArray() {
        this.getReadWriteLock().readLock().lock();
        try {
            Object[] objectArray = this.source.toArray();
            return objectArray;
        }
        finally {
            this.getReadWriteLock().readLock().unlock();
        }
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        this.getReadWriteLock().readLock().lock();
        try {
            T[] TArray2 = this.source.toArray(TArray);
            return TArray2;
        }
        finally {
            this.getReadWriteLock().readLock().unlock();
        }
    }

    @Override
    public boolean add(E e2) {
        this.getReadWriteLock().writeLock().lock();
        try {
            boolean bl = this.source.add(e2);
            return bl;
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public boolean remove(Object object) {
        this.getReadWriteLock().writeLock().lock();
        try {
            boolean bl = this.source.remove(object);
            return bl;
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        this.getReadWriteLock().writeLock().lock();
        try {
            boolean bl = this.source.addAll(collection);
            return bl;
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int n2, Collection<? extends E> collection) {
        this.getReadWriteLock().writeLock().lock();
        try {
            boolean bl = this.source.addAll(n2, collection);
            return bl;
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        this.getReadWriteLock().writeLock().lock();
        try {
            boolean bl = this.source.removeAll(collection);
            return bl;
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        this.getReadWriteLock().writeLock().lock();
        try {
            boolean bl = this.source.retainAll(collection);
            return bl;
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.getReadWriteLock().writeLock().lock();
        try {
            this.source.clear();
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int n2, E e2) {
        this.getReadWriteLock().writeLock().lock();
        try {
            E e3 = this.source.set(n2, e2);
            return e3;
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public void add(int n2, E e2) {
        this.getReadWriteLock().writeLock().lock();
        try {
            this.source.add(n2, e2);
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public E remove(int n2) {
        this.getReadWriteLock().writeLock().lock();
        try {
            Object e2 = this.source.remove(n2);
            return e2;
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public boolean removeIf(Predicate<? super E> predicate) {
        this.getReadWriteLock().writeLock().lock();
        try {
            boolean bl = this.source.removeIf(predicate);
            return bl;
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public void replaceAll(UnaryOperator<E> unaryOperator) {
        this.getReadWriteLock().writeLock().lock();
        try {
            this.source.replaceAll(unaryOperator);
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public void sort(Comparator<? super E> comparator) {
        this.getReadWriteLock().writeLock().lock();
        try {
            this.source.sort(comparator);
        }
        finally {
            this.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public String toString() {
        this.getReadWriteLock().readLock().lock();
        try {
            String string = this.source.toString();
            return string;
        }
        finally {
            this.getReadWriteLock().readLock().unlock();
        }
    }
}

