/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.impl.WeakReferenceProxy;

public final class SubEventList<E>
extends TransformedList<E, E> {
    private int startIndex;
    private int endIndex;

    public SubEventList(EventList<E> eventList, int n2, int n3, boolean bl) {
        super(eventList);
        if (n2 < 0 || n3 < n2 || n3 > eventList.size()) {
            throw new IllegalArgumentException("The range " + n2 + "-" + n3 + " is not valid over a list of size " + eventList.size());
        }
        this.startIndex = n2;
        this.endIndex = n3;
        if (bl) {
            eventList.addListEventListener(new WeakReferenceProxy<E>(eventList, this));
        } else {
            eventList.addListEventListener(this);
        }
    }

    @Override
    public int size() {
        return this.endIndex - this.startIndex;
    }

    @Override
    protected int getSourceIndex(int n2) {
        return n2 + this.startIndex;
    }

    @Override
    protected boolean isWritable() {
        return true;
    }

    @Override
    public void listChanged(ListEvent<E> listEvent) {
        this.updates.beginEvent();
        if (listEvent.isReordering() && this.size() == 1) {
            int[] nArray = listEvent.getReorderMap();
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (nArray[i2] != this.startIndex) continue;
                this.startIndex = i2;
                this.endIndex = this.startIndex + 1;
                break;
            }
        } else {
            while (listEvent.next()) {
                int n2 = listEvent.getIndex();
                int n3 = listEvent.getType();
                if (n2 < this.startIndex || n3 == 2 && n2 == this.startIndex) {
                    if (n3 == 2) {
                        ++this.startIndex;
                        ++this.endIndex;
                        continue;
                    }
                    if (n3 != 0) continue;
                    --this.startIndex;
                    --this.endIndex;
                    continue;
                }
                if (n2 >= this.endIndex) continue;
                if (n3 == 2) {
                    ++this.endIndex;
                    this.updates.elementInserted(n2 - this.startIndex, listEvent.getNewValue());
                    continue;
                }
                if (n3 == 1) {
                    this.updates.elementUpdated(n2 - this.startIndex, listEvent.getOldValue(), listEvent.getNewValue());
                    continue;
                }
                if (n3 != 0) continue;
                --this.endIndex;
                this.updates.elementDeleted(n2 - this.startIndex, listEvent.getOldValue());
            }
        }
        if (this.startIndex > this.endIndex) {
            throw new IllegalStateException();
        }
        this.updates.commitEvent();
    }
}

