/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl;

import ca.odell.glazedlists.impl.PLAFDetector;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public final class SortIconFactory {
    private static final String resourceRoot = "resources";
    private static final String defaultResourcePath = "aqua";
    private static final Map<String, String> lookAndFeelResourcePathMap = new HashMap<String, String>();
    private static Icon[] defaultIcons;
    private static String[] iconFileNames;

    private SortIconFactory() {
        throw new UnsupportedOperationException();
    }

    public static Icon[] loadIcons() {
        if (defaultIcons != null) {
            return defaultIcons;
        }
        String string = UIManager.getLookAndFeel().getName();
        if (string.equals("Metal")) {
            string = PLAFDetector.getMetalTheme();
        } else if (string.equals("Windows")) {
            string = PLAFDetector.getWindowsTheme();
        }
        String string2 = lookAndFeelResourcePathMap.get(string);
        if (string2 == null) {
            string2 = defaultResourcePath;
        }
        defaultIcons = SortIconFactory.loadIcons("resources/" + string2);
        return defaultIcons;
    }

    public static Icon[] loadIcons(String string) {
        ClassLoader classLoader = SortIconFactory.class.getClassLoader();
        Icon[] iconArray = new Icon[iconFileNames.length];
        for (int i2 = 1; i2 < iconArray.length; ++i2) {
            URL uRL = classLoader.getResource(string + "/" + iconFileNames[i2]);
            if (uRL == null) continue;
            iconArray[i2] = new ImageIcon(uRL);
        }
        return iconArray;
    }

    static {
        lookAndFeelResourcePathMap.put("Mac OS X Aqua", defaultResourcePath);
        lookAndFeelResourcePathMap.put("Metal/Steel", "metal");
        lookAndFeelResourcePathMap.put("Metal/Ocean", "ocean");
        lookAndFeelResourcePathMap.put("Classic Windows", "windows");
        lookAndFeelResourcePathMap.put("Windows XP", "windowsxp");
        lookAndFeelResourcePathMap.put("Windows Vista", "windowsxp");
        lookAndFeelResourcePathMap.put("WinLAF", "windowsxp");
        defaultIcons = null;
        iconFileNames = new String[]{"unsorted.png", "primary_sorted.png", "primary_sorted_reverse.png", "primary_sorted_alternate.png", "primary_sorted_alternate_reverse.png", "secondary_sorted.png", "secondary_sorted_reverse.png", "secondary_sorted_alternate.png", "secondary_sorted_alternate_reverse.png"};
    }
}

