/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl;

public final class Preconditions {
    private Preconditions() {
    }

    public static void checkArgument(boolean bl) {
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean bl, Object object) {
        if (!bl) {
            throw new IllegalArgumentException(String.valueOf(object));
        }
    }

    public static void checkArgument(boolean bl, String string, Object ... objectArray) {
        if (!bl) {
            throw new IllegalArgumentException(Preconditions.format(string, objectArray));
        }
    }

    public static void checkState(boolean bl) {
        if (!bl) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean bl, Object object) {
        if (!bl) {
            throw new IllegalStateException(String.valueOf(object));
        }
    }

    public static void checkState(boolean bl, String string, Object ... objectArray) {
        if (!bl) {
            throw new IllegalStateException(Preconditions.format(string, objectArray));
        }
    }

    public static <T> T checkNotNull(T t2) {
        if (t2 == null) {
            throw new NullPointerException();
        }
        return t2;
    }

    public static <T> T checkNotNull(T t2, Object object) {
        if (t2 == null) {
            throw new NullPointerException(String.valueOf(object));
        }
        return t2;
    }

    public static <T> T checkNotNull(T t2, String string, Object ... objectArray) {
        if (t2 == null) {
            throw new NullPointerException(Preconditions.format(string, objectArray));
        }
        return t2;
    }

    static String format(String string, Object ... objectArray) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder(string.length() + 16 * objectArray.length);
        int n3 = 0;
        int n4 = 0;
        while (n4 < objectArray.length && (n2 = string.indexOf("%s", n3)) != -1) {
            stringBuilder.append(string.substring(n3, n2));
            stringBuilder.append(objectArray[n4++]);
            n3 = n2 + 2;
        }
        stringBuilder.append(string.substring(n3));
        if (n4 < objectArray.length) {
            stringBuilder.append(" [");
            stringBuilder.append(objectArray[n4++]);
            while (n4 < objectArray.length) {
                stringBuilder.append(", ");
                stringBuilder.append(objectArray[n4++]);
            }
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }
}

