/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl;

import java.awt.Toolkit;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public final class PLAFDetector {
    public static String getMetalTheme() {
        try {
            MetalLookAndFeel metalLookAndFeel = (MetalLookAndFeel)UIManager.getLookAndFeel();
            Method method = metalLookAndFeel.getClass().getMethod("getCurrentTheme", new Class[0]);
            MetalTheme metalTheme = (MetalTheme)method.invoke((Object)metalLookAndFeel, new Object[0]);
            return "Metal/" + metalTheme.getName();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return "Metal/Steel";
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "Metal/Steel";
        }
    }

    public static String getWindowsTheme() {
        String string = "Classic Windows";
        String string2 = "Windows XP";
        String string3 = "Windows Vista";
        String string4 = "win.xpstyle.themeActive";
        Boolean bl = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty(string4);
        if (bl == null) {
            return string;
        }
        if (!bl.booleanValue()) {
            return string;
        }
        String string5 = "swing.noxp";
        try {
            if (System.getProperty(string5) != null) {
                return string;
            }
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        String string6 = "com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel";
        if (UIManager.getLookAndFeel().getClass().getName().equals(string6)) {
            return "Classic Windows";
        }
        try {
            double d2 = Double.parseDouble(System.getProperty("os.version"));
            if (d2 >= 6.0) {
                return string3;
            }
            if (d2 >= 5.1) {
                return string2;
            }
            return string;
        }
        catch (AccessControlException accessControlException) {
            return string2;
        }
        catch (NumberFormatException numberFormatException) {
            return string2;
        }
    }
}

