/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HttpClient {
    public static final int MAX_REDIRECTS = 20;

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 2 || !stringArray[0].startsWith("http")) {
            System.out.println("Usage: HttpClient <url> <filename>");
            System.out.println();
            System.out.println("This program demonstrates how to download from java.net's");
            System.out.println("Documents & Files area using URLConnection");
            return;
        }
        File file = new File(stringArray[1]);
        if (file.exists()) {
            System.out.println("Skipping " + stringArray[0] + ", file already exists");
            return;
        }
        InputStream inputStream = HttpClient.getInputStream(stringArray[0]);
        System.out.println("Downloading " + stringArray[0]);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(stringArray[1]));
        HttpClient.pushStreams(inputStream, bufferedOutputStream);
        ((OutputStream)bufferedOutputStream).close();
    }

    private static void pushStreams(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n2;
        while ((n2 = inputStream.read()) >= 0) {
            outputStream.write(n2);
        }
    }

    private static InputStream getInputStream(String string) throws IOException {
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < 20; ++i2) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
            httpURLConnection.setInstanceFollowRedirects(false);
            HttpClient.writeCookies(arrayList, httpURLConnection);
            httpURLConnection.connect();
            if (httpURLConnection.getResponseCode() != 302 && httpURLConnection.getResponseCode() != 301) {
                return httpURLConnection.getInputStream();
            }
            string = httpURLConnection.getHeaderField("Location");
            HttpClient.acceptCookies(arrayList, httpURLConnection);
        }
        throw new IOException("Max redirects 20 exceeded!");
    }

    private static void acceptCookies(List list, HttpURLConnection httpURLConnection) {
        for (Map.Entry<String, List<String>> entry : httpURLConnection.getHeaderFields().entrySet()) {
            String string = entry.getKey();
            if (!"Set-Cookie".equalsIgnoreCase(string)) continue;
            List<String> list2 = entry.getValue();
            for (String string2 : list2) {
                String string3 = string2.split(";")[0];
                list.add(string3);
            }
        }
    }

    private static void writeCookies(List list, HttpURLConnection httpURLConnection) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("; ");
            }
            stringBuffer.append(iterator.next());
        }
        if (stringBuffer.length() > 0) {
            httpURLConnection.addRequestProperty("Cookie", stringBuffer.toString());
        }
    }
}

