/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.DisposableMap;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FunctionList;
import ca.odell.glazedlists.GroupingList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class GroupingListMultiMap<K, V>
implements DisposableMap<K, List<V>>,
ListEventListener<List<V>> {
    private final GroupingList<V> groupingList;
    private final FunctionList<List<V>, List<V>> valueList;
    private final List<K> keyList;
    private Set<K> keySet;
    private final FunctionList.Function<V, ? extends K> keyFunction;
    private final Map<K, List<V>> delegate;
    private Set<Map.Entry<K, List<V>>> entrySet;

    public GroupingListMultiMap(EventList<V> eventList, FunctionList.Function<V, ? extends K> function, Comparator<? super K> comparator) {
        if (function == null) {
            throw new IllegalArgumentException("keyFunction may not be null");
        }
        if (comparator == null) {
            throw new IllegalArgumentException("keyGrouper may not be null");
        }
        this.keyFunction = function;
        this.groupingList = new GroupingList<V>(eventList, new FunctionComparator(function, comparator));
        this.valueList = new FunctionList(this.groupingList, new ValueListFunction());
        this.valueList.addListEventListener(this);
        this.keyList = new BasicEventList<K>(this.groupingList.size());
        this.delegate = new HashMap<K, List<V>>(this.groupingList.size());
        for (List list : this.valueList) {
            K k2 = this.key((V)list);
            this.keyList.add(k2);
            this.delegate.put(k2, list);
        }
    }

    @Override
    public void dispose() {
        this.valueList.removeListEventListener(this);
        this.valueList.dispose();
        this.groupingList.dispose();
        this.keySet = null;
        this.entrySet = null;
        this.keyList.clear();
        this.delegate.clear();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.delegate.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.delegate.containsValue(object);
    }

    @Override
    public List<V> get(Object object) {
        return this.delegate.get(object);
    }

    @Override
    public List<V> put(K k2, List<V> list) {
        this.checkKeyValueAgreement(k2, (V)list);
        Object object = this.remove(k2);
        this.groupingList.add(list);
        return object;
    }

    @Override
    public void putAll(Map<? extends K, ? extends List<V>> map) {
        for (Map.Entry<K, List<V>> entry : map.entrySet()) {
            K k2 = entry.getKey();
            List<V> list = entry.getValue();
            this.checkKeyValueAgreement(k2, (V)list);
        }
        Iterator<Map.Entry<K, List<V>>> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            this.remove(iterator.next());
        }
        this.groupingList.addAll(map.values());
    }

    private void checkKeyValueAgreement(K k2, Collection<? extends V> collection) {
        Iterator<V> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.checkKeyValueAgreement(k2, iterator.next());
        }
    }

    private void checkKeyValueAgreement(K k2, V v2) {
        K k3 = this.key(v2);
        if (!Objects.equals(k2, k3)) {
            throw new IllegalArgumentException("The calculated key for the given value (" + k3 + ") does not match the given key (" + k2 + ")");
        }
    }

    @Override
    public void clear() {
        this.groupingList.clear();
    }

    @Override
    public List<V> remove(Object object) {
        int n2 = this.keyList.indexOf(object);
        return n2 == -1 ? null : this.groupingList.remove(n2);
    }

    @Override
    public Collection<List<V>> values() {
        return this.groupingList;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<K, List<V>>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public boolean equals(Object object) {
        return this.delegate.equals(object);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public void listChanged(ListEvent<List<V>> listEvent) {
        while (listEvent.next()) {
            List<Object> list;
            int n2 = listEvent.getIndex();
            int n3 = listEvent.getType();
            if (n3 == 2) {
                list = (List)listEvent.getSourceList().get(n2);
                K k2 = this.key((V)list);
                this.keyList.add(n2, k2);
                this.delegate.put(k2, list);
                continue;
            }
            if (n3 != 0) continue;
            list = this.keyList.remove(n2);
            this.delegate.remove(list);
        }
    }

    private K key(List<V> list) {
        return this.key(list.get(0));
    }

    private K key(V v2) {
        return this.keyFunction.evaluate(v2);
    }

    private final class ValueList
    implements List<V> {
        private final List<V> delegate;
        private final K key;

        public ValueList(List<V> list) {
            this.delegate = list;
            this.key = GroupingListMultiMap.this.key(list.get(0));
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.delegate.contains(object);
        }

        @Override
        public Iterator<V> iterator() {
            return this.delegate.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.delegate.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.delegate.toArray(TArray);
        }

        @Override
        public boolean add(V v2) {
            GroupingListMultiMap.this.checkKeyValueAgreement(this.key, v2);
            return this.delegate.add(v2);
        }

        @Override
        public boolean addAll(Collection<? extends V> collection) {
            GroupingListMultiMap.this.checkKeyValueAgreement((Object)this.key, (Object)collection);
            return this.delegate.addAll(collection);
        }

        @Override
        public boolean addAll(int n2, Collection<? extends V> collection) {
            GroupingListMultiMap.this.checkKeyValueAgreement((Object)this.key, (Object)collection);
            return this.delegate.addAll(n2, collection);
        }

        @Override
        public void add(int n2, V v2) {
            GroupingListMultiMap.this.checkKeyValueAgreement(this.key, v2);
            this.delegate.add(n2, v2);
        }

        @Override
        public V set(int n2, V v2) {
            GroupingListMultiMap.this.checkKeyValueAgreement(this.key, v2);
            return this.delegate.set(n2, v2);
        }

        @Override
        public List<V> subList(int n2, int n3) {
            return new ValueList(this.delegate.subList(n2, n3));
        }

        @Override
        public ListIterator<V> listIterator() {
            return new ValueListIterator(this.delegate.listIterator());
        }

        @Override
        public ListIterator<V> listIterator(int n2) {
            return new ValueListIterator(this.delegate.listIterator(n2));
        }

        @Override
        public boolean remove(Object object) {
            return this.delegate.remove(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.delegate.containsAll(collection);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return this.delegate.removeAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return this.delegate.retainAll(collection);
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public boolean equals(Object object) {
            return this.delegate.equals(object);
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }

        @Override
        public V get(int n2) {
            return this.delegate.get(n2);
        }

        @Override
        public V remove(int n2) {
            return this.delegate.remove(n2);
        }

        @Override
        public int indexOf(Object object) {
            return this.delegate.indexOf(object);
        }

        @Override
        public int lastIndexOf(Object object) {
            return this.delegate.lastIndexOf(object);
        }

        public String toString() {
            return this.delegate.toString();
        }

        private final class ValueListIterator
        implements ListIterator<V> {
            private final ListIterator<V> delegate;

            public ValueListIterator(ListIterator<V> listIterator) {
                this.delegate = listIterator;
            }

            @Override
            public void set(V v2) {
                GroupingListMultiMap.this.checkKeyValueAgreement(ValueList.this.key, v2);
                this.delegate.set(v2);
            }

            @Override
            public void add(V v2) {
                GroupingListMultiMap.this.checkKeyValueAgreement(ValueList.this.key, v2);
                this.delegate.add(v2);
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public V next() {
                return this.delegate.next();
            }

            @Override
            public boolean hasPrevious() {
                return this.delegate.hasPrevious();
            }

            @Override
            public V previous() {
                return this.delegate.previous();
            }

            @Override
            public int nextIndex() {
                return this.delegate.nextIndex();
            }

            @Override
            public void remove() {
                this.delegate.remove();
            }

            @Override
            public int previousIndex() {
                return this.delegate.previousIndex();
            }
        }
    }

    private final class ValueListFunction
    implements FunctionList.Function<List<V>, List<V>> {
        private ValueListFunction() {
        }

        @Override
        public List<V> evaluate(List<V> list) {
            return new ValueList(list);
        }
    }

    private final class FunctionComparator
    implements Comparator<V> {
        private final Comparator<? super K> delegate;
        private final FunctionList.Function<V, ? extends K> function;

        FunctionComparator(FunctionList.Function<V, ? extends K> function, Comparator<? super K> comparator) {
            this.function = function;
            this.delegate = comparator;
        }

        @Override
        public int compare(V v2, V v3) {
            Object k2 = this.function.evaluate(v2);
            Object k3 = this.function.evaluate(v3);
            return this.delegate.compare(k2, k3);
        }
    }

    private class KeySetIterator
    implements Iterator<K> {
        private final ListIterator<K> keyIter;

        KeySetIterator(ListIterator<K> listIterator) {
            this.keyIter = listIterator;
        }

        @Override
        public boolean hasNext() {
            return this.keyIter.hasNext();
        }

        @Override
        public K next() {
            return this.keyIter.next();
        }

        @Override
        public void remove() {
            int n2 = this.keyIter.previousIndex();
            if (n2 == -1) {
                throw new IllegalStateException("Cannot remove() without a prior call to next()");
            }
            GroupingListMultiMap.this.groupingList.remove(n2);
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public int size() {
            return GroupingListMultiMap.this.keyList.size();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeySetIterator(GroupingListMultiMap.this.keyList.listIterator());
        }

        @Override
        public boolean contains(Object object) {
            return GroupingListMultiMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return GroupingListMultiMap.this.remove(object) != null;
        }

        @Override
        public void clear() {
            GroupingListMultiMap.this.clear();
        }
    }

    private class MultiMapEntry
    implements Map.Entry<K, List<V>> {
        private final K key;
        private List<V> value;

        MultiMapEntry(K k2, List<V> list) {
            if (list == null) {
                throw new IllegalArgumentException("value cannot be null");
            }
            this.value = list;
            this.key = k2;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public List<V> getValue() {
            return this.value;
        }

        @Override
        public List<V> setValue(List<V> list) {
            GroupingListMultiMap.this.checkKeyValueAgreement((Object)this.getKey(), (Object)list);
            ArrayList arrayList = new ArrayList(this.value);
            this.value.addAll(list);
            this.value.removeAll(arrayList);
            return arrayList;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            boolean bl = Objects.equals(this.getKey(), entry.getKey());
            return bl && Objects.equals(this.getValue(), entry.getValue());
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ this.value.hashCode();
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    private class EntrySetIterator
    implements Iterator<Map.Entry<K, List<V>>> {
        private final ListIterator<K> keyIter;

        EntrySetIterator(ListIterator<K> listIterator) {
            this.keyIter = listIterator;
        }

        @Override
        public boolean hasNext() {
            return this.keyIter.hasNext();
        }

        @Override
        public Map.Entry<K, List<V>> next() {
            Object k2 = this.keyIter.next();
            return new MultiMapEntry(k2, GroupingListMultiMap.this.get(k2));
        }

        @Override
        public void remove() {
            int n2 = this.keyIter.previousIndex();
            if (n2 == -1) {
                throw new IllegalStateException("Cannot remove() without a prior call to next()");
            }
            GroupingListMultiMap.this.groupingList.remove(n2);
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, List<V>>> {
        private EntrySet() {
        }

        @Override
        public int size() {
            return GroupingListMultiMap.this.keyList.size();
        }

        @Override
        public Iterator<Map.Entry<K, List<V>>> iterator() {
            return new EntrySetIterator(GroupingListMultiMap.this.keyList.listIterator());
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k2 = entry.getKey();
            List list = (List)entry.getValue();
            Object object2 = GroupingListMultiMap.this.get(k2);
            return Objects.equals(list, object2);
        }

        @Override
        public boolean remove(Object object) {
            if (!this.contains(object)) {
                return false;
            }
            GroupingListMultiMap.this.remove(((Map.Entry)object).getKey());
            return true;
        }

        @Override
        public void clear() {
            GroupingListMultiMap.this.clear();
        }
    }
}

