/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl;

import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.impl.adt.Barcode;
import java.util.Comparator;
import java.util.LinkedList;

public class Grouper<E> {
    public static final Object UNIQUE = Barcode.BLACK;
    public static final Object DUPLICATE = Barcode.WHITE;
    private static final Object UNIQUE_WITH_DUPLICATE = null;
    private static final Object TODO = Barcode.BLACK;
    private static final Object DONE = Barcode.WHITE;
    private static final int LEFT_GROUP = -1;
    private static final int NO_GROUP = 0;
    private static final int RIGHT_GROUP = 1;
    private SortedList<E> sortedList;
    private Comparator<? super E> comparator;
    private Client<E> client;
    private Barcode barcode;

    public Grouper(SortedList<E> sortedList, Client client) {
        this.sortedList = sortedList;
        this.client = client;
        this.setComparator(sortedList.getComparator());
    }

    public void setComparator(Comparator<? super E> comparator) {
        if (this.comparator == comparator) {
            return;
        }
        this.comparator = comparator;
        this.barcode = new Barcode();
        int n2 = this.sortedList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.barcode.add(i2, this.groupTogether(i2, i2 - 1) ? DUPLICATE : UNIQUE, 1);
        }
    }

    public Comparator<? super E> getComparator() {
        return this.comparator;
    }

    public Client getClient() {
        return this.client;
    }

    public Barcode getBarcode() {
        return this.barcode;
    }

    public void listChanged(ListEvent<E> listEvent) {
        int n2;
        Barcode barcode = new Barcode();
        barcode.addWhite(0, this.barcode.size());
        LinkedList<Object> linkedList = new LinkedList<Object>();
        int n3 = -1;
        while (listEvent.next()) {
            int n4 = listEvent.getIndex();
            n2 = listEvent.getType();
            if (n2 == 2) {
                this.barcode.add(n4, UNIQUE, 1);
                barcode.add(n4, TODO, 1);
                continue;
            }
            if (n2 == 1) {
                if (this.barcode.get(n4) != UNIQUE || n4 + 1 >= this.barcode.size() || this.barcode.get(n4 + 1) != DUPLICATE || n4 != 0 && this.uniqueElementAddedToLeftInSameGroup(barcode, n4) || n4 == n3) continue;
                this.barcode.set(n4, UNIQUE, 2);
                barcode.set(n4, TODO, 1);
                n3 = n4 + 1;
                continue;
            }
            if (n2 != 0) continue;
            Object object = this.barcode.get(n4);
            this.barcode.remove(n4, 1);
            barcode.remove(n4, 1);
            if (object == UNIQUE && n4 < this.barcode.size() && this.barcode.get(n4) == DUPLICATE) {
                this.barcode.set(n4, UNIQUE, 1);
                object = UNIQUE_WITH_DUPLICATE;
            }
            linkedList.addLast(object);
        }
        TryJoinResult tryJoinResult = new TryJoinResult();
        listEvent.reset();
        while (listEvent.next()) {
            Object e2;
            E e3;
            int n5;
            int n6;
            n2 = listEvent.getIndex();
            int n7 = listEvent.getType();
            E e4 = listEvent.getNewValue();
            E e5 = listEvent.getOldValue();
            if (n7 == 2) {
                this.tryJoinExistingGroup(n2, barcode, tryJoinResult);
                if (tryJoinResult.group == 0) {
                    this.client.groupChanged(n2, tryJoinResult.groupIndex, 2, true, n7, ListEvent.unknownValue(), tryJoinResult.newFirstInGroup, false, false);
                    continue;
                }
                this.client.groupChanged(n2, tryJoinResult.groupIndex, 1, true, n7, tryJoinResult.oldFirstInGroup, tryJoinResult.newFirstInGroup, false, false);
                continue;
            }
            if (n7 == 1) {
                int n8 = 0;
                if (barcode.get(n2) == TODO) {
                    n8 = n2 + 1 < this.barcode.size() ? 1 : 0;
                } else if (this.barcode.get(n2) == DUPLICATE) {
                    n8 = -1;
                } else if (this.barcode.get(n2) == UNIQUE) {
                    n8 = 0;
                }
                this.tryJoinExistingGroup(n2, barcode, tryJoinResult);
                n6 = n2 + 1;
                if (tryJoinResult.group == -1) {
                    if (n6 < this.barcode.size() && this.barcode.get(n6) == UNIQUE && barcode.get(n6) == DONE && this.groupTogether(n2, n6)) {
                        this.barcode.set(n6, DUPLICATE, 1);
                        n8 = 0;
                    }
                } else if (tryJoinResult.group == 0 && n6 < this.barcode.size() && this.barcode.get(n6) == DUPLICATE && !this.groupTogether(n2, n6)) {
                    this.barcode.set(n6, UNIQUE, 1);
                    n8 = 1;
                }
                n5 = tryJoinResult.groupIndex;
                if (tryJoinResult.group == 0) {
                    if (n8 == 0) {
                        this.client.groupChanged(n2, n5, 1, true, n7, e5, tryJoinResult.newFirstInGroup, false, false);
                        continue;
                    }
                    if (n8 == -1) {
                        e3 = this.sortedList.get(this.barcode.getIndex(n5 - 1, UNIQUE));
                        this.client.groupChanged(n2, n5 - 1, 1, false, n7, e3, e3, false, false);
                        this.client.groupChanged(n2, n5, 2, true, n7, ListEvent.unknownValue(), tryJoinResult.newFirstInGroup, false, false);
                        continue;
                    }
                    if (n8 != 1) continue;
                    e3 = this.sortedList.get(this.barcode.getIndex(n5 + 1, UNIQUE));
                    this.client.groupChanged(n2, n5, 2, true, n7, ListEvent.unknownValue(), tryJoinResult.newFirstInGroup, false, false);
                    this.client.groupChanged(n2, n5 + 1, 1, false, n7, e5, e3, false, false);
                    continue;
                }
                if (tryJoinResult.group == -1) {
                    if (n8 == 0) {
                        this.client.groupChanged(n2, n5, 1, true, n7, tryJoinResult.oldFirstInGroup, tryJoinResult.newFirstInGroup, false, false);
                        this.client.groupChanged(n2, n5 + 1, 0, false, n7, e5, ListEvent.unknownValue(), false, false);
                        continue;
                    }
                    if (n8 == -1) {
                        this.client.groupChanged(n2, n5, 1, true, n7, tryJoinResult.oldFirstInGroup, tryJoinResult.newFirstInGroup, false, false);
                        continue;
                    }
                    if (n8 != 1) continue;
                    this.client.groupChanged(n2, n5, 1, true, n7, tryJoinResult.oldFirstInGroup, tryJoinResult.newFirstInGroup, true, false);
                    if (n5 + 1 >= this.barcode.blackSize()) continue;
                    e3 = this.sortedList.get(this.barcode.getIndex(n5 + 1, UNIQUE));
                    this.client.groupChanged(n2, n5 + 1, 1, false, n7, e5, e3, false, false);
                    continue;
                }
                if (tryJoinResult.group != 1) continue;
                if (n8 == 0) {
                    this.client.groupChanged(n2, n5, 0, false, n7, e5, ListEvent.unknownValue(), false, true);
                    this.client.groupChanged(n2, n5, 1, true, n7, tryJoinResult.oldFirstInGroup, tryJoinResult.newFirstInGroup, false, true);
                    continue;
                }
                if (n8 == -1) {
                    if (n5 - 1 >= 0) {
                        e3 = this.sortedList.get(this.barcode.getIndex(n5 - 1, UNIQUE));
                        this.client.groupChanged(n2, n5 - 1, 1, false, n7, e3, e3, true, true);
                    }
                    this.client.groupChanged(n2, n5, 1, true, n7, tryJoinResult.oldFirstInGroup, tryJoinResult.newFirstInGroup, false, true);
                    continue;
                }
                if (n8 != 1) continue;
                this.client.groupChanged(n2, n5, 1, true, n7, tryJoinResult.oldFirstInGroup, tryJoinResult.newFirstInGroup, false, true);
                continue;
            }
            if (n7 != 0) continue;
            Object e6 = linkedList.removeFirst();
            n6 = e6 == DUPLICATE ? n2 - 1 : n2;
            int n9 = n5 = n6 < this.barcode.size() ? this.barcode.getBlackIndex(n6, true) : this.barcode.blackSize();
            if (e6 == UNIQUE) {
                if (n2 >= this.barcode.size() && n2 == n3) {
                    this.client.groupChanged(n2, n5 - 1, 1, true, n7, e5, ListEvent.unknownValue(), false, true);
                    n3 = -1;
                    continue;
                }
                this.client.groupChanged(n2, n5, 0, true, n7, e5, ListEvent.unknownValue(), false, true);
                continue;
            }
            if (n5 < this.barcode.blackSize()) {
                int n10 = this.barcode.getIndex(n5, UNIQUE);
                e2 = this.sortedList.get(n10);
            } else {
                e2 = ListEvent.unknownValue();
            }
            e3 = e6 == UNIQUE_WITH_DUPLICATE ? e5 : e2;
            this.client.groupChanged(n2, n5, 1, true, n7, e3, e2, false, true);
        }
    }

    private boolean uniqueElementAddedToLeftInSameGroup(Barcode barcode, int n2) {
        return this.barcode.get(n2 - 1) == UNIQUE && barcode.get(n2 - 1) == TODO && this.groupTogether(n2 - 1, n2);
    }

    private boolean groupTogether(int n2, int n3) {
        if (n2 < 0 || n2 >= this.sortedList.size()) {
            return false;
        }
        if (n3 < 0 || n3 >= this.sortedList.size()) {
            return false;
        }
        return this.comparator.compare(this.sortedList.get(n2), this.sortedList.get(n3)) == 0;
    }

    private TryJoinResult tryJoinExistingGroup(int n2, Barcode barcode, TryJoinResult<E> tryJoinResult) {
        int n3 = n2 - 1;
        if (this.groupTogether(n3, n2)) {
            this.barcode.set(n2, DUPLICATE, 1);
            int n4 = this.barcode.getColourIndex(n2, true, UNIQUE);
            int n5 = this.barcode.getIndex(n4, UNIQUE);
            Object e2 = this.sortedList.get(n5);
            return tryJoinResult.set(-1, n4, e2, e2);
        }
        int n6 = n2 + 1;
        while (this.groupTogether(n2, n6)) {
            if (barcode.get(n6) == DONE && this.barcode.get(n6) == UNIQUE) {
                this.barcode.set(n2, UNIQUE, 1);
                this.barcode.set(n6, DUPLICATE, 1);
                int n7 = this.barcode.getColourIndex(n2, UNIQUE);
                Object e3 = this.sortedList.get(n6);
                Object e4 = this.sortedList.get(n2);
                return tryJoinResult.set(1, n7, e3, e4);
            }
            ++n6;
        }
        this.barcode.set(n2, UNIQUE, 1);
        int n8 = this.barcode.getColourIndex(n2, UNIQUE);
        Object e5 = this.sortedList.get(n2);
        return tryJoinResult.set(0, n8, ListEvent.unknownValue(), e5);
    }

    @FunctionalInterface
    public static interface Client<E> {
        public void groupChanged(int var1, int var2, int var3, boolean var4, int var5, E var6, E var7, boolean var8, boolean var9);
    }

    private static class TryJoinResult<E> {
        int group;
        int groupIndex;
        E oldFirstInGroup;
        E newFirstInGroup;

        private TryJoinResult() {
        }

        public TryJoinResult set(int n2, int n3, E e2, E e3) {
            this.group = n2;
            this.groupIndex = n3;
            this.oldFirstInGroup = e2;
            this.newFirstInGroup = e3;
            return this;
        }
    }
}

