/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FunctionList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.impl.adt.KeyedCollection;
import ca.odell.glazedlists.impl.text.LatinDiacriticsStripper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;

public final class GlazedListsImpl {
    private GlazedListsImpl() {
        throw new UnsupportedOperationException();
    }

    public static <E> List<E> concatenate(List<E> list, List<E> list2) {
        ArrayList<E> arrayList = new ArrayList<E>(list.size() + list2.size());
        arrayList.addAll(list);
        arrayList.addAll(list2);
        return arrayList;
    }

    public static <E> void replaceAll(EventList<E> eventList, Collection<E> collection, boolean bl, Comparator<E> comparator) {
        Class<Void> clazz;
        if (comparator == null) {
            comparator = GlazedLists.comparableComparator();
        }
        int n2 = -1;
        Iterator<E> iterator = collection.iterator();
        Class clazz2 = clazz = Void.class;
        Class clazz3 = clazz;
        while (true) {
            if (clazz2 == clazz) {
                if (n2 < eventList.size()) {
                    ++n2;
                }
                if (n2 < eventList.size()) {
                    clazz2 = eventList.get(n2);
                }
            }
            if (clazz3 == clazz && iterator.hasNext()) {
                clazz3 = iterator.next();
            }
            if (clazz2 == clazz && clazz3 == clazz) break;
            int n3 = clazz2 == clazz ? 1 : (clazz3 == clazz ? -1 : comparator.compare(clazz2, clazz3));
            if (n3 < 0) {
                eventList.remove(n2);
                --n2;
                clazz2 = clazz;
                continue;
            }
            if (n3 == 0) {
                if (bl) {
                    eventList.set(n2, clazz3);
                }
                clazz2 = clazz;
                clazz3 = clazz;
                continue;
            }
            if (n3 <= 0) continue;
            eventList.add(n2, clazz3);
            ++n2;
            clazz3 = clazz;
        }
    }

    public static char[] getLatinDiacriticsStripper() {
        return LatinDiacriticsStripper.getMapper();
    }

    public static Date getMonthBegin(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return GlazedListsImpl.getMonthStart(calendar);
    }

    public static Date getMonthStart(Calendar calendar) {
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static boolean isMonthStart(Calendar calendar) {
        return calendar.get(14) == 0 && calendar.get(13) == 0 && calendar.get(12) == 0 && calendar.get(11) == 0 && calendar.get(5) == 1;
    }

    public static <T> Comparator<T> equalsComparator() {
        return new EqualsComparator();
    }

    public static <E> FunctionList.Function<E, E> identityFunction() {
        return new IdentityFunction();
    }

    public static <P, V> KeyedCollection<P, V> keyedCollection(Comparator<P> comparator, Comparator<V> comparator2) {
        return new KeyedCollection<P, V>(comparator, new TreeMap(comparator2));
    }

    public static <P, V> KeyedCollection<P, V> keyedCollection(Comparator<P> comparator) {
        return new KeyedCollection(comparator, new HashMap());
    }

    private static class IdentityFunction<E>
    implements FunctionList.Function<E, E> {
        private IdentityFunction() {
        }

        @Override
        public E evaluate(E e2) {
            return e2;
        }
    }

    private static class EqualsComparator<T>
    implements Comparator<T> {
        private EqualsComparator() {
        }

        @Override
        public int compare(T t2, T t3) {
            return Objects.equals(t2, t3) ? 0 : 1;
        }
    }
}

