/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.DisposableMap;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FunctionList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;

public class FunctionListMap<K, V>
implements DisposableMap<K, V> {
    private List<K> keyList;
    private KeySet keySet;
    private final EventList<V> valueList;
    private Set<Map.Entry<K, V>> entrySet;
    private final FunctionList.Function<V, K> keyFunction;
    private final Map<K, V> delegate;
    private ListEventListener<V> eventListener;

    public FunctionListMap(EventList<V> eventList, FunctionList.Function<V, K> function) {
        if (function == null) {
            throw new IllegalArgumentException("keyFunction may not be null");
        }
        this.valueList = eventList;
        this.eventListener = this::processListChanges;
        this.valueList.addListEventListener(this.eventListener);
        this.keyFunction = function;
        this.keyList = new BasicEventList<K>(eventList.size());
        this.delegate = new HashMap(eventList.size());
        int n2 = eventList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.elementAdded(i2);
        }
    }

    @Override
    public void dispose() {
        this.valueList.removeListEventListener(this.eventListener);
        this.keySet = null;
        this.entrySet = null;
        this.keyList.clear();
        this.delegate.clear();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.delegate.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.delegate.containsValue(object);
    }

    @Override
    public V get(Object object) {
        return this.delegate.get(object);
    }

    @Override
    public V put(K k2, V v2) {
        this.checkKeyValueAgreement(k2, v2);
        return this.putNoAgreementCheck(k2, v2);
    }

    private V putNoAgreementCheck(K k2, V v2) {
        if (!this.containsKey(k2)) {
            this.valueList.add(v2);
            return null;
        }
        V v3 = this.get(k2);
        if (!this.replaceValue(v3, v2)) {
            throw new IllegalStateException("Found key: " + k2 + " in delegate map but could not find corresponding value in valueList: " + v3);
        }
        return v3;
    }

    private boolean replaceValue(V v2, V v3) {
        if (this.valueList instanceof RandomAccess) {
            for (int i2 = this.valueList.size() - 1; i2 >= 0; --i2) {
                Object e2 = this.valueList.get(i2);
                if (e2 != v2) continue;
                this.valueList.set(i2, v3);
                return true;
            }
            return false;
        }
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        this.valueList.replaceAll(object3 -> {
            if (atomicBoolean.get()) {
                return object3;
            }
            if (object3 == v2) {
                atomicBoolean.set(true);
                return v3;
            }
            return object3;
        });
        return atomicBoolean.get();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        map.forEach(this::checkKeyValueAgreement);
        map.forEach(this::putNoAgreementCheck);
    }

    private void checkKeyValueAgreement(K k2, V v2) {
        K k3 = this.key(v2);
        if (!Objects.equals(k2, k3)) {
            throw new IllegalArgumentException("The calculated key for the given value (" + k3 + ") does not match the given key (" + k2 + ")");
        }
    }

    @Override
    public void clear() {
        this.valueList.clear();
    }

    @Override
    public V remove(Object object) {
        if (!this.containsKey(object)) {
            return null;
        }
        Object v2 = this.get(object);
        this.valueList.removeIf(object2 -> object2 == v2);
        return v2;
    }

    @Override
    public Collection<V> values() {
        return this.valueList;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        this.delegate.forEach(biConsumer);
    }

    @Override
    public boolean equals(Object object) {
        return this.delegate.equals(object);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    private void processListChanges(ListEvent<V> listEvent) {
        int n2 = 0;
        while (listEvent.next()) {
            switch (listEvent.getType()) {
                case 0: {
                    this.elementRemoved(listEvent.getIndex() + n2);
                    break;
                }
                case 1: {
                    this.elementRemoved(listEvent.getIndex() + n2);
                    --n2;
                    break;
                }
                case 2: {
                    --n2;
                }
            }
        }
        listEvent.reset();
        while (listEvent.next()) {
            switch (listEvent.getType()) {
                case 1: {
                    this.elementAdded(listEvent.getIndex());
                    break;
                }
                case 2: {
                    this.elementAdded(listEvent.getIndex());
                }
            }
        }
    }

    private void elementAdded(int n2) {
        Object e2 = this.valueList.get(n2);
        K k2 = this.key(e2);
        this.keyList.add(n2, k2);
        this.putInDelegate(k2, e2);
    }

    private void elementRemoved(int n2) {
        K k2 = this.keyList.remove(n2);
        this.delegate.remove(k2);
    }

    private void putInDelegate(K k2, V v2) {
        if (this.delegate.containsKey(k2)) {
            throw new IllegalStateException("Detected duplicate key->value mapping: attempted to put '" + k2 + "' -> '" + v2 + "' in the map, but found '" + k2 + "' -> '" + this.delegate.get(k2) + "' already existed.");
        }
        this.delegate.put(k2, v2);
    }

    private K key(V v2) {
        return this.keyFunction.evaluate(v2);
    }

    private class KeySetIterator
    implements Iterator<K> {
        private final ListIterator<K> keyIter;

        KeySetIterator(ListIterator<K> listIterator) {
            this.keyIter = listIterator;
        }

        @Override
        public boolean hasNext() {
            return this.keyIter.hasNext();
        }

        @Override
        public K next() {
            return this.keyIter.next();
        }

        @Override
        public void remove() {
            int n2 = this.keyIter.previousIndex();
            if (n2 == -1) {
                throw new IllegalStateException("Cannot remove() without a prior call to next()");
            }
            FunctionListMap.this.valueList.remove(n2);
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public int size() {
            return FunctionListMap.this.keyList.size();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeySetIterator(FunctionListMap.this.keyList.listIterator());
        }

        @Override
        public boolean contains(Object object) {
            return FunctionListMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return FunctionListMap.this.remove(object) != null;
        }

        @Override
        public void clear() {
            FunctionListMap.this.clear();
        }
    }

    private class MapEntry
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        MapEntry(K k2, V v2) {
            if (v2 == null) {
                throw new IllegalArgumentException("value cannot be null");
            }
            this.value = v2;
            this.key = k2;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v2) {
            FunctionListMap.this.checkKeyValueAgreement(this.key, v2);
            this.value = v2;
            return FunctionListMap.this.put(this.key, v2);
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            boolean bl = Objects.equals(this.getKey(), entry.getKey());
            return bl && Objects.equals(this.getValue(), entry.getValue());
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ this.value.hashCode();
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    private class EntrySetIterator
    implements Iterator<Map.Entry<K, V>> {
        private final ListIterator<K> keyIter;

        EntrySetIterator(ListIterator<K> listIterator) {
            this.keyIter = listIterator;
        }

        @Override
        public boolean hasNext() {
            return this.keyIter.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            Object k2 = this.keyIter.next();
            return new MapEntry(k2, FunctionListMap.this.get(k2));
        }

        @Override
        public void remove() {
            int n2 = this.keyIter.previousIndex();
            if (n2 == -1) {
                throw new IllegalStateException("Cannot remove() without a prior call to next()");
            }
            FunctionListMap.this.valueList.remove(n2);
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public int size() {
            return FunctionListMap.this.keyList.size();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntrySetIterator(FunctionListMap.this.keyList.listIterator());
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k2 = entry.getKey();
            Object v2 = entry.getValue();
            Object v3 = FunctionListMap.this.get(k2);
            return Objects.equals(v2, v3);
        }

        @Override
        public boolean remove(Object object) {
            if (!this.contains(object)) {
                return false;
            }
            FunctionListMap.this.remove(((Map.Entry)object).getKey());
            return true;
        }

        @Override
        public void clear() {
            FunctionListMap.this.clear();
        }
    }
}

