/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.impl.WeakReferenceProxy;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class EventListIterator<E>
implements ListIterator<E>,
ListEventListener<E> {
    private EventList<E> source;
    private int nextIndex;
    private int lastIndex = -1;

    public EventListIterator(EventList<E> eventList) {
        this(eventList, 0, true);
    }

    public EventListIterator(EventList<E> eventList, int n2) {
        this(eventList, n2, true);
    }

    public EventListIterator(EventList<E> eventList, int n2, boolean bl) {
        this.source = eventList;
        this.nextIndex = n2;
        if (bl) {
            WeakReferenceProxy<E> weakReferenceProxy = new WeakReferenceProxy<E>(eventList, this);
            eventList.addListEventListener(weakReferenceProxy);
            eventList.getPublisher().removeDependency(eventList, weakReferenceProxy);
        } else {
            eventList.addListEventListener(this);
            eventList.getPublisher().removeDependency(eventList, this);
        }
    }

    @Override
    public boolean hasNext() {
        return this.nextIndex < this.source.size();
    }

    @Override
    public E next() {
        if (this.nextIndex == this.source.size()) {
            throw new NoSuchElementException("Cannot retrieve element " + this.nextIndex + " on a list of size " + this.source.size());
        }
        this.lastIndex = this.nextIndex++;
        return this.source.get(this.lastIndex);
    }

    @Override
    public int nextIndex() {
        return this.nextIndex;
    }

    @Override
    public boolean hasPrevious() {
        return this.nextIndex > 0;
    }

    @Override
    public E previous() {
        if (this.nextIndex == 0) {
            throw new NoSuchElementException("Cannot retrieve element " + this.nextIndex + " on a list of size " + this.source.size());
        }
        --this.nextIndex;
        this.lastIndex = this.nextIndex;
        return this.source.get(this.nextIndex);
    }

    @Override
    public int previousIndex() {
        return this.nextIndex - 1;
    }

    @Override
    public void add(E e2) {
        this.source.add(this.nextIndex, e2);
    }

    @Override
    public void remove() {
        if (this.lastIndex == -1) {
            throw new IllegalStateException("Cannot remove() without a prior call to next() or previous()");
        }
        this.source.remove(this.lastIndex);
    }

    @Override
    public void set(E e2) {
        if (this.lastIndex == -1) {
            throw new IllegalStateException("Cannot set() without a prior call to next() or previous()");
        }
        this.source.set(this.lastIndex, e2);
    }

    @Override
    public void listChanged(ListEvent<E> listEvent) {
        while (listEvent.next()) {
            int n2 = listEvent.getIndex();
            int n3 = listEvent.getType();
            if (n3 == 2) {
                if (n2 <= this.nextIndex) {
                    ++this.nextIndex;
                }
                if (this.lastIndex == -1 || n2 > this.lastIndex) continue;
                ++this.lastIndex;
                continue;
            }
            if (n3 != 0) continue;
            if (n2 < this.nextIndex) {
                --this.nextIndex;
            }
            if (this.lastIndex != -1 && n2 < this.lastIndex) {
                --this.lastIndex;
                continue;
            }
            if (this.lastIndex == -1 || n2 != this.lastIndex) continue;
            this.lastIndex = -1;
        }
    }
}

