/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.impl.GlazedListsImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public final class Diff {
    public static <E> void replaceAll(EventList<E> eventList, List<E> list, boolean bl) {
        Diff.replaceAll(eventList, list, bl, GlazedListsImpl.equalsComparator());
    }

    public static <E> void replaceAll(EventList<E> eventList, List<E> list, boolean bl, Comparator<E> comparator) {
        ListDiffMatcher<E> listDiffMatcher = new ListDiffMatcher<E>(eventList, list, comparator);
        List<Point> list2 = Diff.shortestEditScript(listDiffMatcher);
        int n2 = 0;
        int n3 = 0;
        Point point = null;
        for (Point point2 : list2) {
            int n4;
            if (point == null) {
                point = point2;
                continue;
            }
            int n5 = point2.getX() - point.getX();
            if (n5 == (n4 = point2.getY() - point.getY())) {
                if (bl) {
                    for (int i2 = 0; i2 < n5; ++i2) {
                        eventList.set(n2 + i2, list.get(n3 + i2));
                    }
                }
                n2 += n5;
                n3 += n4;
            } else if (n5 == 1 && n4 == 0) {
                eventList.remove(n2);
            } else if (n5 == 0 && n4 == 1) {
                eventList.add(n2, list.get(n3));
                ++n3;
                ++n2;
            } else {
                throw new IllegalStateException();
            }
            point = point2;
        }
    }

    private static List<Point> shortestEditScript(DiffMatcher diffMatcher) {
        int n2 = diffMatcher.getAlphaLength();
        int n3 = diffMatcher.getBetaLength();
        Point point = new Point(n2, n3);
        int n4 = n2 + n3;
        HashMap<Integer, Point> hashMap = new HashMap<Integer, Point>();
        for (int i2 = 0; i2 <= n4; ++i2) {
            for (int i3 = -i2; i3 <= i2; i3 += 2) {
                Point point2 = (Point)hashMap.get(new Integer(i3 - 1));
                Point point3 = (Point)hashMap.get(new Integer(i3 + 1));
                Point point4 = hashMap.isEmpty() ? new Point(0, 0) : (i3 == -i2 || i3 != i2 && point2.getX() < point3.getX() ? point3.createDeltaPoint(0, 1) : point2.createDeltaPoint(1, 0));
                while (point4.isLessThan(point) && diffMatcher.matchPair(point4.getX(), point4.getY())) {
                    point4 = point4.incrementDiagonally();
                }
                hashMap.put(new Integer(i3), point4);
                if (!point4.isEqualToOrGreaterThan(point)) continue;
                return point4.trail();
            }
        }
        throw new IllegalStateException();
    }

    static class ListDiffMatcher<E>
    implements DiffMatcher {
        private List<E> alpha;
        private List<E> beta;
        private Comparator<E> comparator;

        public ListDiffMatcher(List<E> list, List<E> list2, Comparator<E> comparator) {
            this.alpha = list;
            this.beta = list2;
            this.comparator = comparator;
        }

        @Override
        public int getAlphaLength() {
            return this.alpha.size();
        }

        @Override
        public char alphaAt(int n2) {
            return this.alpha.get(n2).toString().charAt(0);
        }

        @Override
        public char betaAt(int n2) {
            return this.beta.get(n2).toString().charAt(0);
        }

        @Override
        public int getBetaLength() {
            return this.beta.size();
        }

        @Override
        public boolean matchPair(int n2, int n3) {
            return this.comparator.compare(this.alpha.get(n2), this.beta.get(n3)) == 0;
        }
    }

    static interface DiffMatcher {
        public int getAlphaLength();

        public int getBetaLength();

        public boolean matchPair(int var1, int var2);

        public char alphaAt(int var1);

        public char betaAt(int var1);
    }

    private static class Point {
        private int x = 0;
        private int y = 0;
        private Point predecessor = null;

        public Point(int n2, int n3) {
            this.x = n2;
            this.y = n3;
        }

        public Point createDeltaPoint(int n2, int n3) {
            Point point = new Point(this.x + n2, this.y + n3);
            point.predecessor = this;
            return point;
        }

        public Point incrementDiagonally() {
            int n2;
            int n3;
            Point point = this.createDeltaPoint(1, 1);
            if (this.predecessor != null && (n3 = point.x - this.predecessor.x) == (n2 = point.y - this.predecessor.y)) {
                point.predecessor = this.predecessor;
            }
            return point;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public boolean isLessThan(Point point) {
            return this.x < point.x && this.y < point.y;
        }

        public boolean isEqualToOrGreaterThan(Point point) {
            return this.x >= point.x && this.y >= point.y;
        }

        public String toString() {
            return "(" + this.x + "," + this.y + ")";
        }

        public List<Point> trail() {
            ArrayList<Point> arrayList = new ArrayList<Point>();
            Point point = this;
            while (point != null) {
                arrayList.add(point);
                point = point.predecessor;
            }
            Collections.reverse(arrayList);
            return arrayList;
        }
    }
}

