/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.gui;

import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.impl.gui.MouseKeyboardSortingStrategy;
import ca.odell.glazedlists.impl.gui.MouseOnlySortingStrategy;
import ca.odell.glazedlists.impl.gui.MouseOnlySortingStrategyWithUndo;
import ca.odell.glazedlists.impl.gui.SortingState;
import ca.odell.glazedlists.impl.sort.TableColumnComparator;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import java.util.List;

public abstract class AbstractTableComparatorChooser<E> {
    public static final Object SINGLE_COLUMN = new MouseOnlySortingStrategy(false);
    public static final Object MULTIPLE_COLUMN_MOUSE = new MouseOnlySortingStrategy(true);
    public static final Object MULTIPLE_COLUMN_MOUSE_WITH_UNDO = new MouseOnlySortingStrategyWithUndo();
    public static final Object MULTIPLE_COLUMN_KEYBOARD = new MouseKeyboardSortingStrategy();
    protected SortedList<E> sortedList;
    private TableFormat<? super E> tableFormat;
    protected Comparator<? super E> sortedListComparator = null;
    protected SortingState sortingState;

    protected AbstractTableComparatorChooser(SortedList<E> sortedList, TableFormat<? super E> tableFormat) {
        this.sortedList = sortedList;
        this.sortingState = this.createSortingState();
        this.setTableFormat(tableFormat);
        this.sortingState.addPropertyChangeListener(new SortingStateListener());
    }

    protected SortingState createSortingState() {
        return new SortingState(this);
    }

    protected void rebuildComparator() {
        Comparator comparator = this.sortingState.buildComparator();
        this.sortedList.getReadWriteLock().writeLock().lock();
        try {
            this.sortedListComparator = comparator;
            this.sortedList.setComparator(comparator);
        }
        finally {
            this.sortedList.getReadWriteLock().writeLock().unlock();
        }
    }

    protected void setTableFormat(TableFormat<? super E> tableFormat) {
        this.tableFormat = tableFormat;
        this.sortingState.rebuildColumns(tableFormat);
    }

    public List<Comparator> getComparatorsForColumn(int n2) {
        return this.sortingState.getColumns().get(n2).getComparators();
    }

    public List<Integer> getSortingColumns() {
        return this.sortingState.getSortingColumnIndexes();
    }

    public int getColumnComparatorIndex(int n2) {
        return this.sortingState.getColumns().get(n2).getComparatorIndex();
    }

    public boolean isColumnReverse(int n2) {
        return this.sortingState.getColumns().get(n2).isReverse();
    }

    public void appendComparator(int n2, int n3, boolean bl) {
        this.sortingState.appendComparator(n2, n3, bl);
        this.sortingState.fireSortingChanged();
    }

    public void clearComparator() {
        this.sortingState.clearComparators();
        this.sortingState.fireSortingChanged();
    }

    protected void redetectComparator(Comparator<? super E> comparator) {
        this.sortedListComparator = comparator;
        this.sortingState.detectStateFromComparator(comparator);
    }

    protected int getSortingStyle(int n2) {
        return this.sortingState.getColumns().get(n2).getSortingStyle();
    }

    public Comparator createComparatorForElement(Comparator<E> comparator, int n2) {
        return new TableColumnComparator<E>(this.tableFormat, n2, comparator);
    }

    public String toString() {
        return this.sortingState.toString();
    }

    public void fromString(String string) {
        this.sortingState.fromString(string);
        this.sortingState.fireSortingChanged();
    }

    public void dispose() {
        this.sortedList = null;
        this.tableFormat = null;
        this.sortedListComparator = null;
    }

    private class SortingStateListener
    implements PropertyChangeListener {
        private SortingStateListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AbstractTableComparatorChooser.this.rebuildComparator();
        }
    }
}

