/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.event;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.event.ListEventPublisher;
import ca.odell.glazedlists.impl.adt.IdentityMultimap;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

final class SequenceDependenciesEventPublisher
implements ListEventPublisher,
Serializable {
    private static final boolean DO_NONEXISTENT_LISTENER_CHECK;
    private static final long serialVersionUID = -8228256898169043019L;
    private transient int reentrantFireEventCount;
    private final transient Map<Object, EventFormat> subjectsToCleanUp = new IdentityHashMap<Object, EventFormat>();
    private final transient Map<Object, Object> listenersToRelatedSubjects = new IdentityHashMap<Object, Object>();
    private transient int nextToNotify;
    private transient List<SubjectAndListener> subjectAndListeners = Collections.emptyList();
    private transient List<SubjectAndListener> subjectsAndListenersForCurrentEvent;

    SequenceDependenciesEventPublisher() {
    }

    private Object readResolve() throws ObjectStreamException {
        return new SequenceDependenciesEventPublisher();
    }

    private List<SubjectAndListener> orderSubjectsAndListeners(List<SubjectAndListener> list) {
        Object object;
        ArrayList<SubjectAndListener> arrayList = new ArrayList<SubjectAndListener>();
        IdentityMultimap<Object, SubjectAndListener> identityMultimap = new IdentityMultimap<Object, SubjectAndListener>();
        IdentityMultimap<Object, SubjectAndListener> identityMultimap2 = new IdentityMultimap<Object, SubjectAndListener>();
        IdentityHashMap<Object, Boolean> identityHashMap = new IdentityHashMap<Object, Boolean>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SubjectAndListener subjectAndListener = list.get(i2);
            Object object2 = subjectAndListener.subject;
            object = this.getRelatedSubject(subjectAndListener.listener);
            identityMultimap.addValue(object2, subjectAndListener);
            identityMultimap2.addValue(object, subjectAndListener);
            identityHashMap.remove(object);
            if (identityMultimap2.count(object2) != 0) continue;
            identityHashMap.put(object2, Boolean.TRUE);
        }
        arrayList2.addAll(identityHashMap.keySet());
        while (!arrayList2.isEmpty()) {
            Object e2 = arrayList2.remove(0);
            Object object3 = identityMultimap.get(e2);
            int n3 = object3.size();
            block2: for (int i3 = 0; i3 < n3; ++i3) {
                object = this.getRelatedSubject(((SubjectAndListener)object3.get(i3)).listener);
                Object object4 = identityMultimap2.get(object);
                if (object4.size() == 0) continue;
                int n4 = object4.size();
                for (int i4 = 0; i4 < n4; ++i4) {
                    SubjectAndListener subjectAndListener = (SubjectAndListener)object4.get(i4);
                    if (!identityHashMap.containsKey(subjectAndListener.subject)) continue block2;
                }
                arrayList.addAll((Collection<SubjectAndListener>)object4);
                identityMultimap2.remove(object);
                arrayList2.add(object);
                identityHashMap.put(object, Boolean.TRUE);
            }
        }
        if (!identityMultimap2.isEmpty()) {
            throw new IllegalStateException("Listener cycle detected, " + identityMultimap2.values());
        }
        return arrayList;
    }

    private Object getRelatedSubject(Object object) {
        Object object2 = this.listenersToRelatedSubjects.get(object);
        if (object2 == null) {
            return object;
        }
        return object2;
    }

    public synchronized <Subject, Listener, Event> void addListener(Subject Subject, Listener Listener2, EventFormat<Subject, Listener, Event> eventFormat) {
        List<SubjectAndListener> list = this.updateListEventListeners(Subject, Listener2, null, eventFormat);
        this.subjectAndListeners = this.orderSubjectsAndListeners(list);
    }

    public synchronized void removeListener(Object object, Object object2) {
        this.subjectAndListeners = this.updateListEventListeners(object, null, object2, null);
    }

    private <Subject, Listener, Event> List<SubjectAndListener> updateListEventListeners(Subject Subject, Listener Listener2, Listener Listener3, EventFormat<Subject, Listener, Event> eventFormat) {
        int n2 = this.subjectAndListeners.size() + (Listener2 == null ? -1 : 1);
        if (n2 < 0) {
            n2 = 0;
        }
        ArrayList<SubjectAndListener> arrayList = new ArrayList<SubjectAndListener>(n2);
        int n3 = this.subjectAndListeners.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            SubjectAndListener subjectAndListener = this.subjectAndListeners.get(i2);
            if (subjectAndListener.listener == Listener3 && subjectAndListener.subject == Subject) {
                Listener3 = null;
                continue;
            }
            if (subjectAndListener.eventFormat.isStale(subjectAndListener.subject, subjectAndListener.listener)) continue;
            arrayList.add(subjectAndListener);
        }
        if (DO_NONEXISTENT_LISTENER_CHECK && Listener3 != null) {
            throw new IllegalArgumentException("Cannot remove nonexistent listener " + Listener3);
        }
        if (Listener2 != null) {
            arrayList.add(new SubjectAndListener<Subject, Listener, Event>(Subject, Listener2, eventFormat));
        }
        return arrayList;
    }

    @Override
    public void setRelatedListener(Object object, Object object2) {
        this.addListener(object2, object, NoOpEventFormat.INSTANCE);
    }

    @Override
    public void clearRelatedListener(Object object, Object object2) {
        this.removeListener(object2, object);
    }

    @Override
    public void addDependency(EventList eventList, ListEventListener listEventListener) {
    }

    @Override
    public void removeDependency(EventList eventList, ListEventListener listEventListener) {
    }

    @Override
    public void setRelatedSubject(Object object, Object object2) {
        if (object2 != null) {
            this.listenersToRelatedSubjects.put(object, object2);
        } else {
            this.listenersToRelatedSubjects.remove(object);
        }
    }

    @Override
    public void clearRelatedSubject(Object object) {
        this.listenersToRelatedSubjects.remove(object);
    }

    public synchronized <Listener> List<Listener> getListeners(Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n2 = this.subjectAndListeners.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            SubjectAndListener subjectAndListener = this.subjectAndListeners.get(i2);
            if (subjectAndListener.subject != object) continue;
            arrayList.add(subjectAndListener.listener);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    public <Subject, Listener, Event> void fireEvent(Subject Subject, Event Event2, EventFormat<Subject, Listener, Event> eventFormat) {
        if (this.reentrantFireEventCount == 0) {
            this.subjectsAndListenersForCurrentEvent = this.subjectAndListeners;
            this.nextToNotify = Integer.MAX_VALUE;
        }
        ++this.reentrantFireEventCount;
        try {
            Object object;
            EventFormat<Subject, Listener, Event> eventFormat2 = this.subjectsToCleanUp.put(Subject, eventFormat);
            if (eventFormat2 != null) {
                throw new IllegalStateException("Reentrant fireEvent() by \"" + Subject + "\"");
            }
            int n2 = this.subjectsAndListenersForCurrentEvent.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                object = this.subjectsAndListenersForCurrentEvent.get(i2);
                if (((SubjectAndListener)object).subject != Subject) continue;
                if (i2 < this.nextToNotify) {
                    this.nextToNotify = i2;
                }
                ((SubjectAndListener)object).addPendingEvent(Event2);
            }
            if (this.reentrantFireEventCount != 1) {
                return;
            }
            RuntimeException runtimeException = null;
            while (true) {
                object = null;
                for (int i3 = this.nextToNotify; i3 < n2; ++i3) {
                    SubjectAndListener subjectAndListener = this.subjectsAndListenersForCurrentEvent.get(i3);
                    if (!subjectAndListener.hasPendingEvent()) continue;
                    object = subjectAndListener;
                    this.nextToNotify = i3 + 1;
                    break;
                }
                if (object == null) break;
                try {
                    ((SubjectAndListener)object).firePendingEvent();
                }
                catch (RuntimeException runtimeException2) {
                    if (runtimeException != null) continue;
                    runtimeException = runtimeException2;
                }
            }
            for (Map.Entry entry : this.subjectsToCleanUp.entrySet()) {
                try {
                    ((EventFormat)entry.getValue()).postEvent(entry.getKey());
                }
                catch (RuntimeException runtimeException3) {
                    if (runtimeException != null) continue;
                    runtimeException = runtimeException3;
                }
            }
            this.subjectsToCleanUp.clear();
            this.subjectsAndListenersForCurrentEvent = null;
            if (runtimeException != null) {
                throw runtimeException;
            }
        }
        finally {
            --this.reentrantFireEventCount;
        }
    }

    static {
        boolean bl = false;
        try {
            bl = System.getProperty("glazedlists.compat.nonexistent_listener_check") != null;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        DO_NONEXISTENT_LISTENER_CHECK = bl;
    }

    private static class SubjectAndListener<Subject, Listener, Event> {
        private final Subject subject;
        private final Listener listener;
        private final EventFormat<Subject, Listener, Event> eventFormat;
        private Event pendingEvent;

        public SubjectAndListener(Subject Subject, Listener Listener2, EventFormat<Subject, Listener, Event> eventFormat) {
            this.subject = Subject;
            this.listener = Listener2;
            this.eventFormat = eventFormat;
        }

        public boolean hasPendingEvent() {
            return this.pendingEvent != null;
        }

        public void addPendingEvent(Event Event2) {
            if (this.pendingEvent != null) {
                throw new IllegalStateException();
            }
            if (Event2 == null) {
                throw new IllegalStateException();
            }
            this.pendingEvent = Event2;
        }

        public void firePendingEvent() {
            assert (this.pendingEvent != null);
            try {
                this.eventFormat.fire(this.subject, this.pendingEvent, this.listener);
            }
            finally {
                this.pendingEvent = null;
            }
        }

        public String toString() {
            String string = this.hasPendingEvent() ? ">>>" : "-->";
            return this.subject + string + this.listener;
        }
    }

    private static class NoOpEventFormat
    implements EventFormat {
        public static final EventFormat INSTANCE = new NoOpEventFormat();

        private NoOpEventFormat() {
        }

        public void fire(Object object, Object object2, Object object3) {
            throw new UnsupportedOperationException();
        }

        public void postEvent(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean isStale(Object object, Object object2) {
            return false;
        }
    }

    public static interface EventFormat<Subject, Listener, Event> {
        public void fire(Subject var1, Event var2, Listener var3);

        public void postEvent(Subject var1);

        public boolean isStale(Subject var1, Listener var2);
    }
}

