/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.event;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.event.ListEventPublisher;
import ca.odell.glazedlists.event.SequenceDependenciesEventPublisher;
import ca.odell.glazedlists.event.Tree4DeltasListEvent;
import ca.odell.glazedlists.impl.Preconditions;
import ca.odell.glazedlists.impl.WeakReferenceProxy;
import ca.odell.glazedlists.impl.event.BlockSequence;
import ca.odell.glazedlists.impl.event.Tree4Deltas;
import java.util.ConcurrentModificationException;
import java.util.List;

public final class ListEventAssembler<E> {
    protected EventList<E> sourceList;
    private Thread eventThread;
    protected int eventLevel = 0;
    protected boolean allowNestedEvents = true;
    protected int[] reorderMap = null;
    private BlockSequence<E> blockSequence = new BlockSequence();
    private boolean useListBlocksLinear = false;
    private Tree4Deltas<E> listDeltas = new Tree4Deltas();
    private final SequenceDependenciesEventPublisher publisher;
    private final ListEvent<E> listEvent;
    private final ListEventFormat eventFormat = new ListEventFormat();
    private boolean eventIsBeingPublished = false;

    public static ListEventPublisher createListEventPublisher() {
        return new SequenceDependenciesEventPublisher();
    }

    public ListEventAssembler(EventList<E> eventList, ListEventPublisher listEventPublisher) {
        this.sourceList = eventList;
        this.publisher = (SequenceDependenciesEventPublisher)listEventPublisher;
        this.listEvent = new Tree4DeltasListEvent<E>(this, eventList);
    }

    public boolean isEventInProgress() {
        return this.eventLevel != 0;
    }

    public void beginEvent() {
        this.beginEvent(false);
    }

    public synchronized void beginEvent(boolean bl) {
        if (!this.allowNestedEvents) {
            throw new ConcurrentModificationException("Cannot begin a new event while another event is in progress by thread, " + this.eventThread.getName());
        }
        this.allowNestedEvents = bl;
        if (bl || this.eventLevel == 0 && this.eventThread != null) {
            this.listDeltas.setAllowContradictingEvents(true);
        }
        if (this.eventThread == null) {
            this.eventThread = Thread.currentThread();
            this.useListBlocksLinear = true;
        }
        ++this.eventLevel;
    }

    public void elementInserted(int n2, E e2) {
        this.addChange(2, n2, n2, ListEvent.unknownValue(), e2);
    }

    public void elementUpdated(int n2, E e2, E e3) {
        this.addChange(1, n2, n2, e2, e3);
    }

    public void elementDeleted(int n2, E e2) {
        this.addChange(0, n2, n2, e2, ListEvent.unknownValue());
    }

    @Deprecated
    public void elementUpdated(int n2, E e2) {
        this.elementUpdated(n2, e2, ListEvent.unknownValue());
    }

    @Deprecated
    public void addChange(int n2, int n3, int n4) {
        this.addChange(n2, n3, n4, ListEvent.unknownValue(), ListEvent.unknownValue());
    }

    @Deprecated
    public void addChange(int n2, int n3) {
        this.addChange(n2, n3, n3);
    }

    @Deprecated
    public void addInsert(int n2) {
        this.addChange(2, n2);
    }

    @Deprecated
    public void addDelete(int n2) {
        this.addChange(0, n2);
    }

    @Deprecated
    public void addUpdate(int n2) {
        this.addChange(1, n2);
    }

    @Deprecated
    public void addInsert(int n2, int n3) {
        this.addChange(2, n2, n3);
    }

    @Deprecated
    public void addDelete(int n2, int n3) {
        this.addChange(0, n2, n3);
    }

    @Deprecated
    public void addUpdate(int n2, int n3) {
        this.addChange(1, n2, n3);
    }

    private void addChange(int n2, int n3, int n4, E e2, E e3) {
        if (this.useListBlocksLinear) {
            boolean bl = this.blockSequence.addChange(n2, n3, n4 + 1, e2, e3);
            if (bl) {
                return;
            }
            this.listDeltas.addAll(this.blockSequence);
            this.useListBlocksLinear = false;
        }
        switch (n2) {
            case 2: {
                this.listDeltas.targetInsert(n3, n4 + 1, e3);
                break;
            }
            case 1: {
                this.listDeltas.targetUpdate(n3, n4 + 1, e2, e3);
                break;
            }
            case 0: {
                this.listDeltas.targetDelete(n3, n4 + 1, e2);
            }
        }
    }

    public void reorder(int[] nArray) {
        if (!this.isEventEmpty()) {
            throw new IllegalStateException("Cannot combine reorder with other change events");
        }
        if (nArray.length == 0) {
            return;
        }
        this.addChange(0, 0, nArray.length - 1, ListEvent.unknownValue(), ListEvent.unknownValue());
        this.addChange(2, 0, nArray.length - 1, ListEvent.unknownValue(), ListEvent.unknownValue());
        this.reorderMap = nArray;
    }

    public void forwardEvent(ListEvent<?> listEvent) {
        this.beginEvent(false);
        this.reorderMap = null;
        if (this.isEventEmpty() && listEvent.isReordering()) {
            this.reorder(listEvent.getReorderMap());
        } else {
            while (listEvent.next()) {
                int n2 = listEvent.getType();
                int n3 = listEvent.getIndex();
                Object obj = listEvent.getOldValue();
                Object obj2 = listEvent.getNewValue();
                this.addChange(n2, n3, n3, obj, obj2);
            }
            listEvent.reset();
        }
        this.commitEvent();
    }

    public synchronized void commitEvent() {
        if (this.eventLevel == 0) {
            throw new IllegalStateException("Cannot commit without an event in progress");
        }
        --this.eventLevel;
        this.allowNestedEvents = true;
        if (this.eventLevel != 0) {
            return;
        }
        if (this.isEventEmpty()) {
            this.cleanup();
            return;
        }
        if (this.eventIsBeingPublished) {
            return;
        }
        this.eventIsBeingPublished = true;
        this.publisher.fireEvent(this.sourceList, this.listEvent, this.eventFormat);
    }

    public synchronized void discardEvent() {
        if (this.eventLevel == 0) {
            throw new IllegalStateException("Cannot discard without an event in progress");
        }
        --this.eventLevel;
        this.allowNestedEvents = true;
        if (this.eventLevel == 0) {
            this.cleanup();
        }
    }

    public boolean isEventEmpty() {
        return this.useListBlocksLinear ? this.blockSequence.isEmpty() : this.listDeltas.isEmpty();
    }

    public synchronized void addListEventListener(ListEventListener<? super E> listEventListener) {
        Preconditions.checkNotNull(listEventListener, "ListEventListener is undefined");
        this.publisher.addListener(this.sourceList, listEventListener, this.eventFormat);
    }

    public synchronized void removeListEventListener(ListEventListener<? super E> listEventListener) {
        Preconditions.checkNotNull(listEventListener, "ListEventListener is undefined");
        this.publisher.removeListener(this.sourceList, listEventListener);
    }

    public List<ListEventListener<E>> getListEventListeners() {
        return this.publisher.getListeners(this.sourceList);
    }

    boolean getUseListBlocksLinear() {
        return this.useListBlocksLinear;
    }

    Tree4Deltas getListDeltas() {
        return this.listDeltas;
    }

    BlockSequence getListBlocksLinear() {
        return this.blockSequence;
    }

    int[] getReorderMap() {
        return this.reorderMap;
    }

    private void cleanup() {
        this.eventThread = null;
        this.blockSequence.reset();
        this.listDeltas.reset(this.sourceList.size());
        this.reorderMap = null;
        this.listDeltas.setAllowContradictingEvents(false);
        this.listEvent.reset();
    }

    private class ListEventFormat
    implements SequenceDependenciesEventPublisher.EventFormat<EventList<E>, ListEventListener<? super E>, ListEvent<E>> {
        private ListEventFormat() {
        }

        @Override
        public void fire(EventList<E> eventList, ListEvent<E> listEvent, ListEventListener<? super E> listEventListener) {
            listEvent.reset();
            listEventListener.listChanged(listEvent);
        }

        @Override
        public void postEvent(EventList<E> eventList) {
            ListEventAssembler.this.cleanup();
            ListEventAssembler.this.eventIsBeingPublished = false;
        }

        @Override
        public boolean isStale(EventList<E> eventList, ListEventListener<? super E> listEventListener) {
            if (listEventListener instanceof WeakReferenceProxy && ((WeakReferenceProxy)listEventListener).getReferent() == null) {
                ((WeakReferenceProxy)listEventListener).dispose();
                return true;
            }
            return false;
        }
    }
}

