/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.impl.Grouper;
import ca.odell.glazedlists.impl.adt.BarcodeIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class UniqueList<E>
extends TransformedList<E, E> {
    private final Grouper<E> grouper;

    public static <E extends Comparable<? super E>> UniqueList<E> create(EventList<E> eventList) {
        return new UniqueList<E>(eventList);
    }

    public UniqueList(EventList<E> eventList) {
        this(eventList, GlazedLists.comparableComparator());
    }

    public UniqueList(EventList<E> eventList, Comparator<? super E> comparator) {
        this(new SortedList<E>(eventList, comparator), (Void)null);
    }

    private UniqueList(SortedList<E> sortedList, Void void_) {
        super(sortedList);
        this.grouper = new Grouper<E>(sortedList, new GrouperClient());
        sortedList.addListEventListener(this);
    }

    public void setComparator(Comparator<? super E> comparator) {
        if (comparator == null) {
            comparator = GlazedLists.comparableComparator();
        }
        ((SortedList)this.source).setComparator(comparator);
    }

    @Override
    public int size() {
        return this.grouper.getBarcode().colourSize(Grouper.UNIQUE);
    }

    @Override
    protected int getSourceIndex(int n2) {
        if (n2 == this.size()) {
            return this.source.size();
        }
        return this.grouper.getBarcode().getIndex(n2, Grouper.UNIQUE);
    }

    private int getEndIndex(int n2) {
        if (n2 == this.size() - 1) {
            return this.source.size();
        }
        return this.getSourceIndex(n2 + 1);
    }

    @Override
    public E remove(int n2) {
        if (n2 < 0 || n2 >= this.size()) {
            throw new IndexOutOfBoundsException("Cannot remove at " + n2 + " on list of size " + this.size());
        }
        this.updates.beginEvent(true);
        Object e2 = this.get(n2);
        int n3 = this.getSourceIndex(n2);
        int n4 = this.getEndIndex(n2);
        ((SortedList)this.source).subList(n3, n4).clear();
        this.updates.commitEvent();
        return e2;
    }

    @Override
    public E set(int n2, E e2) {
        if (n2 < 0 || n2 >= this.size()) {
            throw new IndexOutOfBoundsException("Cannot set at " + n2 + " on list of size " + this.size());
        }
        this.updates.beginEvent(true);
        int n3 = this.getSourceIndex(n2) + 1;
        int n4 = this.getEndIndex(n2);
        if (n4 > n3) {
            ((SortedList)this.source).subList(n3, n4).clear();
        }
        E e3 = super.set(n2, e2);
        this.updates.commitEvent();
        return e3;
    }

    @Override
    public int indexOf(Object object) {
        int n2 = Collections.binarySearch(this, object, ((SortedList)this.source).getComparator());
        return n2 < 0 ? -1 : n2;
    }

    @Override
    protected boolean isWritable() {
        return true;
    }

    @Override
    public void listChanged(ListEvent<E> listEvent) {
        this.updates.beginEvent(true);
        SortedList sortedList = (SortedList)this.source;
        Comparator comparator = sortedList.getComparator();
        if (comparator != this.grouper.getComparator()) {
            if (!listEvent.isReordering()) {
                throw new IllegalStateException("source comparator changed without reordering!");
            }
            int[] nArray = listEvent.getReorderMap();
            int[] nArray2 = new int[nArray.length];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                nArray2[nArray[i2]] = i2;
            }
            BarcodeIterator barcodeIterator = this.grouper.getBarcode().iterator();
            while (barcodeIterator.hasNextBlack()) {
                barcodeIterator.nextBlack();
                int n2 = barcodeIterator.getIndex();
                this.updates.elementDeleted(0, sortedList.get(nArray2[n2]));
            }
            this.grouper.getBarcode().clear();
            this.grouper.setComparator(comparator);
            int n3 = 0;
            BarcodeIterator barcodeIterator2 = this.grouper.getBarcode().iterator();
            while (barcodeIterator2.hasNextBlack()) {
                barcodeIterator2.nextBlack();
                int n4 = barcodeIterator2.getIndex();
                this.updates.elementInserted(n3, sortedList.get(n4));
                ++n3;
            }
        } else {
            this.grouper.listChanged(listEvent);
        }
        this.updates.commitEvent();
    }

    public int getCount(int n2) {
        int n3 = this.getSourceIndex(n2);
        int n4 = this.getEndIndex(n2);
        return n4 - n3;
    }

    public int getCount(E e2) {
        int n2 = this.indexOf(e2);
        if (n2 == -1) {
            return 0;
        }
        return this.getCount(n2);
    }

    public List<E> getAll(int n2) {
        int n3 = this.getSourceIndex(n2);
        int n4 = this.getEndIndex(n2);
        return new ArrayList(this.source.subList(n3, n4));
    }

    public List<E> getAll(E e2) {
        int n2 = this.indexOf(e2);
        return n2 == -1 ? Collections.emptyList() : this.getAll((E)n2);
    }

    @Override
    public void dispose() {
        ((SortedList)this.source).dispose();
        super.dispose();
    }

    private class GrouperClient
    implements Grouper.Client<E> {
        private GrouperClient() {
        }

        @Override
        public void groupChanged(int n2, int n3, int n4, boolean bl, int n5, E e2, E e3, boolean bl2, boolean bl3) {
            switch (n4) {
                case 2: {
                    UniqueList.this.updates.elementInserted(n3, e3);
                    break;
                }
                case 1: {
                    UniqueList.this.updates.elementUpdated(n3, e2, e3);
                    break;
                }
                case 0: {
                    UniqueList.this.updates.elementDeleted(n3, e2);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized groupChangeType: " + n4);
                }
            }
        }
    }
}

