/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransactionList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;

public final class UndoRedoSupport<E> {
    private TransactionList<E> txSource;
    private ListEventListener<E> txSourceListener = new TXSourceListener();
    private final CopyOnWriteArrayList<Listener> listenerList = new CopyOnWriteArrayList();
    private int ignoreListEvent = 0;
    private List<E> priorElements;

    private UndoRedoSupport(EventList<E> eventList) {
        this.txSource = new TransactionList<E>(eventList, false);
        this.txSource.addListEventListener(this.txSourceListener);
        this.priorElements = new ArrayList<E>(eventList);
    }

    public void addUndoSupportListener(Listener listener) {
        if (listener != null) {
            this.listenerList.add(listener);
        }
    }

    public void removeUndoSupportListener(Listener listener) {
        if (listener != null) {
            this.listenerList.remove(listener);
        }
    }

    private void fireUndoableEditHappened(Edit edit) {
        List list = (List)this.listenerList.clone();
        ListIterator listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            ((Listener)listIterator.previous()).undoableEditHappened(edit);
        }
    }

    public static <E> UndoRedoSupport install(EventList<E> eventList) {
        return new UndoRedoSupport<E>(eventList);
    }

    public void uninstall() {
        this.txSource.dispose();
        this.txSource.removeListEventListener(this.txSourceListener);
        this.txSource = null;
        this.priorElements = null;
    }

    private final class UpdateEdit<E>
    extends AbstractSimpleEdit<E> {
        private final E oldValue;

        public UpdateEdit(EventList<E> eventList, int n2, E e2, E e3) {
            super(eventList, n2, e2);
            this.oldValue = e3;
        }

        @Override
        public void undoImpl() {
            this.source.set(this.index, this.oldValue);
        }

        @Override
        public void redoImpl() {
            this.source.set(this.index, this.value);
        }
    }

    private final class RemoveEdit<E>
    extends AbstractSimpleEdit<E> {
        public RemoveEdit(EventList<E> eventList, int n2, E e2) {
            super(eventList, n2, e2);
        }

        @Override
        public void undoImpl() {
            this.source.add(this.index, this.value);
        }

        @Override
        public void redoImpl() {
            this.source.remove(this.index);
        }
    }

    private final class AddEdit<E>
    extends AbstractSimpleEdit<E> {
        public AddEdit(EventList<E> eventList, int n2, E e2) {
            super(eventList, n2, e2);
        }

        @Override
        public void undoImpl() {
            this.source.remove(this.index);
        }

        @Override
        public void redoImpl() {
            this.source.add(this.index, this.value);
        }
    }

    private abstract class AbstractSimpleEdit<E>
    extends AbstractEdit {
        protected final EventList<E> source;
        protected final int index;
        protected final E value;

        protected AbstractSimpleEdit(EventList<E> eventList, int n2, E e2) {
            this.source = eventList;
            this.index = n2;
            this.value = e2;
        }
    }

    final class CompositeEdit
    extends AbstractEdit {
        private final List<Edit> edits;

        CompositeEdit() {
            this.edits = new ArrayList<Edit>();
        }

        void add(Edit edit) {
            this.edits.add(edit);
        }

        private boolean isEmpty() {
            return this.edits.isEmpty();
        }

        private Edit getSimplestEdit() {
            return this.edits.size() == 1 ? this.edits.get(0) : this;
        }

        @Override
        public void undoImpl() {
            UndoRedoSupport.this.txSource.beginEvent();
            try {
                ListIterator<Edit> listIterator = this.edits.listIterator(this.edits.size());
                while (listIterator.hasPrevious()) {
                    listIterator.previous().undo();
                }
            }
            finally {
                UndoRedoSupport.this.txSource.commitEvent();
            }
        }

        @Override
        public void redoImpl() {
            UndoRedoSupport.this.txSource.beginEvent();
            try {
                for (Edit edit : this.edits) {
                    edit.redo();
                }
            }
            finally {
                UndoRedoSupport.this.txSource.commitEvent();
            }
        }
    }

    private abstract class AbstractEdit
    implements Edit {
        protected boolean canUndo = true;

        private AbstractEdit() {
        }

        @Override
        public void undo() {
            if (!this.canUndo()) {
                throw new IllegalStateException("The Edit is in an incorrect state for undoing");
            }
            UndoRedoSupport.this.ignoreListEvent++;
            try {
                this.undoImpl();
            }
            finally {
                UndoRedoSupport.this.ignoreListEvent--;
            }
            this.canUndo = false;
        }

        @Override
        public void redo() {
            if (!this.canRedo()) {
                throw new IllegalStateException("The Edit is in an incorrect state for redoing");
            }
            UndoRedoSupport.this.ignoreListEvent++;
            try {
                this.redoImpl();
            }
            finally {
                UndoRedoSupport.this.ignoreListEvent--;
            }
            this.canUndo = true;
        }

        protected abstract void undoImpl();

        protected abstract void redoImpl();

        @Override
        public final boolean canUndo() {
            return this.canUndo;
        }

        @Override
        public final boolean canRedo() {
            return !this.canUndo;
        }
    }

    public static interface Edit {
        public void undo();

        public boolean canUndo();

        public void redo();

        public boolean canRedo();
    }

    @FunctionalInterface
    public static interface Listener
    extends EventListener {
        public void undoableEditHappened(Edit var1);
    }

    private class TXSourceListener
    implements ListEventListener<E> {
        private TXSourceListener() {
        }

        @Override
        public void listChanged(ListEvent<E> listEvent) {
            if (UndoRedoSupport.this.ignoreListEvent > 0) {
                return;
            }
            CompositeEdit compositeEdit = new CompositeEdit();
            while (listEvent.next()) {
                Object e2;
                Object e3;
                int n2 = listEvent.getIndex();
                int n3 = listEvent.getType();
                if (n3 == 2) {
                    e3 = UndoRedoSupport.this.txSource.get(n2);
                    UndoRedoSupport.this.priorElements.add(n2, e3);
                    compositeEdit.add(new AddEdit(UndoRedoSupport.this.txSource, n2, e3));
                    continue;
                }
                if (n3 == 0) {
                    e3 = listEvent.getOldValue();
                    e2 = UndoRedoSupport.this.priorElements.remove(n2);
                    if (e3 == ListEvent.UNKNOWN_VALUE) {
                        e3 = e2;
                    }
                    compositeEdit.add(new RemoveEdit(UndoRedoSupport.this.txSource, n2, e3));
                    continue;
                }
                if (n3 != 1) continue;
                e3 = listEvent.getOldValue();
                if (e3 == ListEvent.UNKNOWN_VALUE) {
                    e3 = UndoRedoSupport.this.priorElements.get(n2);
                }
                if ((e2 = UndoRedoSupport.this.txSource.get(n2)) == e3) continue;
                UndoRedoSupport.this.priorElements.set(n2, e2);
                compositeEdit.add(new UpdateEdit(UndoRedoSupport.this.txSource, n2, e2, e3));
            }
            if (!compositeEdit.isEmpty()) {
                UndoRedoSupport.this.fireUndoableEditHappened(compositeEdit.getSimplestEdit());
            }
        }
    }
}

