/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FunctionList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.TreeList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.impl.GlazedListsImpl;
import ca.odell.glazedlists.impl.adt.CircularArrayList;
import ca.odell.glazedlists.impl.adt.KeyedCollection;
import ca.odell.glazedlists.impl.adt.barcode2.Element;
import ca.odell.glazedlists.impl.adt.barcode2.FourColorTree;
import ca.odell.glazedlists.impl.adt.barcode2.ListToByteCoder;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public final class TreeList<E>
extends TransformedList<Node<E>, E> {
    public static final ExpansionModel NODES_START_EXPANDED = new DefaultExpansionModel(true);
    public static final ExpansionModel NODES_START_COLLAPSED = new DefaultExpansionModel(false);
    private static final Element MINIMUM_ELEMENT = new FakeElement();
    private static final Element MAXIMUM_ELEMENT = new FakeElement();
    private static final FunctionList.Function NO_OP_FUNCTION = new NoOpFunction();
    private ExpansionModel<E> expansionModel;
    private static final ListToByteCoder<String> BYTE_CODER = new ListToByteCoder<String>(Arrays.asList("R", "V", "r", "v"));
    private static final byte VISIBLE_REAL = BYTE_CODER.colorToByte("R");
    private static final byte VISIBLE_VIRTUAL = BYTE_CODER.colorToByte("V");
    private static final byte HIDDEN_REAL = BYTE_CODER.colorToByte("r");
    private static final byte HIDDEN_VIRTUAL = BYTE_CODER.colorToByte("v");
    private static final byte ALL_NODES = BYTE_CODER.colorsToByte(Arrays.asList("R", "V", "r", "v"));
    private static final byte VISIBLE_NODES = BYTE_CODER.colorsToByte(Arrays.asList("R", "V"));
    private static final byte HIDDEN_NODES = BYTE_CODER.colorsToByte(Arrays.asList("r", "v"));
    private static final byte REAL_NODES = BYTE_CODER.colorsToByte(Arrays.asList("R", "r"));
    private final NodeComparator<E> nodeComparator;
    private EventList<Node<E>> nodesList;
    private List<Node<E>> allNodesList;
    private InitializationData<E> initializationData;
    private FourColorTree<Node<E>> data = new FourColorTree(BYTE_CODER);
    private Format<E> format;

    public static final <E> ExpansionModel<E> nodesStartExpanded() {
        return NODES_START_EXPANDED;
    }

    public static final <E> ExpansionModel<E> nodesStartCollapsed() {
        return NODES_START_COLLAPSED;
    }

    public TreeList(EventList<E> eventList, Format<E> format, ExpansionModel<E> expansionModel) {
        this(new InitializationData<E>(eventList, format, expansionModel));
    }

    private TreeList(InitializationData<E> initializationData) {
        super(initializationData.getSource());
        this.format = ((InitializationData)initializationData).format;
        this.nodeComparator = ((InitializationData)initializationData).nodeComparator;
        this.expansionModel = ((InitializationData)initializationData).expansionModel;
        this.initializationData = initializationData;
        NodeAttacher nodeAttacher = new NodeAttacher(false);
        for (int i2 = 0; i2 < this.source.size(); ++i2) {
            Node node = (Node)this.source.get(i2);
            node.expanded = this.expansionModel.isExpanded(node.getElement(), node.path);
            this.addNode(node, HIDDEN_REAL, i2);
            nodeAttacher.nodesToAttach.queueNewNodeForInserting(node);
        }
        nodeAttacher.attachAll();
        assert (this.isValid());
        this.source.addListEventListener(this);
    }

    @Deprecated
    public TreeList(EventList<E> eventList, Format<E> format) {
        this(new InitializationData<E>(eventList, format, TreeList.nodesStartExpanded()));
    }

    public EventList<Node<E>> getNodesList() {
        if (this.nodesList == null) {
            this.nodesList = new NodesList();
        }
        return this.nodesList;
    }

    List<Node<E>> getAllNodesList() {
        if (this.allNodesList == null) {
            this.allNodesList = new AllNodesList();
        }
        return this.allNodesList;
    }

    public int depth(int n2) {
        return ((Node)this.getTreeNode(n2)).path.size() - 1;
    }

    private int subtreeSize(int n2, boolean bl, boolean bl2) {
        int n3;
        byte by = bl ? VISIBLE_NODES : ALL_NODES;
        byte by2 = bl2 ? ALL_NODES : VISIBLE_NODES;
        Node<E> node = this.data.get(n2, by).get();
        if (by == by2) {
            n3 = n2;
        } else {
            assert ((((Node)node).element.getColor() & by2) != 0);
            n3 = this.data.convertIndexColor(n2, by, by2);
        }
        Node<E> node2 = this.nextNodeThatsNotAChildOfByStructure(node);
        if (node2 == null) {
            return this.data.size(by2) - n3;
        }
        return this.data.indexOfNode(((Node)node2).element, by2) - n3;
    }

    public int subtreeSize(int n2, boolean bl) {
        return this.subtreeSize(n2, true, bl);
    }

    private Node<E> nextNodeThatsNotAChildOfByStructure(Node<E> node) {
        while (node != null) {
            Node node2 = node.siblingAfter;
            if (node2 != null) {
                return node2;
            }
            node = node.parent;
        }
        return null;
    }

    @Override
    public int size() {
        return this.data.size(VISIBLE_NODES);
    }

    @Override
    protected boolean isWritable() {
        return true;
    }

    @Override
    protected int getSourceIndex(int n2) {
        return this.data.convertIndexColor(n2, VISIBLE_NODES, REAL_NODES);
    }

    @Override
    public E get(int n2) {
        return this.getTreeNode(n2).getElement();
    }

    @Override
    public E remove(int n2) {
        E e2 = this.get(n2);
        super.remove(n2);
        return e2;
    }

    public Node<E> getTreeNode(int n2) {
        return this.data.get(n2, VISIBLE_NODES).get();
    }

    public boolean hasChildren(int n2) {
        boolean bl = this.subtreeSize(n2, true) > 1;
        boolean bl2 = this.getTreeNode(n2).isLeaf();
        if (bl2 == bl) {
            this.subtreeSize(n2, true, true);
        }
        return bl;
    }

    public void setTreeFormat(Format<E> format) {
    }

    public List<Node<E>> getRoots() {
        ArrayList<Node<Node<E>>> arrayList = new ArrayList<Node<Node<E>>>();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            Node<E> node = this.getTreeNode(i2);
            if (((Node)node).pathLength() != 1) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    public boolean getAllowsChildren(int n2) {
        return this.format.allowsChildren(this.get(n2));
    }

    public boolean isExpanded(int n2) {
        return ((Node)this.data.get(n2, VISIBLE_NODES).get()).expanded;
    }

    public void setExpanded(int n2, boolean bl) {
        Node<E> node = this.data.get(n2, VISIBLE_NODES).get();
        this.expansionModel.setExpanded(node.getElement(), ((Node)node).path, bl);
        this.setExpanded(node, bl);
        assert (this.isValid());
    }

    private void setExpanded(Node<E> node, boolean bl) {
        boolean bl2;
        if (((Node)node).expanded == bl) {
            return;
        }
        ((Node)node).expanded = bl;
        boolean bl3 = bl2 = (((Node)node).element.getColor() & VISIBLE_NODES) != 0;
        if (bl2) {
            this.updates.beginEvent();
            if (node.isVisible()) {
                int n2 = this.data.indexOfNode(((Node)node).element, VISIBLE_NODES);
                this.updates.addUpdate(n2);
            }
            Node<E> node2 = this.nextNodeThatsNotAChildOfByStructure(node);
            Node node3 = ((Node)node).next();
            while (node3 != null && node3 != node2) {
                boolean bl4 = bl;
                Node node4 = node3.parent;
                while (bl4 && node4 != node) {
                    if (!node4.expanded) {
                        bl4 = false;
                    }
                    node4 = node4.parent;
                }
                if (bl4 != node3.isVisible()) {
                    if (bl4) {
                        this.setVisible(node3, true);
                        int n3 = this.data.indexOfNode(node3.element, VISIBLE_NODES);
                        this.updates.elementInserted(n3, node3.getElement());
                    } else {
                        int n4 = this.data.indexOfNode(node3.element, VISIBLE_NODES);
                        this.updates.elementDeleted(n4, node3.getElement());
                        this.setVisible(node3, false);
                    }
                }
                node3 = node3.next();
            }
            this.updates.commitEvent();
        }
    }

    public void toggleExpanded(int n2) {
        this.setExpanded(n2, !this.isExpanded(n2));
    }

    private void setVisible(Node<E> node, boolean bl) {
        byte by = bl ? (((Node)node).virtual ? VISIBLE_VIRTUAL : VISIBLE_REAL) : (((Node)node).virtual ? HIDDEN_VIRTUAL : HIDDEN_REAL);
        this.data.setColor(((Node)node).element, by);
    }

    private void setVirtual(Node<E> node, boolean bl) {
        byte by = bl ? (node.isVisible() ? VISIBLE_VIRTUAL : HIDDEN_VIRTUAL) : (node.isVisible() ? VISIBLE_REAL : HIDDEN_REAL);
        this.data.setColor(((Node)node).element, by);
    }

    @Override
    public void listChanged(ListEvent<Node<E>> listEvent) {
        this.updates.beginEvent(true);
        ArrayList<Node<E>> arrayList = new ArrayList<Node<E>>();
        NodeAttacher nodeAttacher = new NodeAttacher(true);
        FinderInserter finderInserter = new FinderInserter();
        while (listEvent.next()) {
            Node node;
            int n2 = listEvent.getIndex();
            int n3 = listEvent.getType();
            if (n3 == 2) {
                node = finderInserter.findOrInsertNode(n2);
                nodeAttacher.nodesToAttach.queueNewNodeForInserting(node);
                continue;
            }
            if (n3 == 1) {
                this.replaceAndDetachNode(n2, arrayList);
                node = finderInserter.findOrInsertNode(n2);
                nodeAttacher.nodesToAttach.queueNewNodeForInserting(node);
                continue;
            }
            if (n3 != 0) continue;
            this.deleteAndDetachNode(n2, arrayList);
        }
        nodeAttacher.attachAll();
        this.deleteObsoleteVirtualLeaves(arrayList);
        this.deleteObsoleteVirtualParents(arrayList);
        assert (this.isValid());
        this.updates.commitEvent();
    }

    private void replaceAndDetachNode(int n2, List<Node<E>> list) {
        Node<E> node = this.data.get(n2, REAL_NODES).get();
        Node<E> node2 = new Node<E>(((Node)node).virtual, new ArrayList<E>(node.path()));
        this.replaceNode(node, node2, true);
        list.add(node2);
    }

    private void deleteAndDetachNode(int n2, List<Node<E>> list) {
        Node<E> node = this.data.get(n2, REAL_NODES).get();
        if (!node.isLeaf()) {
            Node<E> node2 = new Node<E>(((Node)node).virtual, new ArrayList<E>(node.path()));
            this.replaceNode(node, node2, true);
            list.add(node2);
        } else {
            Node node3 = ((Node)node).next();
            this.deleteNode(node);
            list.add(((Node)node).parent);
            if (node3 != null && node3.virtual) {
                list.add(node3);
            }
        }
    }

    private void replaceNode(Node<E> node, Node<E> node2, boolean bl) {
        assert (((Node)node).pathLength() == ((Node)node2).pathLength());
        ((Node)node2).expanded = ((Node)node).expanded;
        ((Node)node2).parent = ((Node)node).parent;
        Node node3 = ((Node)node).firstChild();
        while (node3 != null) {
            assert (node3.parent == node);
            node3.parent = (Node)node2;
            node3 = node3.siblingAfter;
        }
        if (((Node)node).siblingAfter != null) {
            ((Node)node2).siblingAfter = ((Node)node).siblingAfter;
            ((Node)node2).siblingAfter.siblingBefore = (Node)node2;
        }
        if (((Node)node).siblingBefore != null) {
            ((Node)node2).siblingBefore = ((Node)node).siblingBefore;
            ((Node)node2).siblingBefore.siblingAfter = (Node)node2;
        }
        ((Node)node2).element = ((Node)node).element;
        ((Node)node2).element.set(node2);
        this.setVirtual(node2, bl);
        ((Node)node2).virtual = bl;
        ((Node)node).element = null;
    }

    /*
     * WARNING - void declaration
     */
    private void deleteObsoleteVirtualLeaves(List<Node<E>> list) {
        for (Node<E> node : list) {
            void node2;
            while (node2 != null && ((Node)node2).virtual && ((Node)node2).element != null && node2.isLeaf()) {
                this.deleteNode((Node<E>)node2);
                Node node3 = ((Node)node2).parent;
            }
        }
    }

    private void deleteObsoleteVirtualParents(List<Node<E>> list) {
        for (Node<E> node : list) {
            Node node2;
            while (node != null && ((Node)node).virtual && ((Node)node).element != null && (node2 = ((Node)node).previous()) != null && this.isAncestorByValue(node2, node)) {
                node = this.deleteVirtualAncestryRootDown(node2, node);
            }
        }
    }

    private Node<E> deleteVirtualAncestryRootDown(Node<E> node, Node<E> node2) {
        Node node3 = ((Node)node).ancestorWithPathLength(((Node)node2).pathLength() + 1);
        assert (node3.siblingAfter == null);
        Node node4 = node3.parent;
        if (node4.expanded && !((Node)node2).expanded) {
            this.setExpanded(node2, true);
        } else if (((Node)node2).expanded && !node4.expanded) {
            this.setExpanded(node4, true);
        }
        Node node5 = ((Node)node2).firstChild();
        assert (node5 == null || node5.siblingBefore == null);
        node3.siblingAfter = node5;
        if (node5 != null) {
            node5.siblingBefore = node3;
        }
        Node node6 = node5;
        while (node6 != null) {
            node6.parent = node4;
            node6 = node6.siblingAfter;
        }
        this.deleteNode(node2);
        return node5;
    }

    private void deleteNode(Node<E> node) {
        ((Node)node).detachSiblings();
        boolean bl = node.isVisible();
        if (bl) {
            int n2 = this.data.indexOfNode(((Node)node).element, VISIBLE_NODES);
            this.updates.elementDeleted(n2, node.getElement());
        }
        this.data.remove(((Node)node).element);
        ((Node)node).element = null;
    }

    private int commonPathLength(Node<E> node, Node<E> node2) {
        List list = ((Node)node).path;
        List list2 = ((Node)node2).path;
        int n2 = Math.min(list.size(), list2.size());
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.valuesEqual(i2, list.get(i2), list2.get(i2))) continue;
            return i2;
        }
        return n2;
    }

    private boolean isAncestorByValue(Node<E> node, Node<E> node2) {
        if (node2 == null) {
            return true;
        }
        List list = ((Node)node2).path;
        if (list.size() >= ((Node)node).path.size()) {
            return false;
        }
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            Object e2;
            Object e3 = list.get(i2);
            if (this.valuesEqual(i2, e3, e2 = ((Node)node).path.get(i2))) continue;
            return false;
        }
        return true;
    }

    private boolean valuesEqual(int n2, E e2, E e3) {
        Comparator<E> comparator = this.format.getComparator(n2);
        if (comparator != null) {
            return comparator.compare(e2, e3) == 0;
        }
        return Objects.equals(e2, e3);
    }

    @Override
    public void dispose() {
        this.source.removeListEventListener(this);
        this.initializationData.dispose();
    }

    private void addNode(Node<E> node, byte by, int n2) {
        ((Node)node).element = this.data.add(n2, TreeList.ALL_NODES, by, node, 1);
    }

    private static <E> NodeComparator<E> comparatorToNodeComparator(Format<E> format) {
        return new NodeComparator<E>(format);
    }

    private boolean isVisibilityValid(Node<E> node) {
        boolean bl = true;
        Node node2 = ((Node)node).parent;
        while (node2 != null) {
            if (!node2.expanded) {
                bl = false;
                break;
            }
            node2 = node2.parent;
        }
        return node.isVisible() == bl;
    }

    private boolean isValid() {
        assert (this.source.size() == this.data.size(REAL_NODES));
        int n2 = 0;
        for (int i2 = 0; i2 < this.data.size(ALL_NODES); ++i2) {
            Node<E> node = this.data.get(i2, ALL_NODES).get();
            assert (((Node)node).element != null);
            assert (!((Node)node).isNewlyInserted);
            assert (((Node)node).pathLength() <= n2 + 1);
            n2 = ((Node)node).pathLength();
            if (!this.isVisibilityValid(node)) {
                throw new IllegalStateException();
            }
            if (((Node)node).virtual) {
                assert (((Node)node).element.getColor() == HIDDEN_VIRTUAL || ((Node)node).element.getColor() == VISIBLE_VIRTUAL);
            } else {
                if (this.source.get(this.data.convertIndexColor(i2, ALL_NODES, REAL_NODES)) != node) {
                    throw new IllegalStateException();
                }
                assert (((Node)node).element.getColor() == HIDDEN_REAL || ((Node)node).element.getColor() == VISIBLE_REAL);
            }
            if (((Node)node).pathLength() != 1) continue;
            this.validateSubtree(node);
        }
        return true;
    }

    private void validateSubtree(Node<E> node) {
        int n2 = this.data.indexOfNode(((Node)node).element, ALL_NODES);
        int n3 = this.subtreeSize(n2, false, true);
        Node<E> node2 = null;
        for (int i2 = 1; i2 < n3; ++i2) {
            Node<E> node3 = this.data.get(n2 + i2, ALL_NODES).get();
            if (((Node)node3).pathLength() == ((Node)node).pathLength() + 1) {
                if (((Node)node3).parent != node) {
                    throw new IllegalStateException();
                }
                assert (((Node)node3).parent == node);
                if (node2 != ((Node)node3).siblingBefore) {
                    throw new IllegalStateException();
                }
                if (node2 != null) {
                    if (((Node)node2).siblingAfter != node3) {
                        throw new IllegalStateException();
                    }
                    if (((Node)node2).pathLength() != ((Node)node3).pathLength()) {
                        throw new IllegalStateException();
                    }
                } else if (((Node)node3).siblingBefore != null) {
                    throw new IllegalStateException();
                }
                node2 = node3;
                this.validateSubtree(node3);
                continue;
            }
            if (((Node)node3).pathLength() > ((Node)node).pathLength() + 1) continue;
            throw new IllegalStateException();
        }
        assert (node2 == null || ((Node)node2).siblingAfter == null);
    }

    private static class FakeElement
    implements Element {
        private FakeElement() {
        }

        public Object get() {
            return null;
        }

        public void set(Object object) {
        }

        @Override
        public byte getColor() {
            return 0;
        }

        @Override
        public void setSorted(int n2) {
        }

        @Override
        public int getSorted() {
            return 0;
        }

        public Element next() {
            return null;
        }

        public Element previous() {
            return null;
        }
    }

    private class AllNodesList
    extends AbstractList<Node<E>> {
        private AllNodesList() {
        }

        @Override
        public Node<E> get(int n2) {
            return (Node)TreeList.this.data.get(n2, ALL_NODES).get();
        }

        @Override
        public int size() {
            return TreeList.this.data.size(ALL_NODES);
        }
    }

    private class NodesList
    extends TransformedList<E, Node<E>> {
        public NodesList() {
            super(TreeList.this);
            TreeList.this.addListEventListener(this);
        }

        @Override
        protected boolean isWritable() {
            return true;
        }

        @Override
        public Node<E> get(int n2) {
            return TreeList.this.getTreeNode(n2);
        }

        @Override
        public void listChanged(ListEvent<E> listEvent) {
            this.updates.forwardEvent(listEvent);
        }
    }

    public static final class Node<E> {
        private final List<E> path;
        private boolean virtual;
        private boolean expanded;
        private Element<Node<E>> element;
        private Node<E> siblingAfter;
        private Node<E> siblingBefore;
        private Node<E> parent;
        private boolean isNewlyInserted = false;

        Node(boolean bl, List<E> list) {
            this.virtual = bl;
            this.path = list;
        }

        private void resetDerivedState() {
            this.virtual = false;
            this.element = null;
            this.siblingAfter = null;
            this.siblingBefore = null;
            this.parent = null;
        }

        private int pathLength() {
            return this.path.size();
        }

        public E getElement() {
            return this.path.get(this.path.size() - 1);
        }

        public List<E> path() {
            return this.path;
        }

        private Node<E> describeParent() {
            int n2 = this.pathLength();
            if (n2 == 1) {
                return null;
            }
            return new Node<E>(true, new ArrayList<E>(this.path.subList(0, n2 - 1)));
        }

        public String toString() {
            return this.path.toString();
        }

        public boolean isVisible() {
            return (this.element.getColor() & VISIBLE_NODES) > 0;
        }

        boolean isVirtual() {
            return this.virtual;
        }

        public boolean isLeaf() {
            Node<E> node = this.next();
            if (node == null) {
                return true;
            }
            return node.parent != this;
        }

        private Node<E> next() {
            if (this.element == null) {
                return null;
            }
            Element<Node<E>> element = this.element.next();
            return element == null ? null : element.get();
        }

        private Node<E> previous() {
            Element<Node<E>> element = this.element.previous();
            return element == null ? null : element.get();
        }

        private Node<E> firstChild() {
            Node<E> node = this.next();
            if (node == null) {
                return null;
            }
            if (node.parent != this) {
                return null;
            }
            return node;
        }

        public List<Node<E>> getChildren() {
            ArrayList<Node<Node<E>>> arrayList = new ArrayList<Node<Node<E>>>();
            Node<E> node = this.firstChild();
            while (node != null) {
                arrayList.add(node);
                node = node.siblingAfter;
            }
            return arrayList;
        }

        private Node<E> ancestorWithPathLength(int n2) {
            assert (this.pathLength() >= n2);
            Node<E> node = this;
            while (node.pathLength() > n2) {
                node = node.parent;
                if (node != null) continue;
                throw new IllegalStateException();
            }
            return node;
        }

        private void detachSiblings() {
            if (this.siblingBefore != null) {
                this.siblingBefore.siblingAfter = this.siblingAfter;
            }
            if (this.siblingAfter != null) {
                this.siblingAfter.siblingBefore = this.siblingBefore;
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Node)) {
                return false;
            }
            Node node = (Node)object;
            return this.path.equals(node.path);
        }

        public int hashCode() {
            return this.path.hashCode();
        }
    }

    private static class NoOpFunction
    implements FunctionList.Function {
        private NoOpFunction() {
        }

        public Object evaluate(Object object) {
            return object;
        }
    }

    private static class ElementToTreeNodeFunction<E>
    implements FunctionList.AdvancedFunction<E, Node<E>> {
        private final Format<E> format;
        private final ExpansionModel<E> expansionModel;

        public ElementToTreeNodeFunction(Format<E> format, ExpansionModel<E> expansionModel) {
            this.format = format;
            this.expansionModel = expansionModel;
        }

        @Override
        public Node<E> evaluate(E e2) {
            ArrayList arrayList = new ArrayList();
            this.format.getPath(arrayList, e2);
            Node node = new Node(false, arrayList);
            node.expanded = this.expansionModel.isExpanded(e2, arrayList);
            return node;
        }

        @Override
        public Node<E> reevaluate(E e2, Node<E> node) {
            assert (!((Node)node).virtual);
            Object object = this.evaluate((Object)e2);
            ((Node)object).expanded = ((Node)node).expanded;
            return object;
        }

        @Override
        public void dispose(E e2, Node<E> node) {
        }
    }

    static class NodeComparator<E>
    implements Comparator<Node<E>> {
        private final Format<E> format;

        public NodeComparator(Format<E> format) {
            if (format == null) {
                throw new IllegalArgumentException();
            }
            this.format = format;
        }

        @Override
        public int compare(Node<E> node, Node<E> node2) {
            int n2 = ((Node)node).path.size();
            int n3 = ((Node)node2).path.size();
            boolean bl = ((Node)node).virtual || this.format.allowsChildren(((Node)node).path.get(n2 - 1));
            boolean bl2 = ((Node)node2).virtual || this.format.allowsChildren(((Node)node2).path.get(n3 - 1));
            int n4 = n2 + (bl ? 0 : -1);
            int n5 = n3 + (bl2 ? 0 : -1);
            for (int i2 = 0; i2 < n4 && i2 < n5; ++i2) {
                Comparator<E> comparator = this.format.getComparator(i2);
                if (comparator == null) {
                    return 0;
                }
                int n6 = comparator.compare(((Node)node).path.get(i2), ((Node)node2).path.get(i2));
                if (n6 == 0) continue;
                return n6;
            }
            return n4 - n5;
        }
    }

    public static interface Format<E> {
        public void getPath(List<E> var1, E var2);

        public boolean allowsChildren(E var1);

        public Comparator<? super E> getComparator(int var1);
    }

    private static class CloneStateNewNodeStateModel<E>
    implements ExpansionModel<E> {
        private boolean[] expandedStateByDepth;

        public CloneStateNewNodeStateModel(Node<E> node) {
            this.expandedStateByDepth = new boolean[node.pathLength()];
            Node node2 = node;
            for (int i2 = this.expandedStateByDepth.length - 1; i2 >= 0; --i2) {
                if (node2 != null) {
                    this.expandedStateByDepth[i2] = node2.expanded;
                    node2 = node2.parent;
                    continue;
                }
                this.expandedStateByDepth[i2] = true;
            }
        }

        @Override
        public boolean isExpanded(E e2, List<E> list) {
            return this.expandedStateByDepth[list.size() - 1];
        }

        @Override
        public void setExpanded(E e2, List<E> list, boolean bl) {
        }
    }

    private static class DefaultExpansionModel<E>
    implements ExpansionModel<E> {
        private boolean expanded;

        public DefaultExpansionModel(boolean bl) {
            this.expanded = bl;
        }

        @Override
        public boolean isExpanded(E e2, List<E> list) {
            return this.expanded;
        }

        @Override
        public void setExpanded(E e2, List<E> list, boolean bl) {
        }
    }

    public static interface ExpansionModel<E> {
        public boolean isExpanded(E var1, List<E> var2);

        public void setExpanded(E var1, List<E> var2, boolean var3);
    }

    private class FinderInserter {
        final KeyedCollection<Element<Node<E>>, List<E>> indicesByValue = GlazedListsImpl.keyedCollection(new ElementLocationComparator());

        private Node<E> findOrInsertNode(int n2) {
            Node node = (Node)TreeList.this.source.get(n2);
            node.resetDerivedState();
            List list = node.path();
            int n3 = TreeList.this.data.size(ALL_NODES);
            int n4 = n2 > 0 ? TreeList.this.data.convertIndexColor(n2 - 1, REAL_NODES, ALL_NODES) + 1 : 0;
            int n5 = n2 < TreeList.this.data.size(REAL_NODES) ? TreeList.this.data.convertIndexColor(n2, REAL_NODES, ALL_NODES) : TreeList.this.data.size(ALL_NODES);
            Element element = this.indexToElement(n4, n3);
            Element element2 = this.indexToElement(n5, n3);
            this.populateIndicesByValue(n4, n5);
            Element element3 = this.indicesByValue.find(element, element2, list);
            if (element3 != null) {
                Node node2 = element3.get();
                if (!node2.virtual) {
                    throw new IllegalStateException();
                }
                TreeList.this.replaceNode(node2, node, false);
                return node;
            }
            int n6 = n4;
            for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                List list2 = list.subList(0, i2);
                Element element4 = this.indicesByValue.find(element, element2, list2);
                if (element4 == null) continue;
                if (!element4.get().virtual) {
                    throw new IllegalStateException();
                }
                n6 = TreeList.this.data.indexOfNode(element4, ALL_NODES) + 1;
                break;
            }
            TreeList.this.addNode(node, HIDDEN_REAL, n6);
            return node;
        }

        private Element<Node<E>> indexToElement(int n2, int n3) {
            if (n2 >= 0 && n2 < n3) {
                return TreeList.this.data.get(n2, ALL_NODES);
            }
            if (n2 == 0) {
                return MINIMUM_ELEMENT;
            }
            if (n2 == n3) {
                return MAXIMUM_ELEMENT;
            }
            throw new IllegalArgumentException();
        }

        private void populateIndicesByValue(int n2, int n3) {
            Element element = this.indicesByValue.first();
            int n4 = element != null ? TreeList.this.data.indexOfNode(element, ALL_NODES) : n3;
            this.populate(n2, n4);
            Element element2 = this.indicesByValue.last();
            int n5 = element2 != null ? TreeList.this.data.indexOfNode(element2, ALL_NODES) : n4;
            this.populate(n5 + 1, n3);
        }

        private void populate(int n2, int n3) {
            for (int i2 = n2; i2 < n3; ++i2) {
                Element element = TreeList.this.data.get(i2, ALL_NODES);
                this.indicesByValue.insert(element, ((Node)element.get()).path());
            }
        }

        private class PathAsListComparator
        implements Comparator<List<E>> {
            private PathAsListComparator() {
            }

            @Override
            public int compare(List<E> list, List<E> list2) {
                int n2 = list.size();
                int n3 = list2.size();
                for (int i2 = 0; i2 < n2 && i2 < n3; ++i2) {
                    Comparator comparator = TreeList.this.format.getComparator(i2);
                    if (comparator == null) {
                        return 0;
                    }
                    int n4 = comparator.compare(list.get(i2), list2.get(i2));
                    if (n4 == 0) continue;
                    return n4;
                }
                return n2 - n3;
            }
        }

        private class ElementLocationComparator
        implements Comparator<Element<Node<E>>> {
            private ElementLocationComparator() {
            }

            @Override
            public int compare(Element<Node<E>> element, Element<Node<E>> element2) {
                if (element == element2) {
                    return 0;
                }
                if (element == MINIMUM_ELEMENT || element2 == MAXIMUM_ELEMENT) {
                    return -1;
                }
                if (element2 == MINIMUM_ELEMENT || element == MAXIMUM_ELEMENT) {
                    return 1;
                }
                int n2 = TreeList.this.data.indexOfNode(element, ALL_NODES);
                int n3 = TreeList.this.data.indexOfNode(element2, ALL_NODES);
                return n2 - n3;
            }
        }
    }

    private final class NodesToAttach {
        private final List<Node<E>> nodes = new CircularArrayList();
        private final ca.odell.glazedlists.TreeList$NodesToAttach.NodeIndexComparator nodeIndexComparator = new NodeIndexComparator();

        private NodesToAttach() {
        }

        private void queueOutOfOrderNodeForAttaching(Node<E> node) {
            int n2 = Collections.binarySearch(this.nodes, node, this.nodeIndexComparator);
            if (n2 >= 0) {
                return;
            }
            this.nodes.add(-n2 - 1, node);
            assert (this.isValid());
        }

        private void queuePrefixForAttaching(Node<E> node) {
            if (!this.nodes.isEmpty()) {
                if (this.nodes.get(0) == node) {
                    return;
                }
                assert (this.nodeIndexComparator.compare(this.nodes.get(0), node) >= 0);
            }
            this.nodes.add(0, node);
            assert (this.isValid());
        }

        private void queueNewNodeForInserting(Node<E> node) {
            assert (this.nodes.isEmpty() || this.nodeIndexComparator.compare(this.nodes.get(this.nodes.size() - 1), node) < 0);
            this.nodes.add(node);
            node.isNewlyInserted = true;
            assert (this.isValid());
        }

        private boolean isEmpty() {
            return this.nodes.isEmpty();
        }

        private Node<E> removeFirst() {
            return this.nodes.remove(0);
        }

        private boolean getNewlyInsertedAndReset(Node<E> node) {
            boolean bl = node.isNewlyInserted;
            node.isNewlyInserted = false;
            return bl;
        }

        private boolean isValid() {
            for (int i2 = 0; i2 < this.nodes.size() - 1; ++i2) {
                Node node = this.nodes.get(i2);
                Node node2 = this.nodes.get(i2 + 1);
                assert (this.nodeIndexComparator.compare(node, node2) <= 0);
            }
            return true;
        }

        private final class NodeIndexComparator
        implements Comparator<Node<E>> {
            private NodeIndexComparator() {
            }

            @Override
            public int compare(Node<E> node, Node<E> node2) {
                if (node.element == null || node2.element == null) {
                    throw new IllegalStateException();
                }
                return TreeList.this.data.indexOfNode(node.element, ALL_NODES) - TreeList.this.data.indexOfNode(node2.element, ALL_NODES);
            }
        }
    }

    private class NodeAttacher {
        private final boolean fireEvents;
        private final NodesToAttach nodesToAttach;
        private Node<E> current;
        private Node<E> predecessor;
        private Node<E> predecessorAtOurHeight;
        private List<Node<E>> pathToRoot;
        private int index;
        private ExpansionModel<E> expansionModel;
        private List<Node<E>> nodesToExpand;

        public NodeAttacher(boolean bl) {
            this.nodesToAttach = new NodesToAttach();
            this.pathToRoot = new ArrayList();
            this.nodesToExpand = new ArrayList();
            this.fireEvents = bl;
        }

        public void attachAll() {
            Object object;
            while (!this.nodesToAttach.isEmpty()) {
                object = this.nodesToAttach.removeFirst();
                boolean bl = this.nodesToAttach.getNewlyInsertedAndReset((Node)object);
                this.attach((Node)object, bl);
            }
            object = this.nodesToExpand.iterator();
            while (object.hasNext()) {
                TreeList.this.setExpanded((Node)object.next(), true);
            }
            this.nodesToExpand.clear();
        }

        private void attach(Node<E> node, boolean bl) {
            Node node2;
            this.current = node;
            this.expansionModel = bl ? TreeList.this.expansionModel : new CloneStateNewNodeStateModel(this.current);
            this.index = TreeList.this.data.indexOfNode(this.current.element, ALL_NODES);
            this.predecessor = this.current.previous();
            this.predecessorAtOurHeight = null;
            if (bl && (node2 = this.current.next()) != null) {
                this.nodesToAttach.queuePrefixForAttaching(node2);
            }
            this.attachParentsAndSiblings();
            this.fixVisibilityAndFireEvents();
            this.pathToRoot.clear();
        }

        private void attachParentsAndSiblings() {
            boolean bl = false;
            while (this.current != null) {
                int n2;
                int n3 = this.current.pathLength();
                int n4 = n2 = this.predecessor == null ? 0 : this.predecessor.pathLength();
                if (bl) {
                    this.incrementCurrent();
                    continue;
                }
                if (n3 > n2 + 1) {
                    this.createAndAttachParent();
                    continue;
                }
                if (n2 >= n3) {
                    this.incrementPredecessor();
                    continue;
                }
                if (TreeList.this.isAncestorByValue(this.current, this.predecessor)) {
                    assert (n3 == n2 + 1);
                    this.attachParent(this.predecessor, this.predecessorAtOurHeight);
                    bl = true;
                    continue;
                }
                assert (n3 == n2 + 1);
                assert (this.predecessor != null);
                this.createAndAttachParent();
                this.incrementPredecessor();
            }
        }

        private void incrementCurrent() {
            this.pathToRoot.add(this.current);
            this.current = this.current.parent;
        }

        private void incrementPredecessor() {
            if (this.predecessor.siblingAfter != null && this.predecessor.siblingAfter != this.current) {
                this.nodesToAttach.queueOutOfOrderNodeForAttaching(this.predecessor.siblingAfter);
                this.predecessor.siblingAfter.siblingBefore = null;
                this.predecessor.siblingAfter = null;
            }
            this.predecessorAtOurHeight = this.predecessor;
            this.predecessor = this.predecessor.parent;
        }

        private void createAndAttachParent() {
            Node node = this.current.describeParent();
            if (node != null) {
                node.expanded = this.expansionModel.isExpanded(node.getElement(), node.path);
                TreeList.this.addNode(node, HIDDEN_VIRTUAL, this.index);
            }
            this.attachParent(node, null);
        }

        private void attachParent(Node<E> node, Node<E> node2) {
            assert (this.current != null);
            assert (this.current.pathLength() == 1 && node == null || this.current.pathLength() == node.pathLength() + 1);
            if (node2 != null && node2.siblingAfter != this.current) {
                if (node2.pathLength() != this.current.pathLength()) {
                    throw new IllegalStateException();
                }
                assert (node2.parent == node);
                if (node2.siblingAfter != null) {
                    assert (this.current.siblingAfter == null);
                    this.current.siblingAfter = node2.siblingAfter;
                    node2.siblingAfter.siblingBefore = this.current;
                }
                this.current.siblingBefore = node2;
                node2.siblingAfter = this.current;
                assert (this.current.siblingBefore != this.current);
                assert (this.current.siblingAfter != this.current);
            }
            Node node3 = this.current;
            while (node3 != null) {
                node3.parent = node;
                node3 = node3.siblingAfter;
            }
            if (node != null && !node.expanded && this.current.isVisible()) {
                this.nodesToExpand.add(node);
            }
            this.incrementCurrent();
        }

        private void fixVisibilityAndFireEvents() {
            boolean bl = true;
            for (int i2 = this.pathToRoot.size() - 1; i2 >= 0; --i2) {
                this.current = this.pathToRoot.get(i2);
                if (bl) {
                    int n2;
                    if (!this.current.isVisible()) {
                        TreeList.this.setVisible(this.current, true);
                        n2 = TreeList.this.data.indexOfNode(this.current.element, VISIBLE_NODES);
                        if (this.fireEvents) {
                            TreeList.this.updates.addInsert(n2);
                        }
                    } else {
                        n2 = TreeList.this.data.indexOfNode(this.current.element, VISIBLE_NODES);
                        if (this.fireEvents) {
                            TreeList.this.updates.addUpdate(n2);
                        }
                    }
                }
                bl = bl && this.current.expanded;
            }
        }
    }

    private static class InitializationData<E> {
        private final Format<E> format;
        private final ExpansionModel<E> expansionModel;
        private final NodeComparator<E> nodeComparator;
        private final FunctionList<E, Node<E>> sourceNodes;
        private final SortedList<Node<E>> sortedList;

        public InitializationData(EventList<E> eventList, Format<E> format, ExpansionModel<E> expansionModel) {
            this.format = format;
            this.expansionModel = expansionModel;
            this.sourceNodes = new FunctionList(eventList, new ElementToTreeNodeFunction<E>(format, expansionModel), NO_OP_FUNCTION);
            this.nodeComparator = TreeList.comparatorToNodeComparator(format);
            this.sortedList = new SortedList<E>(this.sourceNodes, this.nodeComparator);
        }

        public EventList<Node<E>> getSource() {
            if (this.sortedList != null) {
                return this.sortedList;
            }
            return this.sourceNodes;
        }

        public void dispose() {
            if (this.sortedList != null) {
                this.sortedList.dispose();
            }
            this.sourceNodes.dispose();
        }
    }
}

