/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.AbstractEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;

public abstract class TransformedList<S, E>
extends AbstractEventList<E>
implements ListEventListener<S> {
    protected EventList<S> source;

    protected TransformedList(EventList<S> eventList) {
        super(eventList.getPublisher());
        this.source = eventList;
        this.readWriteLock = eventList.getReadWriteLock();
    }

    protected int getSourceIndex(int n2) {
        return n2;
    }

    protected abstract boolean isWritable();

    @Override
    public abstract void listChanged(ListEvent<S> var1);

    @Override
    public void add(int n2, E e2) {
        if (!this.isWritable()) {
            throw new IllegalStateException("Non-writable List cannot be modified");
        }
        if (n2 < 0 || n2 > this.size()) {
            throw new IndexOutOfBoundsException("Cannot add at " + n2 + " on list of size " + this.size());
        }
        int n3 = n2 < this.size() ? this.getSourceIndex(n2) : this.source.size();
        this.source.add(n3, e2);
    }

    @Override
    public E get(int n2) {
        if (n2 < 0 || n2 >= this.size()) {
            throw new IndexOutOfBoundsException("Cannot get at " + n2 + " on list of size " + this.size());
        }
        return this.source.get(this.getSourceIndex(n2));
    }

    @Override
    public E remove(int n2) {
        if (!this.isWritable()) {
            throw new IllegalStateException("Non-writable List cannot be modified");
        }
        if (n2 < 0 || n2 >= this.size()) {
            throw new IndexOutOfBoundsException("Cannot remove at " + n2 + " on list of size " + this.size());
        }
        return this.source.remove(this.getSourceIndex(n2));
    }

    @Override
    public E set(int n2, E e2) {
        if (!this.isWritable()) {
            throw new IllegalStateException("List " + this.getClass().getName() + " cannot be modified in the current state");
        }
        if (n2 < 0 || n2 >= this.size()) {
            throw new IndexOutOfBoundsException("Cannot set at " + n2 + " on list of size " + this.size());
        }
        return this.source.set(this.getSourceIndex(n2), e2);
    }

    @Override
    public int size() {
        return this.source.size();
    }

    @Override
    public void dispose() {
        this.source.removeListEventListener(this);
    }
}

