/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.RangeList;
import ca.odell.glazedlists.SortedList;
import java.util.Comparator;

public final class ThresholdList<E>
extends RangeList<E> {
    private int lowerThreshold = Integer.MIN_VALUE;
    private int upperThreshold = Integer.MAX_VALUE;
    private Evaluator<E> evaluator = null;
    private final SortedList<E> sortedSource;

    public ThresholdList(EventList<E> eventList, String string) {
        this(eventList, GlazedLists.thresholdEvaluator(string));
    }

    public ThresholdList(EventList<E> eventList, Evaluator<E> evaluator) {
        this(new SortedList<E>(eventList, new ThresholdComparator<E>(evaluator)), evaluator);
    }

    private ThresholdList(SortedList<E> sortedList, Evaluator<E> evaluator) {
        super(sortedList);
        this.sortedSource = sortedList;
        this.evaluator = evaluator;
    }

    public void setLowerThreshold(E e2) {
        this.setLowerThreshold(this.evaluator.evaluate(e2));
    }

    public void setLowerThreshold(int n2) {
        this.lowerThreshold = n2;
        this.adjustRange();
    }

    public int getLowerThreshold() {
        return this.lowerThreshold;
    }

    public void setUpperThreshold(E e2) {
        this.setUpperThreshold(this.evaluator.evaluate(e2));
    }

    public void setUpperThreshold(int n2) {
        this.upperThreshold = n2;
        this.adjustRange();
    }

    public int getUpperThreshold() {
        return this.upperThreshold;
    }

    public Evaluator<E> getEvaluator() {
        return this.evaluator;
    }

    @Override
    public boolean contains(Object object) {
        if (!this.withinRange(object)) {
            return false;
        }
        return this.source.contains(object);
    }

    @Override
    public int indexOf(Object object) {
        if (!this.withinRange(object)) {
            return -1;
        }
        return this.source.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        if (!this.withinRange(object)) {
            return -1;
        }
        return this.source.lastIndexOf(object);
    }

    private boolean withinRange(E e2) {
        int n2 = this.evaluator.evaluate(e2);
        return n2 >= this.lowerThreshold && n2 <= this.upperThreshold;
    }

    @Override
    public void setRange(int n2, int n3) {
        this.lowerThreshold = this.sourceIndexToThreshold(n2);
        this.upperThreshold = this.sourceIndexToThreshold(n3);
        this.adjustRange();
    }

    @Override
    public void setTailRange(int n2, int n3) {
        this.lowerThreshold = this.sourceIndexToThreshold(this.source.size() - n2);
        this.upperThreshold = this.sourceIndexToThreshold(this.source.size() - n3);
        this.adjustRange();
    }

    private int sourceIndexToThreshold(int n2) {
        if (n2 < 0) {
            return Integer.MIN_VALUE;
        }
        if (n2 < this.source.size()) {
            return this.evaluator.evaluate(this.source.get(n2));
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int getStartIndex() {
        return this.sortedSource.sortIndex(new Integer(this.lowerThreshold));
    }

    @Override
    public int getEndIndex() {
        int n2 = this.sortedSource.lastSortIndex(new Integer(this.upperThreshold));
        if (n2 < this.sortedSource.size() && this.evaluator.evaluate(this.sortedSource.get(n2)) == this.upperThreshold) {
            ++n2;
        }
        return n2;
    }

    @Override
    public void dispose() {
        this.sortedSource.dispose();
        super.dispose();
    }

    static final class ThresholdComparator<E>
    implements Comparator<E> {
        private Evaluator<E> evaluator = null;

        ThresholdComparator(Evaluator<E> evaluator) {
            this.evaluator = evaluator;
        }

        @Override
        public int compare(E e2, E e3) {
            int n2;
            int n3 = e2 instanceof Integer ? ((Integer)e2).intValue() : this.evaluator.evaluate(e2);
            if (n3 > (n2 = e3 instanceof Integer ? ((Integer)e3).intValue() : this.evaluator.evaluate(e3))) {
                return 1;
            }
            if (n3 < n2) {
                return -1;
            }
            return 0;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ThresholdComparator thresholdComparator = (ThresholdComparator)object;
            return this.evaluator.equals(thresholdComparator.evaluator);
        }

        public int hashCode() {
            return this.evaluator.hashCode();
        }
    }

    @FunctionalInterface
    public static interface Evaluator<E> {
        public int evaluate(E var1);
    }
}

