/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.util.List;

public class SyncListener<E>
implements ListEventListener<E> {
    private EventList<E> source;
    private List<E> target;
    private int targetSize;

    public SyncListener(EventList<E> eventList, List<E> list) {
        this.source = eventList;
        this.target = list;
        list.clear();
        list.addAll(eventList);
        this.targetSize = list.size();
        eventList.addListEventListener(this);
    }

    @Override
    public void listChanged(ListEvent<E> listEvent) {
        EventList<E> eventList = listEvent.getSourceList();
        if (this.target.size() != this.targetSize) {
            throw new IllegalStateException("Synchronize EventList target has been modified");
        }
        while (listEvent.next()) {
            int n2 = listEvent.getIndex();
            int n3 = listEvent.getType();
            if (n3 == 2) {
                this.target.add(n2, eventList.get(n2));
                ++this.targetSize;
                continue;
            }
            if (n3 == 1) {
                this.target.set(n2, eventList.get(n2));
                continue;
            }
            if (n3 != 0) continue;
            this.target.remove(n2);
            --this.targetSize;
        }
    }

    public void dispose() {
        if (this.source != null) {
            this.source.removeListEventListener(this);
            this.source = null;
            this.target = null;
        }
    }
}

