/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.impl.adt.barcode2.Element;
import ca.odell.glazedlists.impl.adt.barcode2.SimpleTree;
import ca.odell.glazedlists.impl.adt.barcode2.SimpleTreeIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;

public final class SortedList<E>
extends TransformedList<E, E> {
    private static final byte ALL_COLORS = 1;
    private static final Element EMPTY_ELEMENT = null;
    public static final int STRICT_SORT_ORDER = 0;
    public static final int AVOID_MOVING_ELEMENTS = 1;
    private SimpleTree<Element> unsorted = null;
    private SimpleTree<Element> sorted = null;
    private Comparator<? super E> comparator = null;
    private int mode = 0;

    public static <E extends Comparable<? super E>> SortedList<E> create(EventList<E> eventList) {
        return new SortedList<E>(eventList);
    }

    public SortedList(EventList<E> eventList) {
        this(eventList, GlazedLists.comparableComparator());
    }

    public SortedList(EventList<E> eventList, Comparator<? super E> comparator) {
        super(eventList);
        this.setComparator(comparator);
        eventList.addListEventListener(this);
    }

    public void setMode(int n2) {
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("Mode must be either SortedList.STRICT_SORT_ORDER or SortedList.AVOID_MOVING_ELEMENTS");
        }
        if (n2 == this.mode) {
            return;
        }
        this.mode = n2;
        if (this.mode == 0) {
            this.setComparator(this.getComparator());
        }
    }

    public int getMode() {
        return this.mode;
    }

    @Override
    public void listChanged(ListEvent<E> listEvent) {
        Element<Object> element;
        Element<Element<Object>> element2;
        int n2;
        int n3;
        if (listEvent.isReordering()) {
            int[] nArray = listEvent.getReorderMap();
            int[] nArray2 = new int[this.sorted.size()];
            int n4 = 0;
            Object object = new SimpleTreeIterator<Element>(this.sorted);
            while (((SimpleTreeIterator)object).hasNext()) {
                ((SimpleTreeIterator)object).next();
                Element element3 = ((SimpleTreeIterator)object).value();
                int n5 = this.unsorted.indexOfNode(element3, (byte)1);
                nArray2[n5] = n4++;
            }
            object = new int[this.sorted.size()];
            for (int i2 = 0; i2 < nArray2.length; ++i2) {
                object[i2] = nArray2[nArray[i2]];
            }
            Element[] elementArray = new Element[this.unsorted.size()];
            n4 = 0;
            Object object2 = new SimpleTreeIterator<Element>(this.unsorted);
            while (((SimpleTreeIterator)object2).hasNext()) {
                Element<Element> element4;
                ((SimpleTreeIterator)object2).next();
                elementArray[n4] = element4 = ((SimpleTreeIterator)object2).node();
                ++n4;
            }
            Arrays.sort(elementArray, this.sorted.getComparator());
            object2 = new int[this.sorted.size()];
            boolean bl = false;
            n4 = 0;
            SimpleTreeIterator<Element> simpleTreeIterator = new SimpleTreeIterator<Element>(this.sorted);
            while (simpleTreeIterator.hasNext()) {
                simpleTreeIterator.next();
                Element<Element> element5 = simpleTreeIterator.node();
                Element element6 = elementArray[n4];
                element5.set(element6);
                element6.set(element5);
                int n6 = this.unsorted.indexOfNode(element6, (byte)1);
                object2[n4] = object[n6];
                bl = bl || n4 != object2[n4];
                ++n4;
            }
            if (bl) {
                this.updates.beginEvent();
                this.updates.reorder((int[])object2);
                this.updates.commitEvent();
            }
            return;
        }
        this.updates.beginEvent();
        LinkedList<Element<Element>> linkedList = new LinkedList<Element<Element>>();
        ArrayList<Element<Object>> arrayList = new ArrayList<Element<Object>>();
        ArrayList<E> arrayList2 = new ArrayList<E>();
        while (listEvent.next()) {
            n3 = listEvent.getIndex();
            n2 = listEvent.getType();
            if (n2 == 2) {
                element2 = this.unsorted.add(n3, EMPTY_ELEMENT, 1);
                linkedList.addLast(element2);
                continue;
            }
            if (n2 == 1) {
                element2 = this.unsorted.get(n3);
                element = element2.get();
                element.setSorted(2);
                arrayList.add(element);
                arrayList2.add(listEvent.getOldValue());
                continue;
            }
            if (n2 != 0) continue;
            element2 = this.unsorted.get(n3);
            element = listEvent.getOldValue();
            this.unsorted.remove(element2);
            int n7 = this.deleteByUnsortedNode(element2);
            this.updates.elementDeleted(n7, element);
        }
        n2 = arrayList.size();
        for (n3 = 0; n3 < n2; ++n3) {
            Element element7;
            element2 = (Element<Element>)arrayList.get(n3);
            if (element2.getSorted() != 2) continue;
            element = null;
            Element<Element<Object>> element8 = null;
            Element<Element<Object>> element9 = element2;
            for (element7 = element2.previous(); element7 != null; element7 = element7.previous()) {
                if (element7.getSorted() == 0) {
                    element = element7;
                    break;
                }
                element9 = element7;
            }
            for (element7 = element2.next(); element7 != null; element7 = element7.next()) {
                if (element7.getSorted() != 0) continue;
                element8 = element7;
                break;
            }
            element7 = this.sorted.getComparator();
            for (Element<Element<Object>> element10 = element9; element10 != element8; element10 = element10.next()) {
                if (element8 != null && element7.compare(element10.get(), element8.get()) > 0) {
                    element10.setSorted(1);
                    continue;
                }
                if (element != null && element7.compare(element10.get(), (Object)element.get()) < 0) {
                    element10.setSorted(1);
                    continue;
                }
                element10.setSorted(0);
                element = element10;
            }
        }
        n2 = arrayList.size();
        for (n3 = 0; n3 < n2; ++n3) {
            element2 = arrayList2.get(n3);
            element = (Element)arrayList.get(n3);
            assert (element.getSorted() != 2);
            int n8 = this.sorted.indexOfNode(element, (byte)1);
            if (element.getSorted() == 0) {
                this.updates.elementUpdated(n8, element2);
                continue;
            }
            if (this.mode == 1) {
                this.updates.elementUpdated(n8, element2);
                continue;
            }
            this.sorted.remove(element);
            this.updates.elementDeleted(n8, element2);
            int n9 = this.insertByUnsortedNode((Element)element.get());
            this.updates.addInsert(n9);
        }
        while (!linkedList.isEmpty()) {
            Element element11 = (Element)linkedList.removeFirst();
            n2 = this.insertByUnsortedNode(element11);
            this.updates.addInsert(n2);
        }
        this.updates.commitEvent();
    }

    private int insertByUnsortedNode(Element element) {
        Element<Element> element2 = this.sorted.addInSortedOrder((byte)1, element, 1);
        element.set(element2);
        return this.sorted.indexOfNode(element2, (byte)1);
    }

    private int deleteByUnsortedNode(Element element) {
        Element element2 = (Element)element.get();
        int n2 = this.sorted.indexOfNode(element2, (byte)1);
        this.sorted.remove(n2, 1);
        return n2;
    }

    @Override
    protected int getSourceIndex(int n2) {
        Element<Element> element = this.sorted.get(n2);
        Element element2 = element.get();
        return this.unsorted.indexOfNode(element2, (byte)1);
    }

    @Override
    protected boolean isWritable() {
        return true;
    }

    public Comparator<? super E> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<? super E> comparator) {
        this.comparator = comparator;
        SimpleTree<Element> simpleTree = this.sorted;
        Comparator comparator2 = comparator != null ? new ElementComparator(comparator) : new ElementRawOrderComparator();
        this.sorted = new SimpleTree(comparator2);
        if (simpleTree == null && this.unsorted == null) {
            this.unsorted = new SimpleTree();
            int n2 = this.source.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Element<Element> element = this.unsorted.add(i2, EMPTY_ELEMENT, 1);
                this.insertByUnsortedNode(element);
            }
            return;
        }
        if (this.source.isEmpty()) {
            return;
        }
        Object object = new SimpleTreeIterator<Element>(this.unsorted);
        while (((SimpleTreeIterator)object).hasNext()) {
            ((SimpleTreeIterator)object).next();
            Element<Element> element = ((SimpleTreeIterator)object).node();
            this.insertByUnsortedNode(element);
        }
        object = new int[this.size()];
        int n3 = 0;
        SimpleTreeIterator<Element> simpleTreeIterator = new SimpleTreeIterator<Element>(simpleTree);
        while (simpleTreeIterator.hasNext()) {
            simpleTreeIterator.next();
            Element<Element> element = simpleTreeIterator.node();
            Element element2 = element.get();
            Element element3 = (Element)element2.get();
            int n4 = this.sorted.indexOfNode(element3, (byte)1);
            object[n4] = n3;
            ++n3;
        }
        this.updates.beginEvent();
        this.updates.reorder((int[])object);
        this.updates.commitEvent();
    }

    @Override
    public int indexOf(Object object) {
        if (this.mode != 0 || this.comparator == null) {
            return super.indexOf(object);
        }
        int n2 = this.sorted.indexOfValue((Element)object, true, false, (byte)1);
        if (n2 == -1) {
            return -1;
        }
        while (n2 < this.size()) {
            Object e2 = this.get(n2);
            if (this.comparator.compare(object, e2) != 0) {
                return -1;
            }
            if (Objects.equals(object, e2)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        if (this.mode != 0 || this.comparator == null) {
            return super.lastIndexOf(object);
        }
        int n2 = this.sorted.indexOfValue((Element)object, false, false, (byte)1);
        if (n2 == -1) {
            return -1;
        }
        while (n2 > -1) {
            Object e2 = this.get(n2);
            if (this.comparator.compare(object, e2) != 0) {
                return -1;
            }
            if (Objects.equals(object, e2)) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    public int sortIndex(Object object) {
        if (this.comparator == null) {
            throw new IllegalStateException("No Comparator exists to perform this operation");
        }
        return this.sorted.indexOfValue((Element)object, true, true, (byte)1);
    }

    public int lastSortIndex(Object object) {
        if (this.comparator == null) {
            throw new IllegalStateException("No Comparator exists to perform this operation");
        }
        return this.sorted.indexOfValue((Element)object, false, true, (byte)1);
    }

    @Deprecated
    public int indexOfSimulated(Object object) {
        return this.comparator != null ? this.sorted.indexOfValue((Element)object, true, true, (byte)1) : this.size();
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public Iterator<E> iterator() {
        return new SortedListIterator();
    }

    private class SortedListIterator
    implements Iterator<E> {
        private SimpleTreeIterator<Element> treeIterator;

        private SortedListIterator() {
            this.treeIterator = new SimpleTreeIterator(SortedList.this.sorted);
        }

        @Override
        public boolean hasNext() {
            return this.treeIterator.hasNext();
        }

        @Override
        public E next() {
            this.treeIterator.next();
            Element element = this.treeIterator.value();
            return SortedList.this.source.get(SortedList.this.unsorted.indexOfNode(element, (byte)1));
        }

        @Override
        public void remove() {
            int n2 = this.treeIterator.index();
            SortedList.this.source.remove(SortedList.this.getSourceIndex(n2));
            this.treeIterator = new SimpleTreeIterator(SortedList.this.sorted, n2, 1);
        }
    }

    private class ElementRawOrderComparator
    implements Comparator {
        private ElementRawOrderComparator() {
        }

        public int compare(Object object, Object object2) {
            Element element = (Element)object;
            Element element2 = (Element)object2;
            int n2 = SortedList.this.unsorted.indexOfNode(element, (byte)1);
            int n3 = SortedList.this.unsorted.indexOfNode(element2, (byte)1);
            return n2 - n3;
        }
    }

    private class ElementComparator
    implements Comparator {
        private Comparator comparator;

        public ElementComparator(Comparator comparator) {
            this.comparator = comparator;
        }

        public int compare(Object object, Object object2) {
            int n2;
            Element element;
            Object object3 = object;
            Object object4 = object2;
            int n3 = -1;
            int n4 = -1;
            if (object instanceof Element) {
                element = (Element)object;
                n3 = SortedList.this.unsorted.indexOfNode(element, (byte)1);
                object3 = SortedList.this.source.get(n3);
            }
            if (object2 instanceof Element) {
                element = (Element)object2;
                n4 = SortedList.this.unsorted.indexOfNode(element, (byte)1);
                object4 = SortedList.this.source.get(n4);
            }
            if ((n2 = this.comparator.compare(object3, object4)) != 0) {
                return n2;
            }
            if (n3 != -1 && n4 != -1) {
                return n3 - n4;
            }
            return 0;
        }
    }
}

