/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;

public final class SequenceList<E>
extends TransformedList<E, E>
implements RandomAccess {
    private final List<E> sequence = new ArrayList();
    private final Comparator<? super E> comparator;
    private final Sequencer<E> sequencer;

    public SequenceList(EventList<E> eventList, Sequencer<E> sequencer) {
        this(eventList, sequencer, GlazedLists.comparableComparator());
    }

    public SequenceList(EventList<E> eventList, Sequencer<E> sequencer, Comparator<? super E> comparator) {
        this(new SortedList<E>(eventList, comparator), sequencer, comparator);
    }

    private SequenceList(SortedList<E> sortedList, Sequencer<E> sequencer, Comparator<? super E> comparator) {
        super(sortedList);
        if (sequencer == null) {
            throw new IllegalArgumentException("sequencer may not be null");
        }
        if (comparator == null) {
            throw new IllegalArgumentException("comparator may not be null");
        }
        this.sequencer = sequencer;
        this.comparator = comparator;
        this.updateSequence();
        sortedList.addListEventListener(this);
    }

    @Override
    protected boolean isWritable() {
        return false;
    }

    @Override
    public int size() {
        return this.sequence.size();
    }

    @Override
    public E get(int n2) {
        return this.sequence.get(n2);
    }

    private boolean isSequenceValue(E e2) {
        E e3 = this.sequencer.previous(this.sequencer.next(e2));
        return this.comparator.compare(e2, e3) == 0;
    }

    public E getPreviousSequenceValue(E e2) {
        if (this.isSequenceValue(e2)) {
            return e2;
        }
        return this.sequencer.previous(e2);
    }

    public E getNextSequenceValue(E e2) {
        if (this.isSequenceValue(e2)) {
            return e2;
        }
        return this.sequencer.next(e2);
    }

    @Override
    public void listChanged(ListEvent<E> listEvent) {
        this.updateSequence();
    }

    private void updateSequence() {
        this.updates.beginEvent();
        if (this.source.isEmpty()) {
            while (!this.sequence.isEmpty()) {
                this.updates.elementDeleted(0, this.sequence.remove(0));
            }
        } else {
            Object e2;
            Object e3;
            Object e4;
            if (this.isEmpty()) {
                e4 = this.source.get(0);
                e3 = this.getPreviousSequenceValue(e4);
                e2 = this.getNextSequenceValue(e4);
                this.sequence.add(0, e3);
                this.updates.elementInserted(0, e3);
                this.sequence.add(1, e2);
                this.updates.elementInserted(1, e2);
            }
            e4 = this.source.get(0);
            while (this.comparator.compare(e4, this.get(0)) == -1) {
                e3 = this.sequencer.previous(this.get(0));
                this.sequence.add(0, e3);
                this.updates.elementInserted(0, e3);
            }
            while (this.comparator.compare(this.get(1), e4) == -1) {
                e3 = this.sequence.remove(0);
                this.updates.elementDeleted(0, e3);
            }
            e3 = this.source.get(this.source.size() - 1);
            while (this.comparator.compare(e3, this.get(this.size() - 1)) == 1) {
                e2 = this.sequencer.next(this.get(this.size() - 1));
                int n2 = this.size();
                this.sequence.add(n2, e2);
                this.updates.elementInserted(n2, e2);
            }
            while (this.comparator.compare(this.get(this.size() - 2), e3) == 1) {
                int n3 = this.size() - 1;
                this.updates.elementDeleted(n3, this.sequence.remove(n3));
            }
        }
        this.updates.commitEvent();
    }

    public static interface Sequencer<E> {
        public E previous(E var1);

        public E next(E var1);
    }
}

